/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.Urn;
import br.gov.lexml.dominio.urn.obra.FragmentoObraIndividual;
import br.gov.lexml.dominio.urn.obra.FragmentoObraIndividualImpl;
import br.gov.lexml.dominio.urn.obra.ObraComplexa;
import br.gov.lexml.dominio.urn.obra.ObraComplexaImpl;
import br.gov.lexml.dominio.urn.obra.ObraIndividual;
import br.gov.lexml.dominio.urn.obra.ObraIndividualImpl;
import java.security.InvalidParameterException;

public class URNImpl
implements Urn {
    private String textoUrn;
    private ObraComplexa obraComplexa;
    private ObraIndividual obraIndividual;
    private FragmentoObraIndividual fragmentoObraIndividual;

    public URNImpl() {
    }

    public URNImpl(String urn) throws UrnInvalidaException {
        this.setTexto(urn);
    }

    public FragmentoObraIndividual getFragmentoObraIndividual() {
        return this.fragmentoObraIndividual;
    }

    public ObraComplexa getObraComplexa() {
        return this.obraComplexa;
    }

    public ObraIndividual getObraIndividual() {
        return this.obraIndividual;
    }

    public String getTexto() {
        return this.textoUrn;
    }

    public String getTextoNormalizado() throws UrnInvalidaException {
        return null;
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        this.textoUrn = texto;
        this.obraComplexa = new ObraComplexaImpl(this.textoUrn);
        try {
            this.obraIndividual = new ObraIndividualImpl(this.obraComplexa, texto);
            this.fragmentoObraIndividual = new FragmentoObraIndividualImpl(this.obraIndividual, texto);
        }
        catch (UrnInvalidaException urnInvalidaException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.textoUrn;
    }

    public void valida() throws UrnInvalidaException {
        if (this.obraComplexa == null) {
            throw new UrnInvalidaException("A URN n\u00c3\u00a3o possui obra complexa.");
        }
        try {
            this.obraComplexa.valida();
            if (this.obraIndividual != null) {
                this.obraIndividual.valida();
            }
            if (this.fragmentoObraIndividual != null) {
                this.fragmentoObraIndividual.valida();
            }
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }
}

