/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.autoridade;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.autoridade.AutoridadeNormaHierarquiaSuperior;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class AutoridadeNormaHierarquiaSuperiorImpl
extends ElementoUrnAbstractImpl
implements AutoridadeNormaHierarquiaSuperior {
    public AutoridadeNormaHierarquiaSuperiorImpl(String texto) throws UrnInvalidaException {
        this.setTexto(texto);
    }

    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
        if (!Arrays.asList(AutoridadeNormaHierarquiaSuperior.Autoridades).contains(this.getTexto())) {
            throw new InvalidParameterException("Autoridade inv\u00c3\u00a1lida: " + this.getTexto());
        }
    }

    public void valida() throws InvalidParameterException {
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            String[] elementos = null;
            elementos = texto.split(":");
            super.setTexto(elementos[3]);
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }
}

