/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.data;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.data.DataObraComplexa;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DataObraComplexaImpl
extends ElementoUrnAbstractImpl
implements DataObraComplexa {
    public DataObraComplexaImpl(String texto) throws UrnInvalidaException {
        this.setTexto(texto);
    }

    public Calendar getData() {
        try {
            String[] data = super.getTexto().split("-");
            return new GregorianCalendar(Integer.valueOf(data[0]), Integer.valueOf(data[1]), Integer.valueOf(data[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void validaSintaxe() throws InvalidParameterException {
        if (StringUtil.isVazia(super.getTexto())) {
            throw new InvalidParameterException("Data n\u00c3\u00a3o foi informada.");
        }
        if (this.getData() == null && !super.getTexto().matches("^([1][9]\\d\\d|200[0-6])$")) {
            throw new InvalidParameterException("Data inv\u00c3\u00a1lida");
        }
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            String[] elementos = null;
            elementos = texto.split(":");
            String d = elementos[5];
            String data = d.substring(0, d.indexOf(59));
            super.setTexto(data);
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    public void valida() throws InvalidParameterException {
    }

    public String toString() {
        return this.getTexto();
    }
}

