/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.obra;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnFactory;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.autoridade.Autoridade;
import br.gov.lexml.dominio.urn.data.DataObraComplexa;
import br.gov.lexml.dominio.urn.descritor.Descritor;
import br.gov.lexml.dominio.urn.localizacao.Localizacao;
import br.gov.lexml.dominio.urn.obra.ObraAbstractImpl;
import br.gov.lexml.dominio.urn.obra.ObraComplexa;
import br.gov.lexml.dominio.urn.tipoDocumento.TipoDocumento;
import java.security.InvalidParameterException;

public class ObraComplexaImpl
extends ObraAbstractImpl
implements ObraComplexa {
    private Localizacao localizacao;
    private Autoridade autoridade;
    private TipoDocumento tipoDocumento;
    private DataObraComplexa dataObraComplexa;
    private Descritor descritor;

    public ObraComplexaImpl(String urn) throws UrnInvalidaException {
        this.setTexto(urn);
    }

    private void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaNamespace(this.textoUrn);
        this.validaNumeroDeElementos(this.textoUrn);
    }

    private void validaNumeroDeElementos(String urn) throws InvalidParameterException {
        int count = 0;
        int i = 0;
        while (i < urn.length()) {
            if (":".equals(String.valueOf(urn.charAt(i)))) {
                ++count;
            }
            ++i;
        }
        if (count != 5) {
            throw new InvalidParameterException();
        }
    }

    public void setTexto(String urn) throws UrnInvalidaException {
        int inicio = 0;
        int fim = urn.length();
        try {
            if (urn.contains("@")) {
                fim = urn.indexOf("@");
            }
            this.textoUrn = urn.substring(inicio, fim);
            this.validaSintaxe();
            this.montaElementos();
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    private void montaElementos() throws UrnInvalidaException {
        this.localizacao = ElementoUrnFactory.getInstance().getLocalizacao(this.getTexto());
        this.autoridade = ElementoUrnFactory.getInstance().getAutoridade(this.getTexto());
        this.tipoDocumento = ElementoUrnFactory.getInstance().getTipoDocumento(this.getTexto());
        this.dataObraComplexa = ElementoUrnFactory.getInstance().getDataObraComplexa(this.getTexto());
        this.descritor = ElementoUrnFactory.getInstance().getDescritor(this.getTexto());
    }

    public void valida() throws InvalidParameterException {
        this.localizacao.valida();
        this.autoridade.valida();
        this.tipoDocumento.valida();
        this.dataObraComplexa.valida();
        this.descritor.valida();
    }
}

