/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.tipoDocumento;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.tipoDocumento.PublicacaoOficial;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;

public class PublicacaoOficialImpl
extends ElementoUrnAbstractImpl
implements PublicacaoOficial {
    private String[] tipos;

    public PublicacaoOficialImpl(String texto) throws UrnInvalidaException {
        this.setTexto(texto);
    }

    public String getNome() {
        try {
            return this.tipos[PublicacaoOficial.Tipos.Nome.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSecao() {
        try {
            return this.tipos[PublicacaoOficial.Tipos.Secao.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTipo() {
        return "publicacao.oficial";
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            String[] elementos = null;
            elementos = texto.split(":");
            this.tipos = elementos[4].split(";");
            super.setTexto(elementos[4]);
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
        if (!StringUtil.isVazia(this.getSecao()) && StringUtil.isVazia(this.getNome())) {
            throw new InvalidParameterException();
        }
        if (this.getTipo() == null) {
            throw new InvalidParameterException();
        }
    }

    public void valida() throws InvalidParameterException {
    }
}

