/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;

public class NonstrictReadWriteCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Log log = LogFactory.getLog(NonstrictReadWriteCache.class);

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug("Cache lookup: " + key);
        }
        if ((result = this.cache.get(key)) != null) {
            log.debug("Cache hit");
        } else {
            log.debug("Cache miss");
        }
        return result;
    }

    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.get(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + key);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching: " + key);
        }
        this.cache.put(key, value);
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        return null;
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Removing: " + key);
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Clearing");
        }
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", e);
        }
    }

    public void evict(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating: " + key);
        }
        this.cache.remove(key);
    }

    public boolean insert(Object key, Object value, Object currentVersion) {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        this.evict(key);
        return false;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating (again): " + key);
        }
        this.cache.remove(key);
    }

    public boolean afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        this.release(key, lock);
        return false;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public String toString() {
        return this.cache + "(nonstrict-read-write)";
    }
}

