/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.FilterJoinTables;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.WhereJoinTable;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.IdBagBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.MapBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PrimitiveArrayBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionBinder {
    private static final Log log = LogFactory.getLog(CollectionBinder.class);
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    PropertyHolder propertyHolder;
    int batchSize;
    private String mappedBy;
    private XClass collectionType;
    private XClass targetEntity;
    private ExtendedMappings mappings;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    private String orderBy;
    protected String hqlOrderBy;
    private boolean isSorted;
    private Class comparator;
    private boolean hasToBeSorted;
    protected boolean cascadeDeleteEnabled;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    private Ejb3JoinColumn[] fkJoinColumns;
    private boolean isExplicitAssociationTable;
    private Ejb3Column[] elementColumns;
    private boolean isEmbedded;
    private XProperty property;
    private boolean ignoreNotFound;
    private TableBinder tableBinder;
    private Ejb3Column[] mapKeyColumns;
    private Ejb3JoinColumn[] mapKeyManyToManyColumns;
    protected HashMap<String, IdGenerator> localGenerators;
    private String propertyAccessorName;
    private Ejb3JoinColumn[] joinColumns;

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(Ejb3JoinColumn[] joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setEjb3OrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            this.hqlOrderBy = orderByAnn.value();
        }
    }

    public void setSqlOrderBy(org.hibernate.annotations.OrderBy orderByAnn) {
        if (orderByAnn != null && !BinderHelper.isDefault(orderByAnn.clause())) {
            this.orderBy = orderByAnn.clause();
        }
    }

    public void setSort(Sort sortAnn) {
        if (sortAnn != null) {
            boolean bl = this.isSorted = !SortType.UNSORTED.equals((Object)sortAnn.type());
            if (this.isSorted && SortType.COMPARATOR.equals((Object)sortAnn.type())) {
                this.comparator = sortAnn.comparator();
            }
        }
    }

    public static CollectionBinder getCollectionBinder(String entityName, XProperty property, boolean isIndexed) {
        if (property.isArray()) {
            if (property.getElementClass().isPrimitive()) {
                return new PrimitiveArrayBinder();
            }
            return new ArrayBinder();
        }
        if (property.isCollection()) {
            Class<? extends Collection> returnedClass = property.getCollectionClass();
            if (Set.class.equals(returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                return new SetBinder();
            }
            if (SortedSet.class.equals(returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                return new SetBinder(true);
            }
            if (Map.class.equals(returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                return new MapBinder();
            }
            if (SortedMap.class.equals(returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                return new MapBinder(true);
            }
            if (Collection.class.equals(returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    return new IdBagBinder();
                }
                return new BagBinder();
            }
            if (List.class.equals(returnedClass)) {
                if (isIndexed) {
                    if (property.isAnnotationPresent(CollectionId.class)) {
                        throw new AnnotationException("List do not support @CollectionId and @IndexColumn at the same time: " + StringHelper.qualify(entityName, property.getName()));
                    }
                    return new ListBinder();
                }
                if (property.isAnnotationPresent(CollectionId.class)) {
                    return new IdBagBinder();
                }
                return new BagBinder();
            }
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported: " + StringHelper.qualify(entityName, property.getName()));
        }
        throw new AnnotationException("Illegal attempt to map a non collection as a @OneToMany, @ManyToMany or @CollectionOfElements: " + StringHelper.qualify(entityName, property.getName()));
    }

    protected CollectionBinder() {
    }

    protected CollectionBinder(boolean sorted) {
        this.hasToBeSorted = sorted;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public void setTableBinder(TableBinder tableBinder) {
        this.tableBinder = tableBinder;
    }

    public void setCollectionType(XClass collectionType) {
        this.collectionType = collectionType;
    }

    public void setTargetEntity(XClass targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void bind() {
        Persister persisterAnn;
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        log.debug("Collection role: " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        this.collection.setRole(StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        this.collection.setNodeName(this.propertyName);
        if (this.property.isAnnotationPresent(MapKey.class) && this.mapKeyPropertyName != null) {
            throw new AnnotationException("Cannot mix @javax.persistence.MapKey and @org.hibernate.annotations.MapKey on the same collection: " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        this.defineFetchingStrategy();
        this.collection.setBatchSize(this.batchSize);
        if (this.orderBy != null && this.hqlOrderBy != null) {
            throw new AnnotationException("Cannot use sql order by clause in conjunction of EJB3 order by clause: " + this.safeCollectionRole());
        }
        this.collection.setMutable(!this.property.isAnnotationPresent(Immutable.class));
        OptimisticLock lockAnn = this.property.getAnnotation(OptimisticLock.class);
        if (lockAnn != null) {
            this.collection.setOptimisticLocked(!lockAnn.excluded());
        }
        if ((persisterAnn = this.property.getAnnotation(Persister.class)) != null) {
            this.collection.setCollectionPersisterClass(persisterAnn.impl());
        }
        if (this.orderBy != null) {
            this.collection.setOrderBy(this.orderBy);
        }
        if (this.isSorted) {
            this.collection.setSorted(true);
            if (this.comparator != null) {
                try {
                    this.collection.setComparator((Comparator)this.comparator.newInstance());
                }
                catch (ClassCastException e) {
                    throw new AnnotationException("Comparator not implementing java.util.Comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
                catch (Exception e) {
                    throw new AnnotationException("Could not instantiate comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
            }
        } else if (this.hasToBeSorted) {
            throw new AnnotationException("A sorted collection has to define @Sort: " + this.safeCollectionRole());
        }
        if (StringHelper.isNotEmpty(this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        SQLInsert sqlInsert = this.property.getAnnotation(SQLInsert.class);
        SQLUpdate sqlUpdate = this.property.getAnnotation(SQLUpdate.class);
        SQLDelete sqlDelete = this.property.getAnnotation(SQLDelete.class);
        SQLDeleteAll sqlDeleteAll = this.property.getAnnotation(SQLDeleteAll.class);
        Loader loader = this.property.getAnnotation(Loader.class);
        if (sqlInsert != null) {
            this.collection.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.parse(sqlInsert.check().toString().toLowerCase()));
        }
        if (sqlUpdate != null) {
            this.collection.setCustomSQLUpdate(sqlUpdate.sql(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.parse(sqlUpdate.check().toString().toLowerCase()));
        }
        if (sqlDelete != null) {
            this.collection.setCustomSQLDelete(sqlDelete.sql(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.parse(sqlDelete.check().toString().toLowerCase()));
        }
        if (sqlDeleteAll != null) {
            this.collection.setCustomSQLDeleteAll(sqlDeleteAll.sql(), sqlDeleteAll.callable(), ExecuteUpdateResultCheckStyle.parse(sqlDeleteAll.check().toString().toLowerCase()));
        }
        if (loader != null) {
            this.collection.setLoaderName(loader.namedQuery());
        }
        boolean isMappedBy = !BinderHelper.isDefault(this.mappedBy);
        this.collection.setInverse(isMappedBy);
        if (!this.oneToMany && isMappedBy) {
            this.mappings.addMappedBy(this.getCollectionType().getName(), this.mappedBy, this.propertyName);
        }
        XClass collectionType = this.getCollectionType();
        SecondPass sp = this.getSecondPass(this.fkJoinColumns, this.joinColumns, this.inverseJoinColumns, this.elementColumns, this.mapKeyColumns, this.mapKeyManyToManyColumns, this.isEmbedded, this.property, collectionType, this.ignoreNotFound, this.oneToMany, this.tableBinder, this.mappings);
        if (collectionType.isAnnotationPresent(Embeddable.class) || this.property.isAnnotationPresent(CollectionOfElements.class)) {
            this.mappings.addSecondPass(sp, !isMappedBy);
        } else {
            this.mappings.addSecondPass(sp, !isMappedBy);
        }
        this.mappings.addCollection(this.collection);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue(this.collection);
        binder.setCascade(this.cascadeStrategy);
        if (this.cascadeStrategy != null && this.cascadeStrategy.indexOf("delete-orphan") >= 0) {
            this.collection.setOrphanDelete(true);
        }
        binder.setPropertyAccessorName(this.propertyAccessorName);
        binder.setProperty(this.property);
        binder.setInsertable(this.insertable);
        binder.setUpdatable(this.updatable);
        Property prop = binder.make();
        this.propertyHolder.addProperty(prop);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void defineFetchingStrategy() {
        FetchType fetchType;
        LazyCollection lazy = this.property.getAnnotation(LazyCollection.class);
        Fetch fetch = this.property.getAnnotation(Fetch.class);
        OneToMany oneToMany = this.property.getAnnotation(OneToMany.class);
        ManyToMany manyToMany = this.property.getAnnotation(ManyToMany.class);
        CollectionOfElements elements = this.property.getAnnotation(CollectionOfElements.class);
        ManyToAny manyToAny = this.property.getAnnotation(ManyToAny.class);
        if (oneToMany != null) {
            fetchType = oneToMany.fetch();
        } else if (manyToMany != null) {
            fetchType = manyToMany.fetch();
        } else if (elements != null) {
            fetchType = elements.fetch();
        } else {
            if (manyToAny == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @ManyToOne nor @OneToMany nor @CollectionOfElements");
            fetchType = FetchType.LAZY;
        }
        if (lazy != null) {
            this.collection.setLazy(lazy.value() != LazyCollectionOption.FALSE);
            this.collection.setExtraLazy(lazy.value() == LazyCollectionOption.EXTRA);
        } else {
            this.collection.setLazy(fetchType == FetchType.LAZY);
            this.collection.setExtraLazy(false);
        }
        if (fetch != null) {
            if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
                this.collection.setFetchMode(FetchMode.JOIN);
                this.collection.setLazy(false);
                return;
            } else if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
                this.collection.setFetchMode(FetchMode.SELECT);
                return;
            } else {
                if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
                this.collection.setFetchMode(FetchMode.SELECT);
                this.collection.setSubselectLoadable(true);
                this.collection.getOwner().setSubselectLoadableCollections(true);
            }
            return;
        } else {
            this.collection.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
        }
    }

    private XClass getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity, this.mappings)) {
            if (this.collectionType != null) {
                return this.collectionType;
            }
            String errorMsg = "Collection has neither generic type or OneToMany.targetEntity() defined: " + this.safeCollectionRole();
            throw new AnnotationException(errorMsg);
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] fkJoinColumns, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final Ejb3Column[] elementColumns, Ejb3Column[] mapKeyColumns, Ejb3JoinColumn[] mapKeyManyToManyColumns, final boolean isEmbedded, final XProperty property, final XClass collType, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final ExtendedMappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                CollectionBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, assocTableBinder, ignoreNotFound, mappings);
            }
        };
    }

    protected boolean bindStarToManySecondPass(Map persistentClasses, XClass collType, Ejb3JoinColumn[] fkJoinColumns, Ejb3JoinColumn[] keyColumns, Ejb3JoinColumn[] inverseColumns, Ejb3Column[] elementColumns, boolean isEmbedded, XProperty property, boolean unique, TableBinder associationTableBinder, boolean ignoreNotFound, ExtendedMappings mappings) {
        PersistentClass persistentClass = (PersistentClass)persistentClasses.get(collType.getName());
        boolean reversePropertyInJoin = false;
        if (persistentClass != null && StringHelper.isNotEmpty(this.mappedBy)) {
            try {
                reversePropertyInJoin = 0 != persistentClass.getJoinNumber(persistentClass.getRecursiveProperty(this.mappedBy));
            }
            catch (MappingException e) {
                StringBuilder error = new StringBuilder(80);
                error.append("mappedBy reference an unknown target entity property: ").append(collType).append(".").append(this.mappedBy).append(" in ").append(this.collection.getOwnerEntityName()).append(".").append(property.getName());
                throw new AnnotationException(error.toString());
            }
        }
        if (persistentClass != null && !reversePropertyInJoin && this.oneToMany && !this.isExplicitAssociationTable && (this.joinColumns[0].isImplicit() && !BinderHelper.isDefault(this.mappedBy) || !fkJoinColumns[0].isImplicit())) {
            this.bindOneToManySecondPass(this.getCollection(), persistentClasses, fkJoinColumns, collType, this.cascadeDeleteEnabled, ignoreNotFound, this.hqlOrderBy, mappings);
            return true;
        }
        this.bindManyToManySecondPass(this.collection, persistentClasses, keyColumns, inverseColumns, elementColumns, isEmbedded, collType, ignoreNotFound, unique, this.cascadeDeleteEnabled, associationTableBinder, property, this.propertyHolder, this.hqlOrderBy, mappings);
        return false;
    }

    protected void bindOneToManySecondPass(org.hibernate.mapping.Collection collection, Map persistentClasses, Ejb3JoinColumn[] fkJoinColumns, XClass collectionType, boolean cascadeDeleteEnabled, boolean ignoreNotFound, String hqlOrderBy, ExtendedMappings extendedMappings) {
        if (log.isDebugEnabled()) {
            log.debug("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through a foreign key");
        }
        org.hibernate.mapping.OneToMany oneToMany = new org.hibernate.mapping.OneToMany(collection.getOwner());
        collection.setElement(oneToMany);
        oneToMany.setReferencedEntityName(collectionType.getName());
        oneToMany.setIgnoreNotFound(ignoreNotFound);
        String assocClass = oneToMany.getReferencedEntityName();
        PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
        String orderBy = CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, associatedClass, collection.getRole());
        if (orderBy != null) {
            collection.setOrderBy(orderBy);
        }
        if (this.mappings == null) {
            throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
        }
        Map<String, Join> joins = this.mappings.getJoins(assocClass);
        if (associatedClass == null) {
            throw new MappingException("Association references unmapped class: " + assocClass);
        }
        oneToMany.setAssociatedClass(associatedClass);
        for (Ejb3JoinColumn column : fkJoinColumns) {
            column.setPersistentClass(associatedClass, joins);
            column.setJoins(joins);
            collection.setCollectionTable(column.getTable());
        }
        log.info("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName());
        this.bindFilters(false);
        CollectionBinder.bindCollectionSecondPass(collection, null, fkJoinColumns, cascadeDeleteEnabled, this.property, this.mappings);
        if (!collection.isInverse() && !collection.getKey().isNullable()) {
            String entityName = oneToMany.getReferencedEntityName();
            PersistentClass referenced = this.mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + fkJoinColumns[0].getPropertyName() + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collection.getRole());
            prop.setEntityName(collection.getOwner().getEntityName());
            prop.setValue(collection.getKey());
            referenced.addProperty(prop);
        }
    }

    private void bindFilters(boolean hasAssociationTable) {
        WhereJoinTable whereJoinTable;
        String whereJoinTableClause;
        Where where;
        String whereClause;
        FilterJoinTables filterJoinTables;
        FilterJoinTable simpleFilterJoinTable;
        Filters filters;
        Filter simpleFilter = this.property.getAnnotation(Filter.class);
        if (simpleFilter != null) {
            if (hasAssociationTable) {
                this.collection.addManyToManyFilter(simpleFilter.name(), this.getCondition(simpleFilter));
            } else {
                this.collection.addFilter(simpleFilter.name(), this.getCondition(simpleFilter));
            }
        }
        if ((filters = this.property.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filters.value()) {
                if (hasAssociationTable) {
                    this.collection.addManyToManyFilter(filter.name(), this.getCondition(filter));
                    continue;
                }
                this.collection.addFilter(filter.name(), this.getCondition(filter));
            }
        }
        if ((simpleFilterJoinTable = this.property.getAnnotation(FilterJoinTable.class)) != null) {
            if (hasAssociationTable) {
                this.collection.addFilter(simpleFilterJoinTable.name(), this.getCondition(simpleFilterJoinTable));
            } else {
                throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
        if ((filterJoinTables = this.property.getAnnotation(FilterJoinTables.class)) != null) {
            for (FilterJoinTable filter : filterJoinTables.value()) {
                if (!hasAssociationTable) {
                    throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
                }
                this.collection.addFilter(filter.name(), this.getCondition(filter));
            }
        }
        String string = whereClause = (where = this.property.getAnnotation(Where.class)) == null ? null : where.clause();
        if (StringHelper.isNotEmpty(whereClause)) {
            if (hasAssociationTable) {
                this.collection.setManyToManyWhere(whereClause);
            } else {
                this.collection.setWhere(whereClause);
            }
        }
        String string2 = whereJoinTableClause = (whereJoinTable = this.property.getAnnotation(WhereJoinTable.class)) == null ? null : whereJoinTable.clause();
        if (StringHelper.isNotEmpty(whereJoinTableClause)) {
            if (hasAssociationTable) {
                this.collection.setWhere(whereJoinTableClause);
            } else {
                throw new AnnotationException("Illegal use of @WhereJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
    }

    private String getCondition(FilterJoinTable filter) {
        String name = filter.name();
        String cond = filter.condition();
        return this.getCondition(cond, name);
    }

    private String getCondition(Filter filter) {
        String name = filter.name();
        String cond = filter.condition();
        return this.getCondition(cond, name);
    }

    private String getCondition(String cond, String name) {
        if (BinderHelper.isDefault(cond) && StringHelper.isEmpty(cond = this.mappings.getFilterDefinition(name).getDefaultFilterCondition())) {
            throw new AnnotationException("no filter condition found for filter " + name + " in " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        return cond;
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegionName = BinderHelper.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(javax.persistence.MapKey key) {
        if (key != null) {
            this.mapKeyPropertyName = key.name();
        }
    }

    private static String buildOrderByClauseFromHql(String hqlOrderBy, PersistentClass associatedClass, String role) {
        String orderByString = null;
        if (hqlOrderBy != null) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> ordering = new ArrayList<String>();
            StringBuilder orderByBuffer = new StringBuilder();
            if (hqlOrderBy.length() == 0) {
                Iterator it = associatedClass.getIdentifier().getColumnIterator();
                while (it.hasNext()) {
                    Selectable col = (Selectable)it.next();
                    orderByBuffer.append(col.getText()).append(" asc").append(", ");
                }
            } else {
                StringTokenizer st = new StringTokenizer(hqlOrderBy, " ,", false);
                String currentOrdering = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (CollectionBinder.isNonPropertyToken(token)) {
                        if (currentOrdering != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + hqlOrderBy + " (" + role + ")");
                        }
                        currentOrdering = token;
                        continue;
                    }
                    if (currentOrdering == null) {
                        ordering.add("asc");
                    } else {
                        ordering.add(currentOrdering);
                        currentOrdering = null;
                    }
                    properties.add(token);
                }
                ordering.remove(0);
                if (currentOrdering == null) {
                    ordering.add("asc");
                } else {
                    ordering.add(currentOrdering);
                    currentOrdering = null;
                }
                int index = 0;
                for (String property : properties) {
                    Property p = BinderHelper.findPropertyByName(associatedClass, property);
                    if (p == null) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + associatedClass.getEntityName() + "." + property);
                    }
                    PersistentClass pc = p.getPersistentClass();
                    String table = pc == null ? "" : (pc != associatedClass ? pc.getTable().getQuotedName() + "." : "");
                    Iterator propertyColumns = p.getColumnIterator();
                    while (propertyColumns.hasNext()) {
                        Selectable column = (Selectable)propertyColumns.next();
                        orderByBuffer.append(table).append(column.getText()).append(" ").append((String)ordering.get(index)).append(", ");
                    }
                    ++index;
                }
            }
            orderByString = orderByBuffer.substring(0, orderByBuffer.length() - 2);
        }
        return orderByString;
    }

    private static String buildOrderByClauseFromHql(String hqlOrderBy, Component component, String role) {
        String orderByString = null;
        if (hqlOrderBy != null) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> ordering = new ArrayList<String>();
            StringBuilder orderByBuffer = new StringBuilder();
            if (hqlOrderBy.length() != 0) {
                StringTokenizer st = new StringTokenizer(hqlOrderBy, " ,", false);
                String currentOrdering = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (CollectionBinder.isNonPropertyToken(token)) {
                        if (currentOrdering != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + hqlOrderBy + " (" + role + ")");
                        }
                        currentOrdering = token;
                        continue;
                    }
                    if (currentOrdering == null) {
                        ordering.add("asc");
                    } else {
                        ordering.add(currentOrdering);
                        currentOrdering = null;
                    }
                    properties.add(token);
                }
                ordering.remove(0);
                if (currentOrdering == null) {
                    ordering.add("asc");
                } else {
                    ordering.add(currentOrdering);
                    currentOrdering = null;
                }
                int index = 0;
                for (String property : properties) {
                    Property p = component.getProperty(property);
                    if (p == null) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + role + "." + property);
                    }
                    Iterator propertyColumns = p.getColumnIterator();
                    while (propertyColumns.hasNext()) {
                        Selectable column = (Selectable)propertyColumns.next();
                        orderByBuffer.append(column.getText()).append(" ").append((String)ordering.get(index)).append(", ");
                    }
                    ++index;
                }
                if (orderByBuffer.length() >= 2) {
                    orderByString = orderByBuffer.substring(0, orderByBuffer.length() - 2);
                }
            }
        }
        return orderByString;
    }

    private static boolean isNonPropertyToken(String token) {
        if (" ".equals(token)) {
            return true;
        }
        if (",".equals(token)) {
            return true;
        }
        if (token.equalsIgnoreCase("desc")) {
            return true;
        }
        return token.equalsIgnoreCase("asc");
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, XProperty property, ExtendedMappings mappings) {
        String fkName;
        String propRef;
        String entityName;
        String propRef2;
        if (joinColumns.length > 0 && StringHelper.isNotEmpty(joinColumns[0].getMappedBy()) && (propRef2 = mappings.getPropertyReferencedAssociation(entityName = joinColumns[0].getManyToManyOwnerSideEntityName() != null ? "inverse__" + joinColumns[0].getManyToManyOwnerSideEntityName() : joinColumns[0].getPropertyHolder().getEntityName(), joinColumns[0].getMappedBy())) != null) {
            collValue.setReferencedPropertyName(propRef2);
            mappings.addPropertyReference(collValue.getOwnerEntityName(), propRef2);
        }
        KeyValue keyVal = (propRef = collValue.getReferencedPropertyName()) == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getRecursiveProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3Column.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setNullable(joinColumns.length == 0 || joinColumns[0].isNullable());
        key.setUpdateable(joinColumns.length == 0 || joinColumns[0].isUpdatable());
        key.setCascadeDeleteEnabled(cascadeDeleteEnabled);
        collValue.setKey(key);
        ForeignKey fk = property != null ? property.getAnnotation(ForeignKey.class) : null;
        String string = fkName = fk != null ? fk.name() : "";
        if (!BinderHelper.isDefault(fkName)) {
            key.setForeignKeyName(fkName);
        }
        return key;
    }

    protected void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, Ejb3Column[] elementColumns, boolean isEmbedded, XClass collType, boolean ignoreNotFound, boolean unique, boolean cascadeDeleteEnabled, TableBinder associationTableBinder, XProperty property, PropertyHolder parentPropertyHolder, String hqlOrderBy, ExtendedMappings mappings) throws MappingException {
        boolean mappedBy;
        String path;
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType.getName());
        boolean isCollectionOfEntities = collectionEntity != null;
        ManyToAny anyAnn = property.getAnnotation(ManyToAny.class);
        if (log.isDebugEnabled()) {
            path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
            if (isCollectionOfEntities && unique) {
                log.debug("Binding a OneToMany: " + path + " through an association table");
            } else if (isCollectionOfEntities) {
                log.debug("Binding as ManyToMany: " + path);
            } else if (anyAnn != null) {
                log.debug("Binding a ManyToAny: " + path);
            } else {
                log.debug("Binding a collection of element: " + path);
            }
        }
        if (!isCollectionOfEntities) {
            if (property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(OneToMany.class)) {
                path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                throw new AnnotationException("Use of @OneToMany or @ManyToMany targeting an unmapped class: " + path + "[" + collType + "]");
            }
            if (anyAnn != null) {
                if (!property.isAnnotationPresent(JoinTable.class)) {
                    path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                    throw new AnnotationException("@JoinTable is mandatory when @ManyToAny is used: " + path);
                }
            } else {
                JoinTable joinTableAnn = property.getAnnotation(JoinTable.class);
                if (joinTableAnn != null && joinTableAnn.inverseJoinColumns().length > 0) {
                    String path2 = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                    throw new AnnotationException("Use of @JoinTable.inverseJoinColumns targeting an unmapped class: " + path2 + "[" + collType + "]");
                }
            }
        }
        boolean bl = mappedBy = !BinderHelper.isDefault(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            if (!isCollectionOfEntities) {
                StringBuilder error = new StringBuilder(80).append("Collection of elements must not have mappedBy or association reference an unmapped entity: ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            try {
                otherSideProperty = collectionEntity.getRecursiveProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                StringBuilder error = new StringBuilder(80);
                error.append("mappedBy reference an unknown target entity property: ").append(collType).append(".").append(joinColumns[0].getMappedBy()).append(" in ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            Table table = otherSideProperty.getValue() instanceof org.hibernate.mapping.Collection ? ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable() : otherSideProperty.getValue().getTable();
            collValue.setCollectionTable(table);
            String entityName = collectionEntity.getEntityName();
            for (Ejb3JoinColumn column : joinColumns) {
                column.setManyToManyOwnerSideEntityName(entityName);
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String mappedByProperty = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                Table ownerTable = collValue.getOwner().getTable();
                column.setMappedBy(collValue.getOwner().getEntityName(), mappings.getLogicalTableName(ownerTable), mappedByProperty);
            }
            if (StringHelper.isEmpty(associationTableBinder.getName())) {
                associationTableBinder.setDefaultName(collValue.getOwner().getEntityName(), mappings.getLogicalTableName(collValue.getOwner().getTable()), collectionEntity != null ? collectionEntity.getEntityName() : null, collectionEntity != null ? mappings.getLogicalTableName(collectionEntity.getTable()) : null, joinColumns[0].getPropertyName());
            }
            collValue.setCollectionTable(associationTableBinder.bind());
        }
        this.bindFilters(isCollectionOfEntities);
        CollectionBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns, cascadeDeleteEnabled, property, mappings);
        ManyToOne element = null;
        if (isCollectionOfEntities) {
            String fkName;
            element = new ManyToOne(collValue.getCollectionTable());
            collValue.setElement(element);
            element.setReferencedEntityName(collType.getName());
            element.setFetchMode(FetchMode.JOIN);
            element.setLazy(false);
            element.setIgnoreNotFound(ignoreNotFound);
            if (StringHelper.isNotEmpty(hqlOrderBy)) {
                collValue.setManyToManyOrdering(CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, collectionEntity, collValue.getRole()));
            }
            ForeignKey fk = property != null ? property.getAnnotation(ForeignKey.class) : null;
            String string = fkName = fk != null ? fk.inverseName() : "";
            if (!BinderHelper.isDefault(fkName)) {
                element.setForeignKeyName(fkName);
            }
        } else if (anyAnn != null) {
            PropertyInferredData inferredData = new PropertyInferredData(property, "unsupported", mappings.getReflectionManager());
            for (Ejb3JoinColumn column : inverseJoinColumns) {
                column.setTable(collValue.getCollectionTable());
            }
            Any any = BinderHelper.buildAnyValue(anyAnn.metaDef(), inverseJoinColumns, anyAnn.metaColumn(), inferredData, cascadeDeleteEnabled, Nullability.NO_CONSTRAINT, this.propertyHolder, new EntityBinder(), true, mappings);
            collValue.setElement(any);
        } else {
            XClass elementClass;
            AnnotatedClassType classType;
            PropertyHolder holder = null;
            if (BinderHelper.PRIMITIVE_NAMES.contains(collType.getName())) {
                classType = AnnotatedClassType.NONE;
                elementClass = null;
            } else {
                boolean attributeOverride;
                elementClass = collType;
                classType = mappings.getClassType(elementClass);
                holder = PropertyHolderBuilder.buildPropertyHolder(collValue, collValue.getRole(), elementClass, property, parentPropertyHolder, mappings);
                boolean bl2 = attributeOverride = property.isAnnotationPresent(AttributeOverride.class) || property.isAnnotationPresent(AttributeOverrides.class);
                if (isEmbedded || attributeOverride) {
                    classType = AnnotatedClassType.EMBEDDABLE;
                }
            }
            if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
                String path3;
                String orderBy;
                boolean isPropertyAnnotated;
                EntityBinder entityBinder = new EntityBinder();
                PersistentClass owner = collValue.getOwner();
                if (owner.getIdentifierProperty() != null) {
                    isPropertyAnnotated = owner.getIdentifierProperty().getPropertyAccessorName().equals("property");
                } else if (owner.getIdentifierMapper() != null && owner.getIdentifierMapper().getPropertySpan() > 0) {
                    Property prop = (Property)owner.getIdentifierMapper().getPropertyIterator().next();
                    isPropertyAnnotated = prop.getPropertyAccessorName().equals("property");
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                PropertyPreloadedData inferredData = new PropertyPreloadedData("property", "element", elementClass);
                Component component = AnnotationBinder.fillComponent(holder, inferredData, isPropertyAnnotated, isPropertyAnnotated ? "property" : "field", true, entityBinder, false, false, true, mappings);
                collValue.setElement(component);
                if (StringHelper.isNotEmpty(hqlOrderBy) && (orderBy = CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, component, path3 = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName())) != null) {
                    collValue.setOrderBy(orderBy);
                }
            } else {
                SimpleValueBinder elementBinder = new SimpleValueBinder();
                elementBinder.setMappings(mappings);
                elementBinder.setReturnedClassName(collType.getName());
                if (elementColumns == null || elementColumns.length == 0) {
                    elementColumns = new Ejb3Column[1];
                    Ejb3Column column = new Ejb3Column();
                    column.setImplicit(false);
                    column.setNullable(true);
                    column.setLength(255);
                    column.setLogicalColumnName("elt");
                    column.setJoins(new HashMap<String, Join>());
                    column.setMappings(mappings);
                    column.bind();
                    elementColumns[0] = column;
                }
                for (Ejb3Column column : elementColumns) {
                    column.setTable(collValue.getCollectionTable());
                }
                elementBinder.setColumns(elementColumns);
                elementBinder.setType(property, elementClass);
                collValue.setElement(elementBinder.make());
            }
        }
        CollectionBinder.checkFilterConditions(collValue);
        if (isCollectionOfEntities) {
            CollectionBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, element, unique, mappings);
        }
    }

    private static void checkFilterConditions(org.hibernate.mapping.Collection collValue) {
        if ((collValue.getFilterMap().size() != 0 || StringHelper.isNotEmpty(collValue.getWhere())) && collValue.getFetchMode() == FetchMode.JOIN && !(collValue.getElement() instanceof SimpleValue) && collValue.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("@ManyToMany or @CollectionOfElements defining filter or where without join fetching not valid within collection using join fetching[" + collValue.getRole() + "]");
        }
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, XProperty property, ExtendedMappings mappings) {
        BinderHelper.createSyntheticPropertyReference(joinColumns, collValue.getOwner(), collectionEntity, collValue, false, mappings);
        SimpleValue key = CollectionBinder.buildCollectionKey(collValue, joinColumns, cascadeDeleteEnabled, property, mappings);
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false, mappings);
    }

    public void setCascadeDeleteEnabled(boolean onDeleteCascade) {
        this.cascadeDeleteEnabled = onDeleteCascade;
    }

    private String safeCollectionRole() {
        if (this.propertyHolder != null) {
            return this.propertyHolder.getEntityName() + "." + this.propertyName;
        }
        return "";
    }

    public static void bindManytoManyInverseFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique, ExtendedMappings mappings) {
        String mappedBy = columns[0].getMappedBy();
        if (StringHelper.isNotEmpty(mappedBy)) {
            Iterator mappedByColumns;
            Property property = referencedEntity.getRecursiveProperty(mappedBy);
            if (property.getValue() instanceof org.hibernate.mapping.Collection) {
                mappedByColumns = ((org.hibernate.mapping.Collection)property.getValue()).getKey().getColumnIterator();
            } else {
                Iterator joinsIt = referencedEntity.getJoinIterator();
                Value key = null;
                while (joinsIt.hasNext()) {
                    Join join = (Join)joinsIt.next();
                    if (!join.containsProperty(property)) continue;
                    key = join.getKey();
                    break;
                }
                if (key == null) {
                    key = property.getPersistentClass().getIdentifier();
                }
                mappedByColumns = key.getColumnIterator();
            }
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
            String referencedPropertyName = mappings.getPropertyReferencedAssociation("inverse__" + referencedEntity.getEntityName(), mappedBy);
            if (referencedPropertyName != null) {
                ((ManyToOne)value).setReferencedPropertyName(referencedPropertyName);
                mappings.addUniquePropertyReference(referencedEntity.getEntityName(), referencedPropertyName);
            }
            value.createForeignKey();
        } else {
            BinderHelper.createSyntheticPropertyReference(columns, referencedEntity, null, value, true, mappings);
            TableBinder.bindFk(referencedEntity, null, columns, value, unique, mappings);
        }
    }

    public void setFkJoinColumns(Ejb3JoinColumn[] ejb3JoinColumns) {
        this.fkJoinColumns = ejb3JoinColumns;
    }

    public void setExplicitAssociationTable(boolean explicitAssocTable) {
        this.isExplicitAssociationTable = explicitAssocTable;
    }

    public void setElementColumns(Ejb3Column[] elementColumns) {
        this.elementColumns = elementColumns;
    }

    public void setEmbedded(boolean annotationPresent) {
        this.isEmbedded = annotationPresent;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public void setMapKeyColumns(Ejb3Column[] mapKeyColumns) {
        this.mapKeyColumns = mapKeyColumns;
    }

    public void setMapKeyManyToManyColumns(Ejb3JoinColumn[] mapJoinColumns) {
        this.mapKeyManyToManyColumns = mapJoinColumns;
    }

    public void setLocalGenerators(HashMap<String, IdGenerator> localGenerators) {
        this.localGenerators = localGenerators;
    }
}

