/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.ast.tree.AssignmentSpecification;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.UpdateStatement;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Update;
import org.hibernate.util.StringHelper;

public class MultiTableUpdateExecutor
extends AbstractStatementExecutor {
    private static final Log log = LogFactory.getLog(MultiTableUpdateExecutor.class);
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] updates;
    private final ParameterSpecification[][] hqlParameters;

    public MultiTableUpdateExecutor(HqlSqlWalker walker) {
        super(walker, log);
        if (!walker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot perform multi-table updates using dialect not supporting temp tables");
        }
        UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, bulkTargetAlias, updateStatement.getWhereClause());
        log.trace("Generated ID-INSERT-SELECT SQL (multi-table update) : " + this.idInsertSelect);
        String[] tableNames = this.persister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.persister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.persister);
        ArrayList assignmentSpecifications = walker.getAssignmentSpecifications();
        this.updates = new String[tableNames.length];
        this.hqlParameters = new ParameterSpecification[tableNames.length][];
        for (int tableIndex = 0; tableIndex < tableNames.length; ++tableIndex) {
            boolean affected = false;
            ArrayList<ParameterSpecification> parameterList = new ArrayList<ParameterSpecification>();
            Update update = new Update(this.getFactory().getDialect()).setTableName(tableNames[tableIndex]).setWhere("(" + StringHelper.join(", ", columnNames[tableIndex]) + ") IN (" + idSubselect + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                update.setComment("bulk update");
            }
            Iterator itr = assignmentSpecifications.iterator();
            while (itr.hasNext()) {
                AssignmentSpecification specification = (AssignmentSpecification)itr.next();
                if (!specification.affectsTable(tableNames[tableIndex])) continue;
                affected = true;
                update.appendAssignmentFragment(specification.getSqlAssignmentFragment());
                if (specification.getParameters() == null) continue;
                for (int paramIndex = 0; paramIndex < specification.getParameters().length; ++paramIndex) {
                    parameterList.add(specification.getParameters()[paramIndex]);
                }
            }
            if (!affected) continue;
            this.updates[tableIndex] = update.toStatementString();
            this.hqlParameters[tableIndex] = parameterList.toArray(new ParameterSpecification[0]);
        }
    }

    public Queryable getAffectedQueryable() {
        return this.persister;
    }

    public String[] getSqlStatements() {
        return this.updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        this.createTemporaryTableIfNecessary(this.persister, session);
        try {
            PreparedStatement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getBatcher().prepareStatement(this.idInsertSelect);
                    int parameterStart = this.getWalker().getNumberOfParametersInSetClause();
                    ArrayList allParams = this.getWalker().getParameters();
                    Iterator whereParams = allParams.subList(parameterStart, allParams.size()).iterator();
                    int sum = 1;
                    while (whereParams.hasNext()) {
                        sum += ((ParameterSpecification)whereParams.next()).bind(ps, parameters, session, sum);
                    }
                    resultCount = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        session.getBatcher().closeStatement(ps);
                    }
                }
            }
            catch (SQLException e) {
                throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "could not insert/select ids for bulk update", this.idInsertSelect);
            }
            for (int i = 0; i < this.updates.length; ++i) {
                if (this.updates[i] == null) continue;
                try {
                    try {
                        ps = session.getBatcher().prepareStatement(this.updates[i]);
                        if (this.hqlParameters[i] != null) {
                            int position = 1;
                            for (int x = 0; x < this.hqlParameters[i].length; ++x) {
                                position += this.hqlParameters[i][x].bind(ps, parameters, session, position);
                            }
                        }
                        ps.executeUpdate();
                        continue;
                    }
                    finally {
                        if (ps != null) {
                            session.getBatcher().closeStatement(ps);
                        }
                    }
                }
                catch (SQLException e) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "error performing bulk update", this.updates[i]);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, session);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

