/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class EnumType
implements EnhancedUserType,
ParameterizedType,
Serializable {
    private static Log log = LogFactory.getLog(EnumType.class);
    private static final boolean IS_TRACE_ENABLED = LogFactory.getLog(StringHelper.qualifier(Type.class.getName())).isTraceEnabled();
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    private static Map<Class, Object[]> enumValues = new HashMap<Class, Object[]>();
    private Class<? extends Enum> enumClass;
    private String column;
    private String table;
    private String catalog;
    private String schema;
    private boolean guessed = false;
    private int sqlType = 4;

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (IS_TRACE_ENABLED) {
                log.debug("Returning null as column " + names[0]);
            }
            return null;
        }
        if (object instanceof Number) {
            Object[] values = enumValues.get(this.enumClass);
            if (values == null) {
                throw new AssertionFailure("enumValues not preprocessed: " + this.enumClass);
            }
            int ordinal = ((Number)object).intValue();
            if (ordinal < 0 || ordinal >= values.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (IS_TRACE_ENABLED) {
                log.debug("Returning '" + ordinal + "' as column " + names[0]);
            }
            return values[ordinal];
        }
        String name = (String)object;
        if (IS_TRACE_ENABLED) {
            log.debug("Returning '" + name + "' as column " + names[0]);
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            if (IS_TRACE_ENABLED) {
                log.debug("Binding null to parameter: " + index);
            }
            st.setNull(index, this.sqlType);
        } else {
            boolean isOrdinal = this.isOrdinal(this.sqlType);
            if (isOrdinal) {
                int ordinal = ((Enum)value).ordinal();
                if (IS_TRACE_ENABLED) {
                    log.debug("Binding '" + ordinal + "' to parameter: " + index);
                }
                st.setObject(index, (Object)ordinal, this.sqlType);
            } else {
                String enumString = ((Enum)value).name();
                if (IS_TRACE_ENABLED) {
                    log.debug("Binding '" + enumString + "' to parameter: " + index);
                }
                st.setObject(index, (Object)enumString, this.sqlType);
            }
        }
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", exception);
        }
        this.initEnumValue();
        this.schema = parameters.getProperty(SCHEMA);
        if ("".equals(this.schema)) {
            this.schema = null;
        }
        this.catalog = parameters.getProperty(CATALOG);
        if ("".equals(this.catalog)) {
            this.catalog = null;
        }
        this.table = parameters.getProperty(TABLE);
        this.column = parameters.getProperty(COLUMN);
        String type = parameters.getProperty(TYPE);
        if (type != null) {
            this.sqlType = Integer.decode(type);
            this.guessed = true;
        }
    }

    private void initEnumValue() {
        Object[] values = enumValues.get(this.enumClass);
        if (values == null) {
            try {
                Method method = null;
                method = this.enumClass.getDeclaredMethod("values", new Class[0]);
                values = (Object[])method.invoke(null, new Object[0]);
                enumValues.put(this.enumClass, values);
            }
            catch (Exception e) {
                throw new HibernateException("Error while accessing enum.values(): " + this.enumClass, e);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initEnumValue();
    }

    public String objectToSQLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return '\'' + ((Enum)value).name() + '\'';
    }

    public String toXMLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return ((Enum)value).name();
    }

    public Object fromXMLString(String xmlValue) {
        try {
            int ordinal = Integer.parseInt(xmlValue);
            Object[] values = enumValues.get(this.enumClass);
            if (values == null) {
                throw new AssertionFailure("enumValues not preprocessed: " + this.enumClass);
            }
            if (ordinal < 0 || ordinal >= values.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            return values[ordinal];
        }
        catch (NumberFormatException e) {
            try {
                return Enum.valueOf(this.enumClass, xmlValue);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + xmlValue, iae);
            }
        }
    }
}

