/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.PrintWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.util.PrintClassVisitor;
import org.objectweb.asm.util.TraceCodeVisitor;

public class TraceClassVisitor
extends PrintClassVisitor {
    protected final ClassVisitor cv;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: TraceClassVisitor <fully qualified class name>");
            System.exit(-1);
        }
        ClassReader classReader = new ClassReader(stringArray[0]);
        classReader.accept(new TraceClassVisitor(null, new PrintWriter(System.out)), true);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        super(printWriter);
        this.cv = classVisitor;
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        this.buf.setLength(0);
        if ((n & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        if (string3 != null) {
            this.buf.append("// compiled from ").append(string3).append("\n");
        }
        this.appendAccess(n & 0xFFFFFFDF);
        if ((n & 0x200) != 0) {
            this.buf.append("interface ");
        } else {
            this.buf.append("class ");
        }
        this.buf.append(string).append(" ");
        if (string2 != null && !string2.equals("java/lang/Object")) {
            this.buf.append("extends ").append(string2).append(" ");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("implements ");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.buf.append(stringArray[n2]).append(" ");
                ++n2;
            }
        }
        this.buf.append("{\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visit(n, string, string2, stringArray, string3);
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.buf.setLength(0);
        this.buf.append("  INNERCLASS ").append(string).append(" ").append(string2).append(" ").append(string3).append(" ").append(n).append("\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitInnerClass(string, string2, string3, n);
        }
    }

    public void visitField(int n, String string, String string2, Object object) {
        this.buf.setLength(0);
        if ((n & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  ");
        this.appendAccess(n);
        this.buf.append(string2).append(" ").append(string);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append("\"").append(object).append("\"");
            } else {
                this.buf.append(object);
            }
        }
        this.buf.append("\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitField(n, string, string2, object);
        }
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray) {
        this.buf.setLength(0);
        if ((n & 0x20000) != 0) {
            this.buf.append("  // DEPRECATED\n");
        }
        this.buf.append("  ");
        this.appendAccess(n);
        this.buf.append(string).append(" ").append(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.buf.append(stringArray[n2]).append(" ");
                ++n2;
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        CodeVisitor codeVisitor = this.cv != null ? this.cv.visitMethod(n, string, string2, stringArray) : null;
        TraceCodeVisitor traceCodeVisitor = new TraceCodeVisitor(codeVisitor);
        this.text.add(traceCodeVisitor.getText());
        return traceCodeVisitor;
    }

    public void visitEnd() {
        this.text.add("}\n");
        if (this.cv != null) {
            this.cv.visitEnd();
        }
        super.visitEnd();
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
    }
}

