/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class BeanReferenceFactoryBean
implements FactoryBean,
BeanFactoryAware {
    private String targetBeanName;
    private BeanFactory beanFactory;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (this.targetBeanName == null) {
            throw new IllegalArgumentException("targetBeanName is required");
        }
        if (!this.beanFactory.containsBean(this.targetBeanName)) {
            throw new NoSuchBeanDefinitionException(this.targetBeanName, this.beanFactory.toString());
        }
    }

    public Object getObject() throws BeansException {
        if (this.beanFactory == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.beanFactory.getBean(this.targetBeanName);
    }

    public Class getObjectType() {
        return this.beanFactory.getType(this.targetBeanName);
    }

    public boolean isSingleton() {
        return this.beanFactory.isSingleton(this.targetBeanName);
    }
}

