/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml;

import br.gov.lexml.profileLexml.ConfiguracaoProvedorDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class LexMLUtil {
    private static String lexml_home_dir = System.getenv("LEXML_HOME");
    private static Logger logger = Logger.getLogger(LexMLUtil.class.getName());
    private static Properties jpa_properties = null;

    public static void setLexMLHome(String p_dir) {
        lexml_home_dir = p_dir;
        jpa_properties = null;
    }

    public static String getLexMLHome() {
        if (lexml_home_dir == null) {
            lexml_home_dir = System.getenv("LEXML_HOME");
        }
        return lexml_home_dir;
    }

    public static long nowInMillisGMT() {
        Date today = new Date();
        Calendar.getInstance();
        Calendar c = Calendar.getInstance(Locale.UK);
        return c.getTimeInMillis();
    }

    public static InputStream getInputStreamFromLexMLHome(String p_file) {
        InputStream iS = null;
        if (lexml_home_dir == null) {
            logger.info("LEXML_HOME n\u00e3o definido.");
            iS = LexMLUtil.class.getResourceAsStream("/" + p_file);
        } else {
            logger.debug("LEXML_HOME definido como:" + lexml_home_dir);
            try {
                iS = new FileInputStream(String.valueOf(lexml_home_dir) + File.separator + p_file);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FATAL, "Arquivo " + p_file + " n\u00e3o foi encontrado em LEXML_HOME nem no CLASSPATH");
                e.printStackTrace();
            }
        }
        return iS;
    }

    public static Properties getJPAProperties() {
        if (jpa_properties != null) {
            return jpa_properties;
        }
        Properties new_properties = new Properties();
        InputStream isProperties = LexMLUtil.getInputStreamFromLexMLHome("lexml-db.properties");
        if (isProperties != null) {
            try {
                new_properties.load(isProperties);
                jpa_properties = new_properties;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jpa_properties;
    }

    public static ConfiguracaoProvedorDocument readConfiguracaoProvedor(String p_file) {
        InputStream isPerfil = LexMLUtil.getInputStreamFromLexMLHome(p_file);
        ConfiguracaoProvedorDocument confProvedor = null;
        if (isPerfil != null) {
            XmlOptions xmlOpt = new XmlOptions();
            xmlOpt.setLoadStripComments();
            xmlOpt.setSaveNoXmlDecl();
            xmlOpt.setSavePrettyPrintIndent(3);
            xmlOpt.setLoadStripProcinsts();
            xmlOpt.setLoadStripProcinsts();
            xmlOpt.setSaveAggressiveNamespaces();
            ArrayList validationErrors = new ArrayList();
            xmlOpt.setErrorListener(validationErrors);
            try {
                confProvedor = ConfiguracaoProvedorDocument.Factory.parse(isPerfil, xmlOpt);
                if (!confProvedor.validate()) {
                    logger.log(Level.ERROR, "Validate do XMLBeans falhou para: " + p_file);
                }
            }
            catch (XmlException e) {
                logger.log(Level.ERROR, "Erro na leitura do arquivo:" + p_file);
                logger.log(Level.ERROR, e.getCause());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.log(Level.ERROR, "Erro na leitura do arquivo:" + p_file);
                logger.log(Level.ERROR, e.getCause());
                e.printStackTrace();
            }
            if (validationErrors.size() > 0) {
                Iterator iter = validationErrors.iterator();
                while (iter.hasNext()) {
                    logger.log(Level.ERROR, iter.next().toString());
                }
            }
        }
        return confProvedor;
    }
}

