/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.helper.Erros;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.oaiLexml.LexMLDocument;
import br.gov.lexml.oaiLexml.LexMLType;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidadorBO {
    private static Logger logger = Logger.getLogger(ValidadorBO.class.getName());
    private static int BUCKET_SIZE = 100;
    private static Erros m_erros = null;
    private static String SUCESSO = "RegistroItem validado com sucesso";
    private List<RegistroItemErro> errosList = null;
    private List<RegistroItemLog> logList = null;
    private List<RegistroItem> atualizados = null;
    private RegistroItemDAO m_dao = null;
    private LexMLConfig m_config = null;
    private static String SEP = ":";
    private HashMap<String, Boolean> perfis;
    private Erros.Erro erro;

    public ValidadorBO(int p_modo) throws ConfigFailedException {
        if (this.m_config == null) {
            LexMLConfig config = 1 == p_modo ? new LexMLConfig(1) : new LexMLConfig(0);
            this.m_config = config;
        }
        this.compilarPerfisValidos();
        this.m_dao = new RegistroItemDAO();
    }

    public void compilarPerfisValidos() {
        HashMap<String, Boolean> novosPerfis = new HashMap<String, Boolean>();
        if (this.m_config == null) {
            return;
        }
        ArrayList<LexMLConfig.Publicador> publicadores = this.m_config.getPublicadores();
        for (LexMLConfig.Publicador publicador : publicadores) {
            ArrayList<LexMLConfig.Perfil> perfil = publicador.getPerfil();
            if (perfil == null) continue;
            Iterator<LexMLConfig.Perfil> iter2 = perfil.iterator();
            while (iter2.hasNext()) {
                String nucleo = publicador.getIdPublicador().toString().concat(SEP).concat(iter2.next().getNucleoUrn());
                novosPerfis.put(nucleo, Boolean.TRUE);
                logger.log(Level.INFO, "PERFIL ADICIONADO: " + nucleo);
            }
        }
        this.perfis = novosPerfis;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean validarRegistroItem(RegistroItem ri, List<RegistroItemErro> p_errosList, List<RegistroItemLog> p_logList, boolean p_add_xml_declaration, boolean p_validar_urn, boolean p_atualiza_xml) {
        block16: {
            LexMLDocument doc = null;
            if (m_erros == null) {
                m_erros = Erros.getInstance();
            }
            String xml = ri.getTxMetadadoXml();
            logger.log(Level.WARN, "Iniciando validacao do registro: " + ri.getIdRegistroItem());
            String lexml = p_add_xml_declaration ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml : xml;
            ri.setCdValidacao("E");
            this.erro = ValidadorBO.m_erros.ERRO_GENERICO;
            if (!ri.getIdRegistroItem().trim().equals(ri.getIdRegistroItem())) {
                this.erro = ValidadorBO.m_erros.ERRO_GENERICO;
                p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, "ID_REGISTRO_ITEM n\u00e3o pode conter espa\u00e7os em branco"));
            } else {
                try {
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("lexml.xml"), "UTF8"));
                    out.write(lexml);
                    out.close();
                    xml.getBytes("UTF-8");
                    if (xml == null) {
                        this.erro = ValidadorBO.m_erros.ERRO_XML_MAL_FORMADO;
                        p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, "XML nulo foi passado para validacao"));
                        break block16;
                    }
                    try {
                        ArrayList validationErrors = new ArrayList();
                        XmlOptions validationOptions = new XmlOptions();
                        validationOptions.setCharacterEncoding("UTF-8");
                        validationOptions.setLoadStripProcinsts();
                        validationOptions.setErrorListener(validationErrors);
                        doc = LexMLDocument.Factory.parse(lexml, validationOptions);
                        if (doc.validate(validationOptions)) {
                            String tstURN = doc.getLexML().getDocumentoIndividual().getStringValue();
                            LexMLType.Item[] itens = doc.getLexML().getItemArray();
                            boolean urnValid = true;
                            if (p_validar_urn) {
                                int i = 0;
                                while (i < itens.length) {
                                    BigInteger idPublicador = itens[i].getIdPublicador();
                                    urnValid &= this.isURNValid(tstURN, idPublicador);
                                    ++i;
                                }
                            }
                            if (urnValid) {
                                ri.setCdValidacao("O");
                                p_logList.add(this.m_dao.newLogMsg(ri, SUCESSO));
                                logger.log(Level.WARN, "Registro : " + ri.getIdRegistroItem() + " validado com sucesso");
                                if (p_atualiza_xml) {
                                    ri.setTxMetadadoXml(doc.toString());
                                }
                                this.erro = null;
                                return true;
                            }
                            this.erro = ValidadorBO.m_erros.ERRO_URN_INCOMPATIVEL;
                            p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, "A URN:" + tstURN + " n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual de perfil"));
                        } else {
                            this.erro = ValidadorBO.m_erros.ERRO_XML_INVALIDO;
                            Iterator iterErros = validationErrors.iterator();
                            while (iterErros.hasNext()) {
                                p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, iterErros.next().toString()));
                            }
                        }
                    }
                    catch (XmlException e) {
                        this.erro = ValidadorBO.m_erros.ERRO_XML_MAL_FORMADO;
                        p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, String.valueOf(e.getMessage()) + e.getErrors().toString()));
                    }
                }
                catch (UnsupportedEncodingException e1) {
                    this.erro = ValidadorBO.m_erros.ERRO_XML_MAL_FORMADO;
                    p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, String.valueOf(e1.getMessage()) + e1.getCause().toString()));
                }
                catch (IOException e) {
                    this.erro = ValidadorBO.m_erros.ERRO_XML_MAL_FORMADO;
                    p_errosList.add(this.m_dao.newLogErr(ri, this.erro.tipo, e.getMessage()));
                }
            }
        }
        return false;
    }

    public boolean isURNValid(String p_urn, BigInteger p_idPublicador) throws ArrayIndexOutOfBoundsException {
        String[] part = p_urn.split(SEP);
        if (part.length < 5) {
            return false;
        }
        if ("urn".equalsIgnoreCase(part[0]) && "lex".equalsIgnoreCase(part[1])) {
            String tstNucleoURN = p_idPublicador.toString().concat(SEP).concat(part[2]).concat(SEP).concat(part[3]).concat(SEP).concat(part[4]);
            Boolean exist = this.perfis.get(tstNucleoURN);
            if (exist != null) {
                return exist;
            }
        } else {
            logger.log(Level.ERROR, "URN n\u00e3o encontrada no perfil:" + p_urn);
        }
        return false;
    }

    public void validarRegistrosIndefinidos() {
        if (this.m_config == null) {
            logger.log(Level.FATAL, "Ambiente nao configurado, verifique arquivo de configuracao:lexml_nbconfig.xml");
            return;
        }
        if (m_erros == null) {
            m_erros = Erros.getInstance();
        }
        this.atualizados = new ArrayList<RegistroItem>();
        this.errosList = new ArrayList<RegistroItemErro>();
        this.logList = new ArrayList<RegistroItemLog>();
        List<RegistroItem> list = this.m_dao.listUndefined();
        if (list.size() < 1) {
            logger.log(Level.WARN, "Nao havia registros indefinidos para serem validados");
            return;
        }
        int total = list.size();
        logger.log(Level.WARN, "Comecando a processar " + total + " registros.");
        Iterator<RegistroItem> iter = list.iterator();
        int sucessos = 0;
        this.m_dao.beginBulkMode();
        while (iter.hasNext()) {
            RegistroItem ri = iter.next();
            if (this.validarRegistroItem(ri, this.errosList, this.logList, true, true, false)) {
                ++sucessos;
            }
            if (this.erro != null) {
                logger.log(Level.ERROR, this.erro.msg);
            }
            this.erro = null;
            this.atualizados.add(ri);
            this.checkListsSizes(BUCKET_SIZE);
        }
        if (total > 0) {
            this.checkListsSizes(1);
            this.m_dao.bulkCommit();
            int erros = total - sucessos;
            logger.info("Total de registros processados: " + total);
            logger.info("Processados com sucesso: " + sucessos);
            logger.info("Registros que apresentavam erros: " + erros);
            int t = sucessos - sucessos * 100 / total * total / 100;
            int p = t * 10000 / total;
            logger.info("Aproveitamento de aproximadamente: " + sucessos * 100 / total + "," + p + "%");
        } else {
            this.m_dao.bulkRollBack();
        }
        System.gc();
    }

    private void checkListsSizes(int p_size) {
        if (this.m_dao == null) {
            return;
        }
        if (this.atualizados.size() >= p_size) {
            this.m_dao.update(this.atualizados);
            this.atualizados = new ArrayList<RegistroItem>();
            this.m_dao.bulkCommit();
            this.m_dao.beginBulkMode();
            logger.info("Realizando COMMIT, lista de registroitem");
            System.out.println("realizando commit com " + BUCKET_SIZE + " registros");
        }
        if (this.logList.size() >= p_size) {
            this.m_dao.saveRegistroItemLogList(this.logList);
            this.m_dao.bulkCommit();
            this.m_dao.beginBulkMode();
            this.logList = new ArrayList<RegistroItemLog>();
        }
        if (this.errosList.size() >= p_size) {
            this.m_dao.saveRegistroItemErroList(this.errosList);
            this.m_dao.bulkCommit();
            this.m_dao.beginBulkMode();
            this.errosList = new ArrayList<RegistroItemErro>();
        }
    }
}

