/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.dao.DAOConfig;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractDAO {
    private static final Logger logger = Logger.getLogger(AbstractDAO.class.getName());
    private static EntityManagerFactory m_emf_independente = null;
    private static EntityManagerFactory m_emf_injetada = null;
    private EntityTransaction m_bulk_trans = null;
    private EntityManager m_bulk_em = null;
    private static boolean loaded_auto_ids = false;

    public boolean inBulkMode() {
        return this.m_bulk_trans != null;
    }

    protected final EntityManager getEntityManager(EntityManagerFactory p_emf) {
        EntityManager em;
        if (p_emf == null && !DAOConfig.waitForSpringEMF()) {
            if (m_emf_independente == null) {
                Properties properties = LexMLUtil.getJPAProperties();
                m_emf_independente = Persistence.createEntityManagerFactory("borda-db", properties);
            }
            em = m_emf_independente.createEntityManager();
        } else {
            m_emf_injetada = p_emf;
            em = m_emf_injetada.createEntityManager();
        }
        if (loaded_auto_ids) {
            return em;
        }
        try {
            RegistroItemLog.setNextId(1);
            Query queryL = em.createQuery("SELECT ril FROM RegistroItemLog ril ORDER BY ril.idRegistroItemLog DESC");
            queryL.setMaxResults(1);
            RegistroItemLog ril = (RegistroItemLog)queryL.getSingleResult();
            if (ril != null) {
                RegistroItemLog.setNextId(ril.getIdRegistroItemLog() + 1);
            }
        }
        catch (NoResultException e) {
            logger.log(Level.WARN, "A tentativa de recuperar o valor maximo da chave da tabela registro_item_log falhou. Utilizando o valor 1.");
        }
        try {
            RegistroItemErro.setNextId(1);
            Query queryE = em.createQuery("SELECT rie FROM RegistroItemErro rie ORDER BY rie.idRegistroItemErro DESC");
            queryE.setMaxResults(1);
            RegistroItemErro rie = (RegistroItemErro)queryE.getSingleResult();
            if (rie != null) {
                RegistroItemErro.setNextId(rie.getIdRegistroItemErro() + 1);
            }
        }
        catch (NoResultException e) {
            logger.log(Level.WARN, "A tentativa de recuperar o valor maximo da chave da tabela registro_item_erro falhou. Utilizando o valor 1.");
        }
        loaded_auto_ids = true;
        return em;
    }

    public final void beginBulkMode(EntityManager p_em) {
        this.m_bulk_em = p_em;
        if (this.m_bulk_trans == null) {
            this.m_bulk_trans = p_em.getTransaction();
            this.m_bulk_trans.begin();
        }
    }

    public final void bulkPersist(Object p_object) {
        this.m_bulk_em.persist(p_object);
    }

    public final void bulkMerge(Object p_object) {
        this.m_bulk_em.merge(p_object);
    }

    public final void bulkCommit() {
        if (this.m_bulk_trans == null) {
            return;
        }
        if (this.m_bulk_trans.isActive()) {
            this.m_bulk_trans.commit();
        }
        this.m_bulk_trans = null;
    }

    public final void bulkRollBack() {
        if (this.m_bulk_trans == null) {
            return;
        }
        if (this.m_bulk_trans.isActive()) {
            this.m_bulk_trans.rollback();
        }
        this.m_bulk_trans = null;
    }
}

