/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.formaconteudo;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.formaconteudo.FormaConteudo;
import br.gov.lexml.dominio.urn.formaconteudo.Lingua;
import br.gov.lexml.dominio.urn.formaconteudo.LinguaImpl;
import br.gov.lexml.dominio.urn.formaconteudo.TipoConteudo;
import br.gov.lexml.dominio.urn.formaconteudo.TipoConteudoImpl;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormaConteudoImpl
extends ElementoUrnAbstractImpl
implements FormaConteudo {
    private TipoConteudo tipoConteudo;
    private List<Lingua> linguas;

    public FormaConteudoImpl(String texto) throws UrnInvalidaException {
        if (this.linguas == null) {
            this.linguas = new ArrayList<Lingua>();
        }
        this.setTexto(texto);
    }

    @Override
    public List<Lingua> getLinguas() {
        return this.linguas;
    }

    private String getLinguasAsString() {
        try {
            String[] formaConteudo = this.getTexto().split(";");
            return formaConteudo[FormaConteudo.Formas.Lingua.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public TipoConteudo getTipoConteudo() {
        return this.tipoConteudo;
    }

    private void setLingua(String lingua) throws UrnInvalidaException {
        String[] array;
        String[] stringArray = array = lingua.split(",");
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            LinguaImpl l = new LinguaImpl(s);
            this.linguas.add(l);
            ++n2;
        }
    }

    @Override
    public void setTexto(String texto) throws UrnInvalidaException {
        super.setTexto(texto);
        if (!StringUtil.isVazia(texto)) {
            this.setLingua(this.getLinguasAsString());
            this.tipoConteudo = new TipoConteudoImpl(texto);
            this.validaSintaxe();
        }
    }

    @Override
    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
    }

    @Override
    public void valida() throws InvalidParameterException {
    }

    @Override
    public String getTexto() {
        if (super.getTexto() == null) {
            return "texto;pt-br";
        }
        return super.getTexto();
    }
}

