/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.localizacao;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.localizacao.Localizacao;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;

public class LocalizacaoImpl
extends ElementoUrnAbstractImpl
implements Localizacao {
    private String[] tipos;

    public LocalizacaoImpl() {
    }

    public LocalizacaoImpl(String tipos) throws UrnInvalidaException {
        this.setTexto(tipos);
    }

    public String getMunicipio() {
        try {
            return this.tipos[Localizacao.Tipos.Municipio.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPais() {
        try {
            return this.tipos[Localizacao.Tipos.Pais.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUf() {
        try {
            return this.tipos[Localizacao.Tipos.Uf.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public void valida() throws InvalidParameterException {
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            String[] elementos = null;
            elementos = texto.split(":");
            this.tipos = elementos[2].split(";");
            super.setTexto(elementos[2]);
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    public String toString() {
        return this.getTexto();
    }

    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
        if (!StringUtil.isVazia(this.getMunicipio()) && StringUtil.isVazia(this.getUf())) {
            throw new InvalidParameterException();
        }
        if (this.getPais() == null) {
            throw new InvalidParameterException();
        }
    }
}

