/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.obra;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnFactory;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.formaconteudo.FormaConteudo;
import br.gov.lexml.dominio.urn.obra.ObraAbstractImpl;
import br.gov.lexml.dominio.urn.obra.ObraComplexa;
import br.gov.lexml.dominio.urn.obra.ObraIndividual;
import br.gov.lexml.dominio.urn.versao.VersaoObraIndividual;
import java.security.InvalidParameterException;

public class ObraIndividualImpl
extends ObraAbstractImpl
implements ObraIndividual {
    private ObraComplexa obraComplexa;
    private VersaoObraIndividual versao;
    private FormaConteudo formaConteudo;

    public ObraIndividualImpl(ObraComplexa obraComplexa, String urn) throws UrnInvalidaException {
        this.setObraComplexa(obraComplexa);
        this.setTexto(urn);
    }

    private void validaSintaxe() throws InvalidParameterException {
        this.validaDelimitadorObraIndividual();
    }

    private void validaDelimitadorObraIndividual() throws InvalidParameterException {
        UrnUtil.validaDelimitadorUrn(this.textoUrn, "@");
    }

    public void setTexto(String urn) throws UrnInvalidaException {
        int inicio = 0;
        int fim = urn.length();
        try {
            if (urn.contains("!")) {
                fim = urn.indexOf("!");
            }
            this.textoUrn = urn.substring(inicio, fim);
            this.validaSintaxe();
            this.montaElementos();
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    private void montaElementos() throws UrnInvalidaException {
        this.versao = ElementoUrnFactory.getInstance().getVersaoObraIndividual(this.getTexto());
        this.formaConteudo = ElementoUrnFactory.getInstance().getFormaConteudo(this.getTexto());
    }

    public ObraComplexa getObraComplexa() {
        return this.obraComplexa;
    }

    public void setObraComplexa(ObraComplexa obraComplexa) {
        this.obraComplexa = obraComplexa;
    }

    public void valida() throws InvalidParameterException {
    }

    public VersaoObraIndividual getVersao() {
        return this.versao;
    }

    public FormaConteudo getFormaConteudo() {
        return this.formaConteudo;
    }
}

