/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.tipoDocumento;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.tipoDocumento.DocumentoHierarquiaSuperior;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;

public class DocumentoHierarquiaSuperiorImpl
extends ElementoUrnAbstractImpl
implements DocumentoHierarquiaSuperior {
    private String[] tipos;

    public DocumentoHierarquiaSuperiorImpl(String tipos) throws UrnInvalidaException {
        this.setTexto(tipos);
    }

    public String getSubTipo() {
        try {
            return this.tipos[DocumentoHierarquiaSuperior.Tipos.Subtipo.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTipo() {
        try {
            return this.tipos[DocumentoHierarquiaSuperior.Tipos.Tipo.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            String[] elementos = null;
            elementos = texto.split(":");
            this.tipos = elementos[2].split(";");
            super.setTexto(elementos[4]);
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
        if (this.getTipo() == null) {
            throw new InvalidParameterException();
        }
    }

    public void valida() throws InvalidParameterException {
    }
}

