/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn.versao;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.ElementoUrnAbstractImpl;
import br.gov.lexml.dominio.urn.UrnUtil;
import br.gov.lexml.dominio.urn.versao.VersaoObraIndividual;
import br.gov.lexml.util.StringUtil;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class VersaoObraIndividualImpl
extends ElementoUrnAbstractImpl
implements VersaoObraIndividual {
    private String[] tipos;

    public VersaoObraIndividualImpl(String texto) throws UrnInvalidaException {
        this.setTexto(texto);
    }

    public void setTexto(String texto) throws UrnInvalidaException {
        try {
            int inicio = 0;
            int end = 0;
            if (StringUtil.isVazia(texto)) {
                throw new UrnInvalidaException("URN n\u00c3\u00a3o pode ser null");
            }
            inicio = texto.indexOf("@") + 1;
            end = texto.contains("~") ? texto.indexOf("~") : (UrnUtil.isUrnFragmentoObraIndividual(texto) ? texto.indexOf("!") : texto.length());
            String data = texto.substring(inicio, end);
            super.setTexto(data);
            this.tipos = data.split(";");
            this.validaSintaxe();
        }
        catch (NullPointerException e) {
            throw new UrnInvalidaException(e);
        }
        catch (InvalidParameterException e) {
            throw new UrnInvalidaException(e);
        }
    }

    public void valida() throws InvalidParameterException {
    }

    protected void validaSintaxe() throws InvalidParameterException {
        UrnUtil.validaPreenchimento(this.getTexto());
        if (this.getVisao() != null && this.getQualificador() == null) {
            throw new InvalidParameterException("\u00c3\u2030 necess\u00c3\u00a1rio informar o qualificador da vis\u00c3\u00a3o.");
        }
        if (this.getVisao() == null && this.getQualificador() != null && !this.isDate(this.getQualificador())) {
            throw new InvalidParameterException("\u00c3\u2030 necess\u00c3\u00a1rio informar a vis\u00c3\u00a3o quando for informado um qualificador.");
        }
        if (!(this.getVersao() == null || this.getQualificador() == null || this.getVisao() == null || this.isDate(this.getVersao()) && this.isDate(this.getVisao()))) {
            throw new InvalidParameterException("\u00c3\u2030 necess\u00c3\u00a1rio informar a vis\u00c3\u00a3o quando for informado um qualificador.");
        }
        if (this.getVersao() == null) {
            throw new InvalidParameterException("\u00c3\u2030 obrigat\u00c3\u00b3rio informar a vers\u00c3\u00a3o.");
        }
    }

    private boolean isDate(String versao) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-mm-dd");
            return formatter.parse(versao) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String getQualificador() {
        try {
            return this.tipos[VersaoObraIndividual.Tipos.Qualificador.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getVersao() {
        try {
            return this.tipos[VersaoObraIndividual.Tipos.Versao.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getVisao() {
        try {
            return this.tipos[VersaoObraIndividual.Tipos.Visao.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }
}

