/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Ehcache {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$Cache == null ? (class$net$sf$ehcache$Cache = Cache.class$("net.sf.ehcache.Cache")) : class$net$sf$ehcache$Cache).getName());
    private static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private static InetAddress localhost;
    private boolean disabled;
    private String name;
    private DiskStore diskStore;
    private String diskStorePath;
    private Status status;
    private final int maxElementsInMemory;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    private int statisticsAccuracy;
    private final boolean overflowToDisk;
    private final long diskExpiryThreadIntervalSeconds;
    private final boolean diskPersistent;
    private Thread shutdownHook;
    private final boolean eternal;
    private final long timeToLiveSeconds;
    private final long timeToIdleSeconds;
    private int hitCount;
    private int memoryStoreHitCount;
    private int diskStoreHitCount;
    private int missCountNotFound;
    private int missCountExpired;
    private MemoryStore memoryStore;
    private RegisteredEventListeners registeredEventListeners;
    private final String guid;
    private CacheManager cacheManager;
    private BootstrapCacheLoader bootstrapCacheLoader;
    static /* synthetic */ Class class$net$sf$ehcache$Cache;

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, false, 120L, null, null);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, null, null);
        LOG.warn("An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to java.io.tmp when the ehcache-1.1 constructor is used. Please change to the 1.2 constructor");
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        String value = System.getProperty(NET_SF_EHCACHE_DISABLED);
        if (value != null) {
            this.disabled = value.equalsIgnoreCase("true");
        }
        this.statisticsAccuracy = 0;
        this.guid = localhost + "-" + new UID();
        this.changeStatus(Status.STATUS_UNINITIALISED);
        this.setName(name);
        this.maxElementsInMemory = maxElementsInMemory;
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
        this.overflowToDisk = overflowToDisk;
        this.eternal = eternal;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.diskPersistent = diskPersistent;
        this.diskStorePath = diskStorePath == null ? System.getProperty("java.io.tmpdir") : diskStorePath;
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds == 0L ? 120L : diskExpiryThreadIntervalSeconds;
        if (memoryStoreEvictionPolicy == null) {
            this.memoryStoreEvictionPolicy = DEFAULT_MEMORY_STORE_EVICTION_POLICY;
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("Cannot initialise the " + this.name + " cache because its status is not STATUS_UNINITIALISED");
            }
            if (this.maxElementsInMemory == 0 && LOG.isWarnEnabled()) {
                LOG.warn("Cache: " + this.name + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore.");
            }
            if (this.overflowToDisk) {
                this.diskStore = new DiskStore(this, this.diskStorePath);
            }
            this.memoryStore = MemoryStore.create(this, this.diskStore);
            if (this.diskPersistent) {
                this.addShutdownHook();
            }
            this.changeStatus(Status.STATUS_ALIVE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialised cache: " + this.name);
        }
        if (this.disabled && LOG.isWarnEnabled()) {
            LOG.warn("Cache: " + this.name + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache.");
        }
    }

    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    private void addShutdownHook() {
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (Cache.this.status.equals(Status.STATUS_ALIVE)) {
                        Cache.this.shutdownHook = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("VM shutting down with the disk store for " + Cache.this.name + " still active. The disk store is persistent. Calling dispose...");
                        }
                        Cache.this.dispose();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.start();
            this.shutdownHook = null;
        }
    }

    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        boolean elementExists;
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        element.resetAccessStatistics();
        Object key = element.getObjectKey();
        boolean bl = elementExists = this.isElementInMemory(key) || this.isElementOnDisk(key);
        if (elementExists) {
            element.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setTimeToLive((int)this.timeToLiveSeconds);
            element.setTimeToIdle((int)this.timeToIdleSeconds);
            element.setEternal(this.eternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
    }

    public final Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element get(Object key) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(key, true);
            if (element == null && this.overflowToDisk) {
                element = this.searchInDiskStore(key, true);
            }
            if (element == null) {
                ++this.missCountNotFound;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.name + " cache - Miss");
                }
            } else {
                ++this.hitCount;
            }
        }
        return element;
    }

    public final Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getQuiet(Object key) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(key, false);
            if (element == null && this.overflowToDisk) {
                element = this.searchInDiskStore(key, false);
            }
        }
        return element;
    }

    public final synchronized List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> allKeyList = new ArrayList<Object>();
        List<Object> keyList = Arrays.asList(this.memoryStore.getKeyArray());
        allKeyList.addAll(keyList);
        if (this.overflowToDisk) {
            HashSet<Object> allKeys = new HashSet<Object>();
            allKeys.addAll(keyList);
            Object[] diskKeys = this.diskStore.getKeyArray();
            for (int i = 0; i < diskKeys.length; ++i) {
                Object diskKey = diskKeys[i];
                if (!allKeys.add(diskKey)) continue;
                allKeyList.add(diskKey);
            }
        }
        return allKeyList;
    }

    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        int allKeyListSize = allKeyList.size();
        for (int i = 0; i < allKeyListSize; ++i) {
            Object key = allKeyList.get(i);
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    public final synchronized List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.overflowToDisk) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Object key, boolean updateStatistics) {
        Element element = updateStatistics ? this.memoryStore.get(key) : this.memoryStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + " Memory cache hit, but element expired");
                }
                ++this.missCountExpired;
                this.remove(key, true, true, false);
                element = null;
            } else {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Object key, boolean updateStatistics) {
        if (!(key instanceof Serializable)) {
            return null;
        }
        Serializable serializableKey = (Serializable)key;
        Element element = updateStatistics ? this.diskStore.get(serializableKey) : this.diskStore.getQuiet(serializableKey);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + " cache - Disk Store hit, but element expired");
                }
                ++this.missCountExpired;
                this.remove(key, true, true, false);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public final boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    public final boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    public final boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    public final boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove(key, false, true, doNotNotifyCacheReplicators);
    }

    public final boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    public final boolean removeQuiet(Object key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        Element elementFromDiskStore;
        Element elementFromMemoryStore;
        this.checkStatus();
        boolean removed = false;
        Cache cache = this;
        synchronized (cache) {
            elementFromMemoryStore = this.memoryStore.remove(key);
            elementFromDiskStore = null;
            if (this.overflowToDisk && key instanceof Serializable) {
                Serializable serializableKey = (Serializable)key;
                elementFromDiskStore = this.diskStore.remove(serializableKey);
            }
        }
        boolean removeNotified = false;
        if (elementFromMemoryStore != null) {
            if (notifyListeners) {
                if (expiry) {
                    this.registeredEventListeners.notifyElementExpiry(elementFromMemoryStore, doNotNotifyCacheReplicators);
                } else {
                    removeNotified = true;
                    this.registeredEventListeners.notifyElementRemoved(elementFromMemoryStore, doNotNotifyCacheReplicators);
                }
            }
            removed = true;
        }
        if (elementFromDiskStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromDiskStore, doNotNotifyCacheReplicators);
            } else {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromDiskStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        if (!expiry && !removeNotified) {
            Element syntheticElement = new Element(key, null);
            this.registeredEventListeners.notifyElementRemoved(syntheticElement, doNotNotifyCacheReplicators);
        }
        return removed;
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.removeAll();
            if (this.overflowToDisk) {
                this.diskStore.removeAll();
            }
        }
        this.registeredEventListeners.notifyRemoveAll(doNotNotifyCacheReplicators);
    }

    public synchronized void dispose() throws IllegalStateException {
        this.checkStatus();
        this.memoryStore.dispose();
        this.memoryStore = null;
        if (this.overflowToDisk) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.registeredEventListeners.dispose();
        this.changeStatus(Status.STATUS_SHUTDOWN);
        if (this.diskPersistent) {
            this.removeShutdownHook();
        }
    }

    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.memoryStore.flush();
            if (this.overflowToDisk) {
                this.diskStore.flush();
            }
        }
        catch (IOException e) {
            throw new CacheException("Unable to flush cache: " + this.name + ". Initial cause was " + e.getMessage(), e);
        }
    }

    public final synchronized int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.getKeys().size();
    }

    public final synchronized long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.overflowToDisk) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.name + " Cache is not alive.");
        }
    }

    public final int getHitCount() {
        return this.hitCount;
    }

    public final int getMemoryStoreHitCount() {
        return this.memoryStoreHitCount;
    }

    public final int getDiskStoreHitCount() {
        return this.diskStoreHitCount;
    }

    public final int getMissCountNotFound() {
        return this.missCountNotFound;
    }

    public final int getMissCountExpired() {
        return this.missCountExpired;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) throws IllegalArgumentException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Only unitialised caches can have their names set.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cache name cannot contain '/' characters.");
        }
        this.name = name;
    }

    public final long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public final long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public final boolean isEternal() {
        return this.eternal;
    }

    public final boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public final int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public final String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.name).append(" status = ").append(this.status).append(" eternal = ").append(this.eternal).append(" overflowToDisk = ").append(this.overflowToDisk).append(" maxElementsInMemory = ").append(this.maxElementsInMemory).append(" memoryStoreEvictionPolicy = ").append(this.memoryStoreEvictionPolicy).append(" timeToLiveSeconds = ").append(this.timeToLiveSeconds).append(" timeToIdleSeconds = ").append(this.timeToIdleSeconds).append(" diskPersistent = ").append(this.diskPersistent).append(" diskExpiryThreadIntervalSeconds = ").append(this.diskExpiryThreadIntervalSeconds).append(this.registeredEventListeners).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            return element.isExpired();
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy == null || registeredEventListenersFromCopy.getCacheEventListeners().size() == 0) {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
        } else {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
            Set cacheEventListeners = this.registeredEventListeners.getCacheEventListeners();
            Iterator iterator = cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                CacheEventListener cacheEventListenerClone = (CacheEventListener)cacheEventListener.clone();
                copy.registeredEventListeners.registerListener(cacheEventListenerClone);
            }
        }
        if (this.bootstrapCacheLoader != null) {
            BootstrapCacheLoader bootstrapCacheLoaderClone = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            copy.setBootstrapCacheLoader(bootstrapCacheLoaderClone);
        }
        return copy;
    }

    final DiskStore getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    final MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    public final boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public final long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    public final boolean isElementInMemory(Object key) {
        return this.memoryStore.containsKey(key);
    }

    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    public final boolean isElementOnDisk(Object key) {
        if (!(key instanceof Serializable)) {
            return false;
        }
        Serializable serializableKey = (Serializable)key;
        return this.diskStore != null && this.diskStore.containsKey(serializableKey);
    }

    public final String getGuid() {
        return this.guid;
    }

    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public synchronized void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.hitCount = 0;
        this.memoryStoreHitCount = 0;
        this.diskStoreHitCount = 0;
        this.missCountExpired = 0;
        this.missCountNotFound = 0;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.statisticsAccuracy = statisticsAccuracy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictExpiredElements() {
        Object[] keys = this.memoryStore.getKeyArray();
        Cache cache = this;
        synchronized (cache) {
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                this.searchInMemoryStore(key, false);
            }
        }
        this.diskStore.expireElements();
    }

    public boolean isKeyInCache(Object key) {
        return this.isElementInMemory(key) || this.isElementOnDisk(key);
    }

    public boolean isValueInCache(Object value) {
        List keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            Element element = (Element)keys.get(i);
            if (element == null || !element.getObjectValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Statistics getStatistics() throws IllegalStateException {
        int size = 0;
        if (this.statisticsAccuracy == 0) {
            size = this.getSize();
        } else if (this.statisticsAccuracy == 1) {
            size = this.getKeysWithExpiryCheck().size();
        } else if (this.statisticsAccuracy == 2) {
            size = this.getKeysNoDuplicateCheck().size();
        }
        return new Statistics(this, this.statisticsAccuracy, this.hitCount, this.diskStoreHitCount, this.memoryStoreHitCount, this.missCountExpired + this.missCountNotFound, size);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.name);
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setDiskStorePath(String diskStorePath) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A DiskStore path can only be set before the cache is initialized. " + this.name);
        }
        this.diskStorePath = diskStorePath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache other = (Ehcache)object;
        return this.guid.equals(other.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to set localhost. This prevents creation of a GUID. Cause was: " + e.getMessage(), e);
        }
    }
}

