/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;

class DisposableBeanAdapter
implements DisposableBean,
Runnable {
    private static final Log logger = LogFactory.getLog(class$org$springframework$beans$factory$support$DisposableBeanAdapter == null ? (class$org$springframework$beans$factory$support$DisposableBeanAdapter = DisposableBeanAdapter.class$("org.springframework.beans.factory.support.DisposableBeanAdapter")) : class$org$springframework$beans$factory$support$DisposableBeanAdapter);
    private final Object bean;
    private final String beanName;
    private final RootBeanDefinition mergedBeanDefinition;
    private final List beanPostProcessors;
    static /* synthetic */ Class class$org$springframework$beans$factory$support$DisposableBeanAdapter;

    public DisposableBeanAdapter(Object bean, String beanName, RootBeanDefinition mergedBeanDefinition, List beanPostProcessors) {
        Assert.notNull(bean, "Bean must not be null");
        this.bean = bean;
        this.beanName = beanName;
        this.mergedBeanDefinition = mergedBeanDefinition;
        this.beanPostProcessors = beanPostProcessors;
    }

    public void run() {
        this.destroy();
    }

    public void destroy() {
        if (this.beanPostProcessors != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Applying DestructionAwareBeanPostProcessors to bean with name '" + this.beanName + "'");
            }
            for (int i = this.beanPostProcessors.size() - 1; i >= 0; --i) {
                Object beanProcessor = this.beanPostProcessors.get(i);
                if (!(beanProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
                ((DestructionAwareBeanPostProcessor)beanProcessor).postProcessBeforeDestruction(this.bean, this.beanName);
            }
        }
        if (this.bean instanceof DisposableBean) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking destroy() on bean with name '" + this.beanName + "'");
            }
            try {
                ((DisposableBean)this.bean).destroy();
            }
            catch (Throwable ex) {
                logger.error("Couldn't invoke destroy method of bean with name '" + this.beanName + "'", ex);
            }
        }
        if (this.mergedBeanDefinition != null) {
            this.invokeCustomDestroyMethod();
        }
    }

    private void invokeCustomDestroyMethod() {
        String destroyMethodName = this.mergedBeanDefinition.getDestroyMethodName();
        if (destroyMethodName != null) {
            try {
                Method destroyMethod = BeanUtils.findMethodWithMinimalParameters(this.bean.getClass(), destroyMethodName);
                if (destroyMethod == null) {
                    if (this.mergedBeanDefinition.isEnforceDestroyMethod()) {
                        logger.error("Couldn't find a destroy method named '" + destroyMethodName + "' on bean with name '" + this.beanName + "'");
                    }
                } else {
                    Class<?>[] paramTypes = destroyMethod.getParameterTypes();
                    if (paramTypes.length > 1) {
                        logger.error("Method '" + destroyMethodName + "' of bean '" + this.beanName + "' has more than one parameter - not supported as destroy method");
                    } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                        logger.error("Method '" + destroyMethodName + "' of bean '" + this.beanName + "' has a non-boolean parameter - not supported as destroy method");
                    } else {
                        Object[] args = new Object[paramTypes.length];
                        if (paramTypes.length == 1) {
                            args[0] = Boolean.TRUE;
                        }
                        if (!Modifier.isPublic(destroyMethod.getModifiers())) {
                            destroyMethod.setAccessible(true);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Invoking custom destroy method on bean with name '" + this.beanName + "'");
                        }
                        try {
                            destroyMethod.invoke(this.bean, args);
                        }
                        catch (InvocationTargetException ex) {
                            logger.error("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + this.beanName + "'", ex.getTargetException());
                        }
                        catch (Throwable ex) {
                            logger.error("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + this.beanName + "'", ex);
                        }
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                logger.error("Couldn't find a unique destroy method on bean with name '" + this.beanName + ": " + ex.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

