/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static Log logger = LogFactory.getLog(class$org$springframework$core$LocalVariableTableParameterNameDiscoverer == null ? (class$org$springframework$core$LocalVariableTableParameterNameDiscoverer = LocalVariableTableParameterNameDiscoverer.class$("org.springframework.core.LocalVariableTableParameterNameDiscoverer")) : class$org$springframework$core$LocalVariableTableParameterNameDiscoverer);
    static /* synthetic */ Class class$org$springframework$core$LocalVariableTableParameterNameDiscoverer;

    public String[] getParameterNames(Method method) {
        ParameterNameDiscoveringVisitor visitor = null;
        try {
            visitor = this.visitMethod(method);
            if (visitor.foundTargetMember()) {
                return visitor.getParameterNames();
            }
            return null;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("IOException whilst attempting to read .class file for class [" + method.getDeclaringClass().getName() + "] - unable to determine parameter names for method " + method.getName(), ex);
            }
            return null;
        }
    }

    public String[] getParameterNames(Constructor ctor) {
        ParameterNameDiscoveringVisitor visitor = null;
        try {
            visitor = this.visitConstructor(ctor);
            if (visitor.foundTargetMember()) {
                return visitor.getParameterNames();
            }
            return null;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("IOException whilst attempting to read .class file for class [" + ctor.getDeclaringClass().getName() + "] - unable to determine parameter names for constructor", ex);
            }
            return null;
        }
    }

    private ParameterNameDiscoveringVisitor visitMethod(Method method) throws IOException {
        ClassReader classReader = this.createClassReader(method.getDeclaringClass());
        FindMethodParamNamesClassVisitor classVisitor = new FindMethodParamNamesClassVisitor(method);
        classReader.accept((ClassVisitor)((Object)classVisitor), false);
        return classVisitor;
    }

    private ParameterNameDiscoveringVisitor visitConstructor(Constructor ctor) throws IOException {
        ClassReader classReader = this.createClassReader(ctor.getDeclaringClass());
        FindConstructorParamNamesClassVisitor classVisitor = new FindConstructorParamNamesClassVisitor(ctor);
        classReader.accept((ClassVisitor)((Object)classVisitor), false);
        return classVisitor;
    }

    private ClassReader createClassReader(Class clazz) throws IOException {
        return new ClassReader(clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private boolean isStatic;
        private ParameterNameDiscoveringVisitor memberVisitor;
        private int numParameters;
        private ArrayList parameterNames;
        private boolean hasLVTInfo = false;

        public LocalVariableTableVisitor(boolean isStatic, ParameterNameDiscoveringVisitor memberVisitor, int numParams) {
            this.isStatic = isStatic;
            this.numParameters = numParams;
            this.parameterNames = new ArrayList(this.numParameters);
            this.memberVisitor = memberVisitor;
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLVTInfo = true;
            if (!this.isStatic) {
                --index;
            }
            if (index >= 0 && this.parameterNames.size() < this.numParameters) {
                this.parameterNames.add(name);
            }
        }

        public void visitEnd() {
            if (this.hasLVTInfo || this.isStatic && this.numParameters == 0) {
                String[] names = new String[this.parameterNames.size()];
                names = this.parameterNames.toArray(names);
                this.memberVisitor.setParameterNames(names);
            }
        }
    }

    private static class FindConstructorParamNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindConstructorParamNamesClassVisitor(Constructor cons) {
            super("<init>", cons.getParameterTypes().length);
            Type[] pTypes = new Type[cons.getParameterTypes().length];
            for (int i = 0; i < pTypes.length; ++i) {
                pTypes[i] = Type.getType(cons.getParameterTypes()[i]);
            }
            this.setDescriptorToMatch(Type.getMethodDescriptor(Type.VOID_TYPE, pTypes));
        }
    }

    private static class FindMethodParamNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindMethodParamNamesClassVisitor(Method method) {
            super(method.getName(), method.getParameterTypes().length);
            this.setDescriptorToMatch(Type.getMethodDescriptor(method));
        }
    }

    private static abstract class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private String methodNameToMatch;
        private String descriptorToMatch;
        private int numParamsExpected;
        private boolean foundTargetMember = false;
        private String[] parameterNames;

        public ParameterNameDiscoveringVisitor(String name, int numParams) {
            this.methodNameToMatch = name;
            this.numParamsExpected = numParams;
        }

        public void setDescriptorToMatch(String descriptor) {
            this.descriptorToMatch = descriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals(this.methodNameToMatch) && desc.equals(this.descriptorToMatch)) {
                this.foundTargetMember = true;
                return new LocalVariableTableVisitor(this.isStatic(access), this, this.numParamsExpected);
            }
            return null;
        }

        private boolean isStatic(int access) {
            return (access & 8) > 0;
        }

        public boolean foundTargetMember() {
            return this.foundTargetMember;
        }

        public String[] getParameterNames() {
            if (!this.foundTargetMember()) {
                throw new IllegalStateException("Can't ask for parameter names when target member has not been found");
            }
            return this.parameterNames;
        }

        public void setParameterNames(String[] names) {
            this.parameterNames = names;
        }
    }
}

