/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml;

import br.gov.lexml.LexMLCrypt;
import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.vo.AdministradorVO;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.profileLexml.ConfiguracaoProvedorDocument;
import br.gov.lexml.profileLexml.ConfiguracaoProvedorType;
import br.gov.lexml.profileLexml.PerfilType;
import br.gov.lexml.profileLexml.ProvedorType;
import br.gov.lexml.profileLexml.PublicadorType;
import br.gov.lexml.profileLexml.ResponsavelType;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexMLConfig {
    private static ConfiguracaoProvedorDocument bordaConf = null;
    private ArrayList<Provedor> provedor;
    private Logger logger = Logger.getLogger(LexMLConfig.class.getName());
    private ArrayList<Publicador> publicadores = new ArrayList();
    private ArrayList<AdministradorVO> administradores = new ArrayList();
    private static LexMLConfig instanceNodoBorda = null;
    private static LexMLConfig instanceNodoMeio = null;
    private int modoDeOperacao = 0;
    public static final int MODO_NODO_BORDA = 0;
    public static final int MODO_NODO_MEIO = 1;
    public static final long TEMPO_DE_SESSAO = 20000L;
    private ProvedorType.Tipo.Enum tipo;

    public final boolean validarAdministrador(AdministradorVO adm) {
        for (AdministradorVO tst : this.administradores) {
            if (!tst.getEmail().equals(adm.getEmail())) continue;
            return tst.validateSenha(adm.getSenha());
        }
        return false;
    }

    public static final LexMLConfig getConfig(int p_modo) throws ConfigFailedException {
        if (1 == p_modo) {
            if (instanceNodoMeio == null) {
                instanceNodoMeio = new LexMLConfig(1);
            }
            return instanceNodoMeio;
        }
        if (instanceNodoBorda == null) {
            instanceNodoBorda = new LexMLConfig(0);
        }
        return instanceNodoBorda;
    }

    public String getArquivoPerfil() {
        if (1 == this.modoDeOperacao) {
            return "lexml_naconfig.xml";
        }
        return "lexml_nbconfig.xml";
    }

    private LexMLConfig() {
    }

    public void setModoOperacao(int p_modo) throws ConfigFailedException {
        this.provedor = new ArrayList();
        this.modoDeOperacao = p_modo;
        try {
            if (1 == p_modo) {
                this.setConfigFile("lexml_naconfig.xml");
            } else {
                this.setConfigFile("lexml_nbconfig.xml");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logger.log(Level.ERROR, t.getStackTrace().toString());
            throw new ConfigFailedException("Erro no arquivo de configuracao de perfil :" + this.getArquivoPerfil());
        }
        if (1 == p_modo) {
            instanceNodoMeio = this;
        } else {
            instanceNodoBorda = this;
        }
    }

    public LexMLConfig(int p_modo) throws ConfigFailedException {
        this.setModoOperacao(p_modo);
    }

    public boolean matchLogin(String emailTst, String passwordTst) {
        int i = 0;
        while (i < this.provedor.size()) {
            Provedor prov = this.provedor.get(i);
            if (prov.matchLogin(emailTst, passwordTst)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isConfigured() {
        return bordaConf != null;
    }

    public String getProvedorNome() {
        if (this.provedor != null && this.provedor.get(0) != null) {
            return this.provedor.get(0).getNome();
        }
        return null;
    }

    public String getAdministradorEmail() {
        if (this.provedor != null && this.provedor.get(0) != null) {
            return this.provedor.get(0).getAdministrador().getEmail();
        }
        return null;
    }

    private void parseProvedor(ConfiguracaoProvedorDocument p_newConf) throws ConfigFailedException {
        if (p_newConf == null) {
            return;
        }
        ConfiguracaoProvedorType confProvedor = p_newConf.getConfiguracaoProvedor();
        if (confProvedor == null) {
            this.logger.log(Level.ERROR, "Arquivo de configura\u00e7\u00e3o com erro no bloco ConfiguracaoProvedor");
        } else {
            if (1 > confProvedor.sizeOfProvedorArray()) {
                this.logger.log(Level.ERROR, "Arquivo de configura\u00e7\u00e3o com erro no bloco Provedor");
                System.out.println(p_newConf.toString());
                throw new ConfigFailedException("Arquivo de configura\u00e7\u00e3o com erro no bloco Provedor");
            }
            int j = 0;
            while (j < confProvedor.sizeOfProvedorArray()) {
                ProvedorType provedor_xml = confProvedor.getProvedorArray(j);
                Provedor newProvedor = new Provedor(provedor_xml);
                ProvedorType.Tipo.Enum newTipo = provedor_xml.getTipo();
                newProvedor.setTipo(newTipo.toString());
                newProvedor.setNome(provedor_xml.getNome());
                newProvedor.setIdProvedor(provedor_xml.getIdProvedor());
                ResponsavelType adm = provedor_xml.getAdministrador();
                if (adm == null) {
                    this.logger.log(Level.ERROR, "Arquivo de configura\u00e7\u00e3o com erro Administrador de Provedor ausente");
                } else {
                    this.administradores.add(new AdministradorVO(provedor_xml.getIdProvedor(), adm.getIdResponsavel(), adm.getEmail(), adm.getSenha()));
                    this.tipo = newTipo;
                }
                int publicadores = provedor_xml.sizeOfPublicadorArray();
                int i = 0;
                while (i < publicadores) {
                    this.parsePublicador(provedor_xml.getPublicadorArray(i));
                    ++i;
                }
                this.provedor.add(newProvedor);
                ++j;
            }
        }
    }

    public void writePerfil(StringBuffer p_sb) {
        if (bordaConf != null) {
            p_sb.append(bordaConf.toString().replaceAll("senha\\s*=\\s*\"[^>]*\"", "senha=\"*****\"").replaceAll("email\\s*=\\s*\"[^>]*\"", ""));
        }
    }

    private void parsePublicador(PublicadorType publicador) {
        Publicador novo_publicador = new Publicador(publicador);
        int i = 0;
        while (i < publicador.sizeOfPerfilArray()) {
            novo_publicador.addPerfil(new Perfil(publicador.getPerfilArray(i)));
            ++i;
        }
        ResponsavelType adm = publicador.getResponsavel();
        if (adm != null) {
            AdministradorVO publicadorAdm = new AdministradorVO(publicador.getIdPublicador(), adm.getIdResponsavel(), adm.getEmail(), adm.getSenha());
            this.administradores.add(publicadorAdm);
        }
        this.publicadores.add(novo_publicador);
    }

    public void setConfigFile(String configFile) throws ConfigFailedException, NamingException {
        ConfiguracaoProvedorDocument newConf;
        try {
            newConf = LexMLUtil.readConfiguracaoProvedor(configFile);
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.ERROR, "Arquivo '" + configFile + "' n\u00e3o possui perfil de repositorio v\u00e1lido");
            throw new ConfigFailedException("N\u00e3o foi poss\u00edvel abrir o arquivo " + configFile, e);
        }
        if (newConf != null) {
            this.parseProvedor(newConf);
            bordaConf = newConf;
        }
    }

    public ArrayList<Publicador> getPublicadores() {
        return this.publicadores;
    }

    public void setPublicadores(ArrayList<Publicador> publicadores) {
        this.publicadores = publicadores;
    }

    public ProvedorType.Tipo.Enum getTipo() {
        return this.tipo;
    }

    public void setTipo(ProvedorType.Tipo.Enum tipo) {
        this.tipo = tipo;
    }

    public class Perfil {
        public static final String SEP = ":";
        private String autoridade;
        private String localidade;
        private String tipoDocumento;
        private String tipoPerfil;

        public Perfil(PerfilType p_perfil) {
            if (p_perfil != null) {
                this.autoridade = p_perfil.getAutoridade();
                this.localidade = p_perfil.getLocalidade();
                this.tipoDocumento = p_perfil.getTipoDocumento();
                PerfilType.TipoPerfil.Enum tp = p_perfil.getTipoPerfil();
                if (tp == null) {
                    tp = PerfilType.TipoPerfil.T;
                }
                this.tipoPerfil = tp.toString();
            }
        }

        public String getNucleoUrn() {
            return this.tipoPerfil.concat(SEP).concat(this.localidade).concat(SEP).concat(this.autoridade).concat(SEP).concat(this.tipoDocumento);
        }

        public String toString() {
            return this.autoridade.concat(SEP).concat(this.localidade).concat(SEP).concat(this.tipoDocumento);
        }

        public String getTipoPerfil() {
            return this.tipoPerfil;
        }

        public void setTipoPerfil(String tipoPerfil) {
            this.tipoPerfil = tipoPerfil;
        }
    }

    public class Provedor {
        private BigInteger idProvedor;
        private String nome;
        private String tipo;
        private Responsavel administrador;

        public Provedor(ProvedorType provedor_xml) {
            this.tipo = provedor_xml.getTipo().toString();
            this.nome = provedor_xml.getNome();
            this.idProvedor = provedor_xml.getIdProvedor();
            this.administrador = new Responsavel(provedor_xml.getAdministrador());
        }

        public boolean matchLogin(String emailTst, String passwordTst) {
            return this.administrador.matchLogin(emailTst, passwordTst);
        }

        public BigInteger getIdProvedor() {
            return this.idProvedor;
        }

        public void setIdProvedor(BigInteger idProvedor) {
            this.idProvedor = idProvedor;
        }

        public String getNome() {
            return this.nome;
        }

        public void setNome(String nome) {
            this.nome = nome;
        }

        public String getTipo() {
            return this.tipo;
        }

        public void setTipo(String tipo) {
            this.tipo = tipo;
        }

        public Responsavel getAdministrador() {
            return this.administrador;
        }

        public void setAdministrador(ResponsavelType administrador) {
            this.administrador = new Responsavel(administrador);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Publicador {
        private BigInteger idPublicador;
        private String nome;
        private String sigla;
        private Responsavel responsavel;
        private ArrayList<Perfil> perfil;

        public Publicador(BigInteger p_id, String p_nome, String p_sigla) {
            this.idPublicador = p_id;
            this.nome = p_nome;
            this.sigla = p_sigla;
        }

        public Publicador(PublicadorType p_publicador) {
            this.idPublicador = p_publicador.getIdPublicador();
            this.nome = p_publicador.getNome();
            this.sigla = p_publicador.getSigla();
            this.responsavel = new Responsavel(p_publicador.getResponsavel());
        }

        public void addPerfil(Perfil p_perfil) {
            if (this.perfil == null) {
                this.perfil = new ArrayList();
            }
            if (p_perfil != null) {
                this.perfil.add(p_perfil);
            }
        }

        public Responsavel getResponsavel() {
            return this.responsavel;
        }

        public BigInteger getIdPublicador() {
            return this.idPublicador;
        }

        public void setIdPublicador(BigInteger idPublicador) {
            this.idPublicador = idPublicador;
        }

        public String getNome() {
            return this.nome;
        }

        public void setNome(String nome) {
            this.nome = nome;
        }

        public String getSigla() {
            return this.sigla;
        }

        public void setSigla(String sigla) {
            this.sigla = sigla;
        }

        public ArrayList<Perfil> getPerfil() {
            return this.perfil;
        }

        public void setPerfil(ArrayList<Perfil> perfil) {
            this.perfil = perfil;
        }
    }

    public class Responsavel {
        private BigInteger idResponsavel;
        private String email;
        private String hash_senha;

        private Responsavel() {
        }

        private Responsavel(ResponsavelType p_responsavel) {
            this.idResponsavel = p_responsavel.getIdResponsavel();
            this.email = p_responsavel.getEmail();
            this.hash_senha = p_responsavel.getSenha();
        }

        public String getEmail() {
            return this.email;
        }

        public boolean matchLogin(String emailTst, String passwordTst) {
            if (this.email.equals(emailTst) && this.hash_senha.equals(passwordTst)) {
                return true;
            }
            return this.email.equals(emailTst) && this.hash_senha.equals(new LexMLCrypt.sha256New().hash(passwordTst.getBytes()));
        }
    }
}

