/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.LexMLConstants;
import br.gov.lexml.borda.helper.BOHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class URNBO
implements LexMLConstants {
    private static Logger logger = Logger.getLogger(BOHelper.class.getName());
    private HashMap<String, Boolean> m_perfis = null;
    private LexMLConfig m_config = null;
    private String tstNucleoURN;
    private String tstNucleoURNAutoridadeReduzida;
    private String tstNucleoURNTipoReduzida;

    private boolean isEstruturalmenteValid(String p_urn, BigInteger p_idPublicador) throws ArrayIndexOutOfBoundsException {
        String[] part = p_urn.split(":");
        if (part.length < 5) {
            return false;
        }
        this.compilarPerfisValidos();
        this.tstNucleoURNAutoridadeReduzida = null;
        this.tstNucleoURNTipoReduzida = null;
        this.tstNucleoURN = null;
        String[] tipoPart = part[4].split(";");
        if ("urn".equalsIgnoreCase(part[0]) && "lex".equalsIgnoreCase(part[1])) {
            this.tstNucleoURN = part[2].concat(":").concat(part[3]).concat(":").concat(part[4]);
            if (part[3].contains(";") && part[4].contains(";")) {
                String autoridade = part[3].substring(0, part[3].indexOf(";"));
                String tipo = part[4].substring(0, part[4].indexOf(";"));
                this.tstNucleoURNAutoridadeReduzida = part[2].concat(":").concat(autoridade).concat(":").concat(part[4]);
                this.tstNucleoURNTipoReduzida = part[2].concat(":").concat(part[3]).concat(":").concat(tipo);
            }
            return true;
        }
        return false;
    }

    public boolean isRelacionamentoValid(String p_urn, BigInteger p_idPublicador) {
        if (!this.isEstruturalmenteValid(p_urn, p_idPublicador)) {
            return false;
        }
        if (!this.isCoreValid(p_idPublicador, this.tstNucleoURN, "R")) {
            return this.isCoreValid(p_idPublicador, this.tstNucleoURNAutoridadeReduzida, "R") && this.isCoreValid(p_idPublicador, this.tstNucleoURNTipoReduzida, "R");
        }
        return true;
    }

    public boolean isDocumentoIndividualValid(String p_urn, BigInteger p_idPublicador) throws ArrayIndexOutOfBoundsException {
        if (!this.isEstruturalmenteValid(p_urn, p_idPublicador)) {
            return false;
        }
        if (!this.isCoreValid(p_idPublicador, this.tstNucleoURN, "D")) {
            return this.isCoreValid(p_idPublicador, this.tstNucleoURNAutoridadeReduzida, "D") && this.isCoreValid(p_idPublicador, this.tstNucleoURNTipoReduzida, "D");
        }
        return true;
    }

    private boolean isCoreValid(BigInteger p_idPublicador, String p_tstNucleoURN, String p_tipoCore) {
        if (p_idPublicador == null) {
            logger.debug("idPublicador nulo passado");
            return false;
        }
        if (p_tstNucleoURN == null) {
            logger.debug("tstNucleoURN nulo passado");
            return false;
        }
        String tstURN = p_idPublicador.toString().concat(":").concat("T").concat(":").concat(p_tstNucleoURN);
        if (this.isValid(tstURN)) {
            return true;
        }
        tstURN = p_idPublicador.toString().concat(":").concat(p_tipoCore).concat(":").concat(p_tstNucleoURN);
        return this.isValid(tstURN);
    }

    private boolean isValid(String p_urn) {
        Boolean resp = this.m_perfis.get(p_urn);
        if (resp == null) {
            return false;
        }
        return resp;
    }

    public void compilarPerfisValidos() {
        if (this.m_perfis != null || this.m_config == null) {
            return;
        }
        HashMap<String, Boolean> novosPerfis = new HashMap<String, Boolean>();
        ArrayList<LexMLConfig.Publicador> publicadores = this.m_config.getPublicadores();
        for (LexMLConfig.Publicador publicador : publicadores) {
            ArrayList<LexMLConfig.Perfil> perfil = publicador.getPerfil();
            if (perfil == null) continue;
            for (LexMLConfig.Perfil regraPerfil : perfil) {
                String nucleo = publicador.getIdPublicador().toString().concat(":").concat(regraPerfil.getNucleoUrn());
                novosPerfis.put(nucleo, Boolean.TRUE);
                logger.info("PERFIL ADICIONADO: " + nucleo);
            }
        }
        logger.info("TOTAL DE " + novosPerfis.size() + " PERFIS ADICIONADOS");
        this.m_perfis = novosPerfis;
    }

    public void setConfig(LexMLConfig p_config) {
        this.m_config = p_config;
    }
}

