/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.borda.business.AbstractBO;
import br.gov.lexml.borda.business.URNBO;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.oaiLexml.LexMLDocument;
import br.gov.lexml.oaiLexml.LexMLType;
import br.gov.lexml.oaiLexml.RelacionamentoType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class ValidadorBO
extends AbstractBO {
    private static Logger logger = Logger.getLogger(ValidadorBO.class.getName());
    private static int BUCKET_SIZE = 100;
    private static String SUCESSO = "RegistroItem validado com sucesso";
    private List<RegistroItemErro> errosList = new ArrayList<RegistroItemErro>();
    private List<RegistroItemLog> logList = new ArrayList<RegistroItemLog>();
    private List<RegistroItem> atualizados = new ArrayList<RegistroItem>();
    private RegistroItemDAO m_dao = null;
    private LexMLConfig m_config = null;
    private URNBO m_URN = new URNBO();
    private static Pattern pattern = Pattern.compile("<[?].*[?]>");
    private int sucessos = 0;
    private int falhas = 0;
    private XmlOptions validationOptions = null;

    public ValidadorBO() throws ConfigFailedException {
        this.init(0);
    }

    public ValidadorBO(int p_modo) throws ConfigFailedException {
        this.init(p_modo);
    }

    private void init(int p_modo) throws ConfigFailedException {
        if (this.m_config == null) {
            LexMLConfig config = 1 == p_modo ? new LexMLConfig(1) : new LexMLConfig(0);
            this.m_config = config;
        }
        this.m_URN.setConfig(this.m_config);
        if (this.m_dao == null) {
            this.m_dao = new RegistroItemDAO();
        }
    }

    public void logError(RegistroItem ri, TipoErro erro, String msg, boolean p_gravar_no_banco) {
        logger.error("[" + ri.getIdRegistroItem() + "]" + erro.getNoTipoErro());
        logger.error(msg);
        if (p_gravar_no_banco) {
            this.errosList.add(this.m_dao.newLogErr(ri, erro, msg));
        }
    }

    public boolean validarRegistroItem(RegistroItem ri, boolean p_validar_urn, boolean p_atualiza_xml, boolean p_gravar_no_banco_as_mensagens_de_erro) {
        block25: {
            LexMLDocument doc = null;
            ++this.falhas;
            if (ri == null) {
                logger.error("RV#4 Objeto RegistroItem ri passado \u00e9 nulo");
                return false;
            }
            String xml = ri.getTxMetadadoXml();
            Matcher match = pattern.matcher(xml);
            if (!ri.getIdRegistroItem().trim().equals(ri.getIdRegistroItem())) {
                this.logError(ri, this.getDefault().ERRO_GENERICO.tipo, "RV#1 ID_REGISTRO_ITEM n\u00e3o pode conter espa\u00e7os em branco", p_gravar_no_banco_as_mensagens_de_erro);
                return false;
            }
            String lexml = match.replaceAll("");
            ri.setCdValidacao("E");
            xml.getBytes("UTF-8");
            if (xml == null) {
                this.logError(ri, this.getDefault().ERRO_XML_MAL_FORMADO.tipo, "RV#2 XML nulo foi passado para valida\u00e7\u00e3o", p_gravar_no_banco_as_mensagens_de_erro);
                break block25;
            }
            try {
                ArrayList validationErrors = new ArrayList();
                if (this.validationOptions == null) {
                    this.validationOptions = new XmlOptions();
                    this.validationOptions.setCharacterEncoding("UTF-8");
                    this.validationOptions.setLoadStripProcinsts();
                    this.validationOptions.setSaveNoXmlDecl();
                    this.validationOptions.setLoadStripProcinsts();
                }
                this.validationOptions.setErrorListener(validationErrors);
                doc = LexMLDocument.Factory.parse(lexml, this.validationOptions);
                if (!doc.validate(this.validationOptions)) {
                    this.logError(ri, this.getDefault().ERRO_XML_INVALIDO.tipo, "RV#3 Xml n\u00e3o \u00e9 v\u00e1lido segundo o schema", p_gravar_no_banco_as_mensagens_de_erro);
                    Iterator iterErros = validationErrors.iterator();
                    while (iterErros.hasNext()) {
                        this.logError(ri, this.getDefault().ERRO_XML_INVALIDO.tipo, "RV#3 ".concat(iterErros.next().toString()), p_gravar_no_banco_as_mensagens_de_erro);
                    }
                } else {
                    String tstURNDocumentoIndividual = doc.getLexML().getDocumentoIndividual().getStringValue();
                    LexMLType.Item[] itens = doc.getLexML().getItemArray();
                    RelacionamentoType[] relacionamento = doc.getLexML().getRelacionamentoArray();
                    boolean urnValid = false;
                    if (p_validar_urn) {
                        boolean documentoIndividualValid = true;
                        boolean relacionamentoValid = true;
                        int i = 0;
                        while (i < itens.length) {
                            if (!this.m_URN.isDocumentoIndividualValid(tstURNDocumentoIndividual, itens[i].getIdPublicador())) {
                                documentoIndividualValid = false;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < relacionamento.length) {
                            BigInteger idPublicador = relacionamento[i].getIdPublicador();
                            if (idPublicador == null && itens != null && itens.length > 0) {
                                idPublicador = itens[0].getIdPublicador();
                            }
                            if (!this.m_URN.isDocumentoIndividualValid(tstURNDocumentoIndividual, idPublicador)) {
                                documentoIndividualValid = false;
                                this.logError(ri, this.getDefault().ERRO_URN_INCOMPATIVEL.tipo, "RV#5 A URN de DocumentoIndividual: " + tstURNDocumentoIndividual + " n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual em rela\u00e7\u00e3o ao perfil para o relacionamento do publicador" + idPublicador, p_gravar_no_banco_as_mensagens_de_erro);
                            }
                            String tstURNRelacionamento = relacionamento[i].getStringValue().trim();
                            if (idPublicador == null) {
                                relacionamentoValid = false;
                                this.logError(ri, this.getDefault().ERRO_URN_INCOMPATIVEL.tipo, "RV#8 A URN de Relacionamento:" + tstURNRelacionamento + " n\u00e3o pode ser validada por aus\u00eancia de idPublicador", p_gravar_no_banco_as_mensagens_de_erro);
                            } else if (!this.m_URN.isRelacionamentoValid(tstURNRelacionamento, idPublicador)) {
                                relacionamentoValid = false;
                                this.logError(ri, this.getDefault().ERRO_URN_INCOMPATIVEL.tipo, "RV#7 A URN de Relacionamento:" + tstURNRelacionamento + " n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual de perfil", p_gravar_no_banco_as_mensagens_de_erro);
                            }
                            ++i;
                        }
                        urnValid = relacionamentoValid & documentoIndividualValid;
                    }
                    if (urnValid) {
                        --this.falhas;
                        ++this.sucessos;
                        ri.setCdValidacao("O");
                        this.logList.add(this.m_dao.newLogMsg(ri, SUCESSO));
                        logger.log(Level.WARN, "Registro : " + ri.getIdRegistroItem() + " validado com sucesso");
                        if (p_atualiza_xml) {
                            match = pattern.matcher(doc.getLexML().toString());
                            ri.setTxMetadadoXml(match.replaceAll(""));
                        } else {
                            ri.setTxMetadadoXml(lexml);
                        }
                        return true;
                    }
                }
            }
            catch (XmlException e) {
                try {
                    this.logError(ri, this.getDefault().ERRO_XML_MAL_FORMADO.tipo, String.valueOf(e.getMessage()) + e.getErrors().toString(), p_gravar_no_banco_as_mensagens_de_erro);
                }
                catch (UnsupportedEncodingException e1) {
                    this.logError(ri, this.getDefault().ERRO_XML_MAL_FORMADO.tipo, String.valueOf(e1.getMessage()) + e1.getCause().toString(), p_gravar_no_banco_as_mensagens_de_erro);
                }
                catch (IOException e2) {
                    this.logError(ri, this.getDefault().ERRO_XML_MAL_FORMADO.tipo, e2.getMessage(), p_gravar_no_banco_as_mensagens_de_erro);
                }
            }
        }
        return false;
    }

    public void validarRegistrosIndefinidos() {
        if (this.m_config == null) {
            logger.log(Level.FATAL, "Ambiente nao configurado, verifique arquivo de configuracao:lexml_nbconfig.xml");
            return;
        }
        List<RegistroItem> list = this.m_dao.listNotValid();
        if (list.size() < 1) {
            logger.log(Level.WARN, "N\u00e3o havia registros indefinidos para serem validados");
            return;
        }
        int total = list.size();
        logger.info("Come\u00e7ando a validar " + total + " registros.");
        Iterator<RegistroItem> iter = list.iterator();
        int sucessos = 0;
        int erros = 0;
        this.m_dao.beginBulkMode();
        while (iter.hasNext()) {
            ++erros;
            RegistroItem ri = iter.next();
            if (this.validarRegistroItem(ri, true, false, true)) {
                ++sucessos;
                --erros;
            }
            this.atualizados.add(ri);
            this.checkListsSizes(BUCKET_SIZE);
        }
        if (total > 0) {
            this.checkListsSizes(1);
            this.m_dao.bulkCommit();
            logger.info("-----------------------------------");
            logger.info("Total de registros processados: " + total);
            logger.info("Processados com sucesso: " + sucessos);
            logger.info("Registros com erros: " + erros);
            int t = sucessos - sucessos * 100 / total * total / 100;
            int p = t * 10000 / total;
            logger.info("Aproveitamento de : " + sucessos * 100 / total + "," + p + "% aprox.");
        } else {
            this.m_dao.bulkRollBack();
        }
        this.validationOptions = null;
        System.gc();
    }

    private void checkListsSizes(int p_size) {
        if (this.m_dao == null) {
            return;
        }
        boolean in = this.m_dao.inBulkMode();
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        if (!in) {
            this.m_dao.beginBulkMode();
        }
        if (p_size <= this.atualizados.size()) {
            logger.info("Iniciando COMMIT");
            logger.info("de " + this.atualizados.size() + " registroItem");
            this.m_dao.updateList(this.atualizados);
            this.atualizados = new ArrayList<RegistroItem>();
            b1 = true;
        }
        if (p_size <= this.logList.size()) {
            logger.info("de " + this.logList.size() + " registroItemLog");
            this.m_dao.saveList(this.logList);
            this.logList = new ArrayList<RegistroItemLog>();
            b2 = true;
        }
        if (p_size <= this.errosList.size()) {
            logger.info("de " + this.errosList.size() + " registroItemErro");
            this.m_dao.saveList(this.errosList);
            this.errosList = new ArrayList<RegistroItemErro>();
            b3 = true;
        }
        if (b1 || b2 || b3 || !in) {
            this.m_dao.bulkCommit();
            logger.info("Commit finalizado.");
            if (in) {
                this.m_dao.beginBulkMode();
            }
        }
    }

    public int getSucessos() {
        return this.sucessos;
    }

    public void setSucessos(int sucessos) {
        this.sucessos = sucessos;
    }

    public int getFalhas() {
        return this.falhas;
    }

    public void setFalhas(int falhas) {
        this.falhas = falhas;
    }
}

