/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.borda.dao.EMFFactory;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.exceptions.ConfigFailedException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractDAO {
    private static final Logger logger = Logger.getLogger(AbstractDAO.class.getName());
    private static EntityManagerFactory m_emf = null;
    private EntityManager m_em = null;
    private EntityTransaction m_bulk_trans = null;
    private static boolean loaded_auto_ids = false;

    public boolean inBulkMode() {
        return this.m_bulk_trans != null;
    }

    protected final EntityManager getEntityManager(EntityManagerFactory p_emf) {
        if (p_emf == null) {
            if (m_emf == null) {
                try {
                    m_emf = EMFFactory.getEMF();
                }
                catch (ConfigFailedException e) {
                    logger.error("N\u00e3o foi poss\u00edvel a cria\u00e7\u00e3o de uma EntityManagerFactory", e);
                }
            }
        } else {
            m_emf = p_emf;
        }
        if (m_emf != null && this.m_em == null) {
            this.m_em = m_emf.createEntityManager();
        }
        if (this.checkTablesReady(this.m_em)) {
            return this.m_em;
        }
        return null;
    }

    protected final EntityManager getEntityManager() {
        return this.getEntityManager(null);
    }

    private boolean checkTablesReady(EntityManager p_em) {
        if (p_em == null) {
            return false;
        }
        if (loaded_auto_ids) {
            return loaded_auto_ids;
        }
        try {
            RegistroItemLog.setNextId(1);
            Query queryL = p_em.createQuery("SELECT ril FROM RegistroItemLog ril ORDER BY ril.idRegistroItemLog DESC");
            queryL.setMaxResults(1);
            RegistroItemLog ril = (RegistroItemLog)queryL.getSingleResult();
            if (ril != null) {
                RegistroItemLog.setNextId(ril.getIdRegistroItemLog() + 1);
            }
        }
        catch (NoResultException e) {
            logger.log(Level.WARN, "Utilizando o valor 1 para o maximo valor da chave para a tabela regitro_item_log.");
        }
        try {
            RegistroItemErro.setNextId(1);
            Query queryE = p_em.createQuery("SELECT rie FROM RegistroItemErro rie ORDER BY rie.idRegistroItemErro DESC");
            queryE.setMaxResults(1);
            RegistroItemErro rie = (RegistroItemErro)queryE.getSingleResult();
            if (rie != null) {
                RegistroItemErro.setNextId(rie.getIdRegistroItemErro() + 1);
            }
        }
        catch (NoResultException e) {
            logger.log(Level.WARN, "Utilizando o valor 1 para o maximo valor da chave para a tabela regitro_item_erro.");
        }
        loaded_auto_ids = true;
        return loaded_auto_ids;
    }

    public final synchronized boolean beginBulkMode() {
        if (this.m_bulk_trans == null) {
            this.m_bulk_trans = this.getEntityManager().getTransaction();
            this.m_bulk_trans.begin();
            return true;
        }
        return false;
    }

    public final void bulkCommit() {
        if (this.m_bulk_trans == null) {
            return;
        }
        if (this.m_bulk_trans.isActive()) {
            this.m_bulk_trans.commit();
        }
        this.m_bulk_trans = null;
    }

    public final void bulkRollBack() {
        if (this.m_bulk_trans == null) {
            return;
        }
        if (this.m_bulk_trans.isActive()) {
            this.m_bulk_trans.rollback();
        }
        this.m_bulk_trans = null;
    }

    protected void updateObject(Object p_obj) {
        this.getEntityManager(m_emf).merge(p_obj);
    }

    protected void saveObject(Object p_obj) {
        logger.info("Salvando um " + p_obj.getClass().getName() + " novo");
        boolean myBulkTransaction = this.beginBulkMode();
        this.getEntityManager().persist(p_obj);
        if (myBulkTransaction) {
            this.bulkCommit();
        }
    }
}

