/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.vo;

import br.gov.lexml.LexMLCrypt;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public class AdministradorVO {
    private static Logger logger = Logger.getLogger(AdministradorVO.class.getName());
    private BigInteger idProvedor;
    private BigInteger idAdministrador;
    private String email;
    private String senha;
    private long expirationTime;
    private String hash;

    public AdministradorVO(BigInteger p_idProvedor, BigInteger p_idAdministrador, String p_email, String p_senha) {
        this.idAdministrador = p_idAdministrador;
        this.email = p_email;
        this.senha = p_senha;
        this.idProvedor = p_idProvedor;
    }

    public AdministradorVO(String p_email, String p_senha) {
        this.email = p_email;
        this.senha = p_senha;
    }

    public BigInteger getIdAdministrador() {
        return this.idAdministrador;
    }

    public void setIdAdministrador(BigInteger idAdministrador) {
        this.idAdministrador = idAdministrador;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public final boolean validateSenha(String p_senha) {
        String hash = LexMLCrypt.hash(p_senha);
        logger.info("Comparando a p_senha: Crypt(" + p_senha + ") = " + hash + "  com o hash do arquivo= (" + this.senha + ")");
        return this.senha.equals(hash);
    }

    public BigInteger getIdProvedor() {
        return this.idProvedor;
    }

    public void setIdProvedor(BigInteger idProvedor) {
        this.idProvedor = idProvedor;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }
}

