/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Statistics
implements Serializable {
    public static final int STATISTICS_ACCURACY_BEST_EFFORT = 0;
    public static final int STATISTICS_ACCURACY_GUARANTEED = 1;
    public static final int STATISTICS_ACCURACY_NONE = 2;
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$Statistics == null ? (class$net$sf$ehcache$Statistics = Statistics.class$("net.sf.ehcache.Statistics")) : class$net$sf$ehcache$Statistics).getName());
    private static final long serialVersionUID = 3606940454221918725L;
    private transient Ehcache cache;
    private final int statisticsAccuracy;
    private final int cacheHits;
    private final int onDiskHits;
    private final int inMemoryHits;
    private final int misses;
    private final int size;
    static /* synthetic */ Class class$net$sf$ehcache$Statistics;

    public Statistics(Ehcache cache, int statisticsAccuracy, int cacheHits, int onDiskHits, int inMemoryHits, int misses, int size) {
        this.statisticsAccuracy = statisticsAccuracy;
        this.cacheHits = cacheHits;
        this.onDiskHits = onDiskHits;
        this.inMemoryHits = inMemoryHits;
        this.misses = misses;
        this.cache = cache;
        this.size = size;
    }

    public void clearStatistics() {
        block3: {
            if (this.cache == null) {
                throw new IllegalStateException("This statistics object no longer references a Cache.");
            }
            try {
                this.cache.clearStatistics();
            }
            catch (IllegalStateException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.info("Ignoring call because " + e.getMessage());
            }
        }
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public int getInMemoryHits() {
        return this.inMemoryHits;
    }

    public int getOnDiskHits() {
        return this.onDiskHits;
    }

    public int getCacheMisses() {
        return this.misses;
    }

    public int getObjectCount() {
        return this.size;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public String getAssociatedCacheName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return null;
    }

    public final String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.getAssociatedCacheName()).append(" cacheHits = ").append(this.cacheHits).append(" onDiskHits = ").append(this.onDiskHits).append(" inMemoryHits = ").append(this.inMemoryHits).append(" misses = ").append(this.misses).append(" size = ").append(this.size).append(" ]");
        return dump.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

