/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml;

import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.profileLexml.ConfiguracaoProvedorDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class LexMLUtil {
    private static String lexml_home_dir = null;
    private static Logger logger = Logger.getLogger(LexMLUtil.class.getName());
    private static Properties jpa_properties = null;

    public static void setLexMLHome(String p_dir) {
        lexml_home_dir = p_dir;
        jpa_properties = null;
    }

    public static String getLexMLHome() throws FileNotFoundException {
        if (lexml_home_dir == null && (lexml_home_dir = System.getenv("LEXML_HOME")) == null) {
            try {
                InitialContext initial = new InitialContext();
                Context environment = (Context)initial.lookup("java:comp/env");
                lexml_home_dir = (String)environment.lookup("LEXML_HOME");
            }
            catch (NamingException e) {
                logger.error("Houve falha na detec\u00e7\u00e3o de LEXML_HOME via JNDI", e);
            }
            if (lexml_home_dir == null) {
                lexml_home_dir = String.valueOf(File.separator) + "conf";
            }
        }
        if (lexml_home_dir == null) {
            logger.error("getLexMLHome n\u00e3o conseguiu encontrar LEXML_HOME");
            throw new FileNotFoundException("LEXML_HOME n\u00e3o foi definido.");
        }
        Properties prop = System.getProperties();
        logger.debug("LEXML_HOME definido como:'" + lexml_home_dir + "'");
        return lexml_home_dir;
    }

    public static long nowInMillisGMT() {
        Calendar c = Calendar.getInstance(Locale.getDefault());
        return c.getTimeInMillis();
    }

    public static InputStream getInputStreamFromLexMLHome(String p_file) throws FileNotFoundException {
        InputStream iS = null;
        logger.info("CP 1");
        if (lexml_home_dir == null) {
            LexMLUtil.getLexMLHome();
        }
        logger.info("CP 2");
        logger.info("Tentando carregar " + lexml_home_dir + File.separator + p_file);
        if (lexml_home_dir != null) {
            logger.info("CP 3");
            iS = new FileInputStream(String.valueOf(lexml_home_dir) + File.separator + p_file);
            logger.info("CP 4");
            if (iS == null) {
                logger.info("CP 5");
                iS = LexMLUtil.class.getResourceAsStream(String.valueOf(lexml_home_dir) + File.separator + p_file);
                logger.info("CP 5.1");
            }
            try {
                logger.info("CP 6 O arquivo possui " + ((InputStream)iS).available() + " bytes");
            }
            catch (IOException e) {
                logger.info("CP 6.1", e);
            }
        }
        return iS;
    }

    public static Properties getJPAProperties() throws NamingException, ConfigFailedException {
        if (jpa_properties != null) {
            return jpa_properties;
        }
        Properties new_properties = new Properties();
        logger.log(Level.DEBUG, "Carregando properties do arquivo: lexml-db.properties");
        InputStream isProperties = null;
        try {
            isProperties = LexMLUtil.getInputStreamFromLexMLHome("lexml-db.properties");
            new_properties.load(isProperties);
            isProperties.close();
            jpa_properties = new_properties;
        }
        catch (FileNotFoundException e1) {
            logger.error("Arquivo n\u00e3o encontrado: lexml-db.properties");
            throw new ConfigFailedException("Arquivo n\u00e3o encontrado: lexml-db.properties", e1);
        }
        catch (IOException e2) {
            logger.error("Erro de I/O ao carregar arquivo lexml-db.properties");
            throw new ConfigFailedException("Erro de I/O ao carregar arquivo lexml-db.properties", e2);
        }
        if (isProperties == null) {
            logger.error("N\u00e3o foi poss\u00edvel ler arquivo de properties a partir do getInputStreamFromLexMLHome");
            throw new ConfigFailedException("N\u00e3o foi poss\u00edvel ler arquivo de properties a partir do getInputStreamFromLexMLHome");
        }
        logger.info("Arquivo de properties carregado com sucesso.");
        jpa_properties.list(System.out);
        return jpa_properties;
    }

    /*
     * Unable to fully structure code
     */
    public static ConfiguracaoProvedorDocument readConfiguracaoProvedor(String p_file) throws NamingException, FileNotFoundException, ConfigFailedException {
        block28: {
            isPerfil = LexMLUtil.getInputStreamFromLexMLHome(p_file);
            confProvedor = null;
            if (isPerfil != null) {
                block27: {
                    block29: {
                        block23: {
                            block25: {
                                block24: {
                                    block26: {
                                        xmlOpt = new XmlOptions();
                                        xmlOpt.setLoadStripComments();
                                        xmlOpt.setSaveNoXmlDecl();
                                        xmlOpt.setSavePrettyPrintIndent(3);
                                        xmlOpt.setLoadStripProcinsts();
                                        xmlOpt.setLoadStripProcinsts();
                                        xmlOpt.setSaveAggressiveNamespaces();
                                        validationErrors = new ArrayList<E>();
                                        xmlOpt.setErrorListener(validationErrors);
                                        try {
                                            try {
                                                confProvedor = ConfiguracaoProvedorDocument.Factory.parse(isPerfil, xmlOpt);
                                                if (!confProvedor.validate(xmlOpt)) {
                                                    LexMLUtil.logger.log(Level.ERROR, "Validate do XMLBeans falhou para: " + p_file);
                                                }
                                                break block23;
                                            }
                                            catch (XmlException e) {
                                                throw new ConfigFailedException("Erro de XML ao abrir o arquivo " + p_file, e);
                                            }
                                            catch (IOException e) {
                                                throw new ConfigFailedException("N\u00e3o foi poss\u00edvel abrir o arquivo " + p_file, e);
                                            }
                                        }
                                        catch (Throwable var6_7) {
                                            try {
                                                isPerfil.close();
                                                break block24;
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                                if (validationErrors.size() <= 0) break block25;
                                                iter = validationErrors.iterator();
                                                ** while (iter.hasNext())
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                                            continue;
                                        }
lbl42:
                                        // 1 sources

                                        throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                                        {
                                            catch (Throwable var8_16) {
                                                if (validationErrors.size() <= 0) break block26;
                                                iter = validationErrors.iterator();
                                                ** while (iter.hasNext())
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                                            continue;
                                        }
lbl49:
                                        // 1 sources

                                        throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                                    }
                                    throw var8_16;
                                }
                                if (validationErrors.size() > 0) {
                                    iter = validationErrors.iterator();
                                    while (iter.hasNext()) {
                                        LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                                    }
                                    throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                                }
                            }
                            throw var6_7;
                        }
                        try {
                            try {
                                isPerfil.close();
                                break block27;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (validationErrors.size() <= 0) break block28;
                                iter = validationErrors.iterator();
                                ** while (iter.hasNext())
                            }
                        }
                        catch (Throwable var8_17) {
                            if (validationErrors.size() <= 0) break block29;
                            iter = validationErrors.iterator();
                            ** while (iter.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                            continue;
                        }
lbl73:
                        // 1 sources

                        throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
lbl-1000:
                        // 1 sources

                        {
                            LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                            continue;
                        }
lbl80:
                        // 1 sources

                        throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                    }
                    throw var8_17;
                }
                if (validationErrors.size() > 0) {
                    iter = validationErrors.iterator();
                    while (iter.hasNext()) {
                        LexMLUtil.logger.log(Level.ERROR, iter.next().toString());
                    }
                    throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                }
            }
        }
        return confProvedor;
    }
}

