/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda;

import br.gov.lexml.borda.business.ToolKitBO;
import br.gov.lexml.borda.business.ValidadorBO;
import br.gov.lexml.borda.helper.ToolKitHelper;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.io.File;
import java.io.IOException;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Toolkit {
    private static Logger logger = Logger.getLogger(Toolkit.class.getName());
    private static final boolean APAGAR_ARQUIVOS_IMPORTADOS_COM_SUCESSO = false;
    private static final boolean APAGAR_ARQUIVOS_CONSUMIDOS_COM_SUCESSO = true;
    private static final boolean APAGAR_ARQUIVOS_AGREGADOS_COM_SUCESSO = false;

    public static void printHelp() {
        System.out.println("Existem 3 modos de usar o Toolkit LexML de Nodo Borda:");
        System.out.println("1- Para importar arquivos em formato oai_lexml de um diret\u00f3rio do nodo local. Sem apagar os arquivos originais.");
        System.out.println("toolkit.bat  importar c:\\diretorio");
        System.out.println("onde c:\\diretorio \u00e9 a pasta aonde est\u00e3o os arquivos de metadados em formato XML a serem importados para o lexml-db");
        System.out.println("2- Para importar os registros em formato oai_lexml de um diret\u00f3rio local apagando os arquivos originais . ");
        System.out.println("toolkit.bat  consumir c:\\diretorio");
        System.out.println("onde c:\\diretorio \u00e9 a pasta aonde est\u00e3o os arquivos de metadados em formato XML a serem importados para lexml-db e em seguida eliminados");
        System.out.println("3- Para validar os registros em formato oai_lexml da base de dados do nodo local.");
        System.out.println("toolkit.bat  validar c:\\diretorio");
        System.out.println("onde c:\\diretorio \u00e9 a pasta aonde ser\u00e3o gravados os arquivos de log, erro e debug gerados durante a valida\u00e7\u00e3o");
        System.out.println("4- Para exportar arquivos em formato oai_lexml para um diret\u00f3rio do nodo local.");
        System.out.println("toolkit.bat  exportar c:\\diretorio");
        System.out.println("onde c:\\diretorio \u00e9 a pasta aonde est\u00e3o os arquivos de metadados em formato XML exportados do lexml-db");
    }

    public void validar(String p_diretorio) throws ConfigFailedException {
        try {
            ToolKitHelper.initLog4J(String.valueOf(p_diretorio) + File.separator + "validador");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        ValidadorBO bo = new ValidadorBO(0);
        System.out.println("Iniciando a valida\u00e7\u00e3o dos registros indefinidos.");
        bo.validarRegistrosIndefinidos();
    }

    public void consumir(String p_diretorio) throws ConfigFailedException {
        try {
            ToolKitHelper.initLog4J(String.valueOf(p_diretorio) + File.separator + "consumidor");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        ToolKitBO tkBO = new ToolKitBO(1);
        try {
            tkBO.consumirPasta(p_diretorio, true);
        }
        catch (IOException e) {
            System.out.println("Houve algum erro de acesso ao diret\u00f3rio ou aos seus arquivos durante a importa\u00e7\u00e3o, por favor verifique os arquivos de log e erro");
            e.printStackTrace();
        }
    }

    public void importar(String p_diretorio) throws ConfigFailedException {
        try {
            ToolKitHelper.initLog4J(String.valueOf(p_diretorio) + File.separator + "importador");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        ToolKitBO tkBO = new ToolKitBO(0);
        try {
            tkBO.consumirPasta(p_diretorio, false);
        }
        catch (IOException e) {
            System.out.println("Houve algum erro de acesso ao diret\u00f3rio ou aos seus arquivos durante a importa\u00e7\u00e3o, por favor verifique os arquivos de log e erro");
            e.printStackTrace();
        }
    }

    public void agregar(String p_diretorio) throws ConfigFailedException {
        try {
            ToolKitHelper.initLog4J(String.valueOf(p_diretorio) + File.separator + "agregador");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        ToolKitBO tkBO = new ToolKitBO(1);
        try {
            tkBO.consumirPasta(p_diretorio, false);
        }
        catch (IOException e) {
            System.out.println("Houve algum erro de acesso ao diret\u00f3rio ou aos seus arquivos durante a agregacao, por favor verifique os arquivos de log e erro");
            e.printStackTrace();
        }
    }

    public void exportar(String p_diretorio) throws ConfigFailedException {
        try {
            ToolKitHelper.initLog4J(String.valueOf(p_diretorio) + File.separator + "exportador");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        System.out.println("Iniciando o processo de exporta\u00e7\u00e3o dos registros.");
        ToolKitBO bo = new ToolKitBO(0);
        try {
            bo.exportarParaPasta(p_diretorio);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws NamingException {
        if (args.length < 2 || "-h".equals(args[0]) || "--help".equals(args[0]) || "help".equals(args[0])) {
            Toolkit.printHelp();
            return;
        }
        String comando = args[0];
        String diretorio = args[1];
        File dir = new File(diretorio);
        if (!dir.isDirectory()) {
            System.out.println("O argumento: " + diretorio + " passado n\u00e3o foi encontrado ou n\u00e3o \u00e9 um diret\u00f3rio");
            Toolkit.printHelp();
        } else {
            try {
                Toolkit tk = new Toolkit();
                if ("validar".equalsIgnoreCase(comando) || "-v".equalsIgnoreCase(comando)) {
                    tk.validar(diretorio);
                } else if ("importar".equalsIgnoreCase(comando) || "-i".equalsIgnoreCase(comando)) {
                    tk.importar(diretorio);
                    tk.validar(diretorio);
                } else if ("consumir".equalsIgnoreCase(comando) || "-c".equalsIgnoreCase(comando)) {
                    tk.consumir(diretorio);
                    tk.validar(diretorio);
                } else if ("exportar".equals(comando) || "-e".equalsIgnoreCase(comando)) {
                    tk.exportar(diretorio);
                } else if ("agregar".equals(comando) || "-a".equalsIgnoreCase(comando)) {
                    tk.agregar(diretorio);
                    tk.validar(diretorio);
                } else if ("gerar".equals(comando)) {
                    tk.gerar200000();
                } else {
                    System.out.println("Comando: " + comando + " n\u00e3o \u00e9 suportado");
                    Toolkit.printHelp();
                }
            }
            catch (ConfigFailedException e) {
                logger.log(Level.FATAL, e.getMessage());
            }
        }
    }

    public void gerar200000() throws ConfigFailedException {
        ToolKitBO bo = new ToolKitBO(0);
        bo.geraTests(1, 1000);
        bo.geraTests(1000, 10000);
        bo.geraTests(10000, 50000);
        bo.geraTests(50000, 100000);
        bo.geraTests(100000, 150000);
        bo.geraTests(150000, 190000);
        bo.geraTests(190000, 250000);
    }
}

