/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.exceptions.NotValidLexmlException;
import br.gov.lexml.exceptions.NullLexmlException;
import br.gov.lexml.oaiLexml.LexMLDocument;
import java.util.logging.Logger;

public class NodoBordaBO {
    private static Logger logger = Logger.getLogger(NodoBordaBO.class.getName());
    private RegistroItemDAO m_dao;
    public static final int ERRO = -1;
    public static final int OK = 0;
    public static final int INSERTED = 1;
    public static final int UPDATED = 2;
    public static final int DELETED = 4;

    private RegistroItemDAO checkDAO() {
        if (this.m_dao == null) {
            this.m_dao = new RegistroItemDAO();
        }
        return this.m_dao;
    }

    public int insert(LexMLDocument p_doc) throws NullLexmlException, NotValidLexmlException {
        this.checkLexMLDocument(p_doc);
        RegistroItem ri = this.checkDAO().load(p_doc.getLexML().getDocumentoIndividual().getStringValue().trim());
        if (ri == null) {
            logger.info("Registro novo");
            ri = new RegistroItem();
            ri.setIdRegistroItem(p_doc.getLexML().getDocumentoIndividual().getStringValue().trim());
            ri.setTxMetadadoXml(p_doc.toString());
            ri.setCdStatus("V");
            ri.setCdValidacao("F");
            this.checkDAO().save(ri);
            return 1;
        }
        ri.setTxMetadadoXml(p_doc.toString());
        this.checkDAO().update(ri);
        return 2;
    }

    public void update(LexMLDocument p_doc) throws NullLexmlException, NotValidLexmlException {
        this.checkLexMLDocument(p_doc);
        RegistroItem ri = this.checkDAO().load(p_doc.getLexML().getDocumentoIndividual().getStringValue().trim());
        this.m_dao.save(ri);
    }

    public void delete(LexMLDocument p_doc) throws NullLexmlException, NotValidLexmlException {
        this.checkLexMLDocument(p_doc);
        RegistroItem ri = this.checkDAO().load(p_doc.getLexML().getDocumentoIndividual().getStringValue().trim());
        this.m_dao.oaiDelete(ri);
    }

    private void checkLexMLDocument(LexMLDocument p_doc) throws NullLexmlException, NotValidLexmlException {
        if (p_doc == null) {
            throw new NullLexmlException();
        }
        if (!(p_doc instanceof LexMLDocument) || !p_doc.validate()) {
            throw new NotValidLexmlException();
        }
    }
}

