/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.borda.business.AbstractBO;
import br.gov.lexml.borda.business.ValidadorBO;
import br.gov.lexml.borda.dao.ConjuntoItemDAO;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.dao.ToolKitDAO;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ToolKitBO
extends AbstractBO {
    private static Logger logger = Logger.getLogger(ToolKitBO.class.getName());
    private ValidadorBO validadorBO = null;
    private static final int TAMANHO_LISTA = 100;
    private RegistroItemDAO m_ri_dao;
    private ConjuntoItemDAO m_ci_dao;
    private List<String> arquivos = new ArrayList<String>();
    private boolean delete_imported_files = false;
    private static final boolean VALIDA_DURANTE_CARGA = false;
    private int arquivos_processados = 0;
    private int sucessos = 0;
    private int falhas = 0;

    public ToolKitBO(int p_modo) throws ConfigFailedException {
        this.init(p_modo);
    }

    private boolean processarRegistro(RegistroItem p_ri) {
        p_ri.setCdStatus("N");
        p_ri.setCdValidacao("I");
        return true;
    }

    public void init(int p_modo) throws ConfigFailedException {
        if (this.validadorBO == null) {
            this.validadorBO = new ValidadorBO(p_modo);
        }
        if (this.m_ri_dao == null) {
            this.m_ri_dao = new RegistroItemDAO();
        }
        if (this.m_ci_dao == null) {
            this.m_ci_dao = new ConjuntoItemDAO();
        }
    }

    private void processarConjuntoItemParaORegistroItem(String p_path, RegistroItem p_ri) {
        String idStr = null;
        String[] path_parts = p_path.split("\\" + File.separator);
        if (path_parts.length > 0) {
            idStr = path_parts[path_parts.length - 1];
            ConjuntoItem ci = this.m_ci_dao.load(idStr);
            if (ci == null) {
                ci = new ConjuntoItem();
                ci.setIdConjuntoItem(idStr);
                ci.setDeConjuntoItem("Conjunto do " + idStr);
                this.m_ci_dao.save(ci);
            }
            p_ri.setIdConjuntoItem(ci);
        }
    }

    private void processarArquivo(String p_path, String p_arquivo) throws IOException {
        block12: {
            File arquivo = new File(String.valueOf(p_path) + File.separator + p_arquivo);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            boolean sucesso = false;
            if (arquivo.isFile() && arquivo.canRead()) {
                BufferedReader br = null;
                FileInputStream fis = null;
                StringBuffer sb = new StringBuffer();
                try {
                    try {
                        String s;
                        RegistroItem ri = new RegistroItem();
                        ri.setIdConjuntoItem(null);
                        String id = URLDecoder.decode(p_arquivo, "UTF-8").replace(".xml", "");
                        fis = new FileInputStream(arquivo);
                        br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                        while ((s = br.readLine()) != null) {
                            sb.append(String.valueOf(s) + "\n");
                        }
                        sb.trimToSize();
                        logger.debug("Extra\u00eddo o Identifier OAI:" + id + " do arquivo: " + p_arquivo + " no diretorio " + p_path);
                        ri.setIdRegistroItem(id);
                        ri.setTxMetadadoXml(sb.toString());
                        sucesso = this.processarRegistro(ri);
                        if (sucesso) {
                            ++this.sucessos;
                            this.processarConjuntoItemParaORegistroItem(p_path, ri);
                            this.m_ri_dao.saveOrUpdate(ri);
                            ++this.arquivos_processados;
                            this.deletar(String.valueOf(p_path) + File.separator + p_arquivo, 100);
                            logger.debug("Arquivo " + p_arquivo + " processado com sucesso!");
                            this.checkListsSizes(100);
                            break block12;
                        }
                        ++this.falhas;
                    }
                    catch (Throwable t) {
                        logger.error("Arquivo " + p_arquivo + " falhou durante processamento.", t);
                        if (br != null) {
                            br.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        br = null;
                        fis = null;
                    }
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    br = null;
                    fis = null;
                }
            }
        }
    }

    private void checkListsSizes(int tamanhoLista) {
        if (this.arquivos_processados >= tamanhoLista && this.m_ri_dao.inBulkMode()) {
            logger.info("Commit de " + this.arquivos_processados + " registros importados");
            this.m_ri_dao.bulkCommit();
            this.m_ri_dao.beginBulkMode();
            this.arquivos_processados = 0;
        }
    }

    public void geraTests(int p_i, int p_j) {
        String id = "oai:novoteste.br:";
        int k = 0;
        this.m_ri_dao.beginBulkMode();
        int i = p_i;
        while (i < p_j) {
            ++k;
            RegistroItem ri = new RegistroItem();
            ri.setIdConjuntoItem(null);
            ri.setIdRegistroItem(String.valueOf(id) + i);
            ri.setTxMetadadoXml("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"><dc:description>adasd</dc:description></oai_dc:dc>");
            ri.setCdStatus("N");
            ri.setCdValidacao("O");
            this.m_ri_dao.saveOrUpdate(ri);
            if (k > 1999) {
                this.m_ri_dao.bulkCommit();
                this.m_ri_dao.beginBulkMode();
                k = 0;
            }
            ++i;
        }
        this.m_ri_dao.bulkCommit();
    }

    private void deletar(String p_arquivo, int p_tam) {
        if (!this.delete_imported_files) {
            return;
        }
        if (this.arquivos.size() < p_tam - 1 && p_arquivo != null) {
            this.arquivos.add(p_arquivo);
        } else {
            if (p_arquivo != null) {
                this.arquivos.add(p_arquivo);
            }
            System.out.println("Apagando " + this.arquivos.size() + " arquivo(s)");
            int i = 0;
            while (i < this.arquivos.size()) {
                String nome_arquivo = this.arquivos.get(i);
                logger.log(Level.WARN, "Apagando o arquivo " + i + " " + nome_arquivo);
                File arquivo = new File(nome_arquivo);
                if (!arquivo.delete()) {
                    logger.log(Level.ERROR, " falha na dele\u00e7\u00e3o");
                }
                ++i;
            }
            this.arquivos = new ArrayList<String>();
        }
    }

    private void processarDiretorio(String p_dir) throws IOException {
        File dir = new File(p_dir);
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children == null) {
                logger.info("Diret\u00f3rio n\u00e3o pode ser acessado ou est\u00e1 vazio");
            } else {
                int i = 0;
                while (i < children.length) {
                    String filename = children[i];
                    if (filename.endsWith(".xml")) {
                        this.processarArquivo(p_dir, filename);
                    } else {
                        this.processarDiretorio(String.valueOf(p_dir) + File.separator + filename);
                    }
                    ++i;
                }
            }
        }
    }

    public void consumirPasta(String p_dir, boolean p_delete_imported_files) throws IOException {
        boolean myBulkTransaction = this.m_ri_dao.beginBulkMode();
        this.sucessos = 0;
        this.falhas = 0;
        this.delete_imported_files = p_delete_imported_files;
        logger.info("Iniciando o processamento do diret\u00f3rio " + p_dir);
        if (this.delete_imported_files) {
            logger.info("Os arquivos importados com sucesso ser\u00e3o apagados ao final do processamento");
        }
        this.processarDiretorio(p_dir);
        this.checkListsSizes(0);
        if (myBulkTransaction) {
            this.m_ri_dao.bulkCommit();
        }
        this.deletar(null, 0);
        logger.info("---------------------------------------");
        logger.info("Foram importados " + this.sucessos + " registros com sucesso.");
        logger.info("Foram importados " + this.falhas + " registros com falha.");
    }

    public void exportarParaPasta(String p_dir) throws IOException {
        File dir = new File(p_dir);
        String INICIO_XML = "<?xml";
        if (!dir.isDirectory()) {
            System.out.println("Pasta n\u00e3o encontrada.");
            logger.log(Level.ERROR, "Diret\u00f3rio informado n\u00e3o foi encontrado");
        } else {
            List<RegistroItem> listagem = this.m_ri_dao.listByTimeWindow(null, new Date());
            Iterator<RegistroItem> it = listagem.iterator();
            int contagem = listagem.size();
            logger.log(Level.INFO, "Preparando para exportar " + contagem + " registros na pasta:" + p_dir);
            int c = 0;
            while (it.hasNext()) {
                ++c;
                RegistroItem registro = it.next();
                String xml = registro.getTxMetadadoXml();
                String pi = xml.substring(0, 5);
                String newFile = URLEncoder.encode(registro.getIdRegistroItem(), "UTF-8").concat(".xml");
                String arquivo = String.valueOf(p_dir) + File.separator + newFile;
                logger.info("gravando registro #" + c + " para o arquivo: " + arquivo);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo), "UTF-8");
                if (!"<?xml".equals(pi)) {
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                }
                try {
                    out.write(xml);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out.close();
            }
            logger.info("Finalizada a exporta\u00e7\u00e3o");
        }
    }

    public void instalarBancoDeDados() {
        try {
            new ToolKitDAO().instalaBancoDeDados();
        }
        catch (Exception e) {
            logger.error("N\u00e3o foi poss\u00edvel inicializar corretamente o banco de dados", e);
        }
    }

    public int getSucessos() {
        return this.sucessos;
    }

    public void setSucessos(int sucessos) {
        this.sucessos = sucessos;
    }

    public int getFalhas() {
        return this.falhas;
    }

    public void setFalhas(int falhas) {
        this.falhas = falhas;
    }
}

