/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.apache.log4j.Logger;
import org.hibernate.ejb.Ejb3Configuration;

public class EMFFactory {
    private static Logger logger = Logger.getLogger(EMFFactory.class.getName());
    private static EntityManagerFactory emf = null;

    public static final EntityManagerFactory getEMF(Properties properties) throws ConfigFailedException {
        if (emf != null) {
            return emf;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Criando EntityManagerFactory para a Persistence Unit: borda-db");
        }
        if (properties == null) {
            logger.error("Properties passado \u00e9 nulo");
        } else {
            Ejb3Configuration cfg = new Ejb3Configuration();
            cfg.addProperties(properties).addAnnotatedClass(RegistroItem.class).addAnnotatedClass(RegistroItemErro.class).addAnnotatedClass(RegistroItemLog.class).addAnnotatedClass(TipoErro.class).addAnnotatedClass(ConjuntoItem.class);
            emf = cfg.buildEntityManagerFactory();
        }
        if (emf == null) {
            logger.error("N\u00e3o foi possivel criar EntityManagerFactory.");
        }
        return emf;
    }

    public static final EntityManagerFactory getEMF() throws ConfigFailedException {
        try {
            return EMFFactory.getEMF(LexMLUtil.getJPAProperties());
        }
        catch (NamingException e) {
            logger.error("Verifique a variavel LEXML_HOME no ambiente de execucao ou na configuracao JNDI", e);
            throw new ConfigFailedException("LEXML_HOME n\u00e3o foi definida no JNDI", e);
        }
        catch (ConfigFailedException e) {
            logger.error("Erro de configuracao", e);
            throw e;
        }
    }
}

