/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.dao.AbstractDAO;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.domain.TipoErro;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistroItemDAO
extends AbstractDAO {
    public List<RegistroItem> listByTimeWindow(Date from, Date until) {
        return this.listByTimeWindowAndSet(from, until, null, 0, 0);
    }

    public List<RegistroItem> listByTimeWindowAndSet(Date from, Date until, String idConjunto, int first, int max) {
        if (until == null) {
            until = new Date();
        }
        if (from == null) {
            from = new Date(0L);
        }
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri " + this.getFromStr(from, until, idConjunto));
        query.setParameter("pfrom", (Object)from);
        query.setParameter("puntil", (Object)until);
        if (idConjunto != null) {
            query.setParameter("pset", (Object)idConjunto);
        }
        if (first > 0) {
            query.setFirstResult(first);
        }
        if (max > 0) {
            query.setMaxResults(max);
        }
        return query.getResultList();
    }

    public int countListByTimeWindowAndSet(Date from, Date until, String idConjunto) {
        Number row;
        if (until == null) {
            until = new Date();
        }
        if (from == null) {
            from = new Date(0L);
        }
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT count(ri.idRegistroItem) " + this.getFromStr(from, until, idConjunto));
        query.setParameter("pfrom", (Object)from);
        query.setParameter("puntil", (Object)until);
        if (idConjunto != null) {
            query.setParameter("pset", (Object)idConjunto);
        }
        if ((row = (Number)query.getSingleResult()) != null) {
            return row.intValue();
        }
        return 0;
    }

    private String getFromStr(Date from, Date until, String idConjunto) {
        String queryStr = " FROM RegistroItem ri WHERE ri.cdValidacao ='O' AND ri.tsRegistroGmt <=:puntil AND ri.tsRegistroGmt >=:pfrom";
        if (idConjunto != null) {
            queryStr = queryStr.concat(" AND ri.idConjuntoItem =:pset ");
        }
        return queryStr;
    }

    public List<RegistroItem> listNotValid() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.cdValidacao <> :ok");
        query.setParameter("ok", (Object)"O");
        return query.getResultList();
    }

    public List<ConjuntoItem> listAllSets() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ci FROM ConjuntoItem ci");
        return query.getResultList();
    }

    public RegistroItem load(String identifier) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.idRegistroItem =:rid ");
        query.setParameter("rid", (Object)identifier);
        try {
            return (RegistroItem)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RegistroItemErro newLogErr(RegistroItem p_ri, TipoErro p_te, String p_detalhe_erro) {
        RegistroItemErro erro = new RegistroItemErro();
        erro.setIdRegistroItem(p_ri);
        if (p_detalhe_erro == null) {
            p_detalhe_erro = "sem detalhe";
        }
        erro.setDeDetalheItemErro(p_detalhe_erro);
        erro.setTsRegistroGmt(p_ri.getTsRegistroGmt());
        erro.setIdTipoErro(p_te);
        return erro;
    }

    public RegistroItemLog newLogMsg(RegistroItem p_ri, String p_msg) {
        RegistroItemLog log = new RegistroItemLog();
        this.timeStamp(log);
        log.setIdRegistroItem(p_ri);
        log.setDeMensagem(p_msg);
        log.setTsRegistroGmt(p_ri.getTsRegistroGmt());
        return log;
    }

    public void oaiDelete(RegistroItem ri) {
        ri.setCdStatus("D");
        this.update(ri);
    }

    public void saveList(List p_list) {
        Iterator iter = p_list.iterator();
        boolean inBulk = this.inBulkMode();
        if (!inBulk) {
            this.beginBulkMode();
        }
        while (iter.hasNext()) {
            this.save(iter.next());
        }
        if (!inBulk) {
            this.bulkCommit();
        }
    }

    public void save(Object p_obj) {
        this.timeStamp(p_obj);
        this.saveObject(p_obj);
    }

    public void saveOrUpdate(RegistroItem p_ri) {
        EntityManager em = this.getEntityManager();
        RegistroItem ri = em.find(RegistroItem.class, p_ri.getIdRegistroItem());
        if (ri == null) {
            this.save(p_ri);
        } else {
            this.update(p_ri);
        }
    }

    public void timeStamp(Object p_obj) {
        Timestamp now = new Timestamp(LexMLUtil.nowInMillisGMT());
        if (RegistroItem.class.isInstance(p_obj)) {
            ((RegistroItem)p_obj).setTsRegistroGmt(now);
        } else if (RegistroItemLog.class.isInstance(p_obj)) {
            ((RegistroItemLog)p_obj).setTsProcessamento(now);
        } else if (RegistroItemErro.class.isInstance(p_obj)) {
            ((RegistroItemErro)p_obj).setTsProcessamento(now);
        }
    }

    public void updateList(List p_list) {
        Iterator iter = p_list.iterator();
        boolean wasInBulkMode = this.inBulkMode();
        if (!wasInBulkMode) {
            this.beginBulkMode();
        }
        while (iter.hasNext()) {
            this.update(iter.next());
        }
        if (!wasInBulkMode) {
            this.bulkCommit();
        }
    }

    public void update(Object p_obj) {
        this.timeStamp(p_obj);
        this.updateObject(p_obj);
    }

    public List<RegistroItem> listAll(int offset, int limit) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri ");
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public int countAll() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri ");
        return query.getResultList().size();
    }
}

