/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class ToolKitDAO {
    private static final Logger logger = Logger.getLogger(ToolKitDAO.class.getName());

    public void instalaBancoDeDados() throws NamingException, ConfigFailedException {
        Properties props = LexMLUtil.getJPAProperties();
        if (props == null) {
            logger.error("Foi recebido um null no lugar das propriedades para o JPA.");
            throw new ConfigFailedException("Propriedades recebidas s\u00e3o podem ser nulas");
        }
        props.setProperty("hibernate.hbm2ddl.auto", "validate");
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.setProperties(props);
        cfg.addAnnotatedClass(RegistroItem.class);
        cfg.addAnnotatedClass(RegistroItemLog.class);
        cfg.addAnnotatedClass(RegistroItemErro.class);
        cfg.addAnnotatedClass(TipoErro.class);
        cfg.addAnnotatedClass(ConjuntoItem.class);
        SchemaExport se = new SchemaExport(cfg);
        se.setOutputFile("lexml_create_ddl.sql");
        se.execute(true, true, false, false);
        List erros = se.getExceptions();
        if (erros.size() > 0) {
            logger.debug("Total de exce\u00e7\u00f5es durante a execu\u00e7\u00e3o da cria\u00e7\u00e3o do banco de dados" + erros.size());
            int i = 0;
            while (i < erros.size()) {
                Exception e = (Exception)erros.get(i);
                logger.error("[" + i + "] =" + e);
                ++i;
            }
        }
    }

    private void validaBancoDeDados() throws NamingException, ConfigFailedException {
        Properties props = LexMLUtil.getJPAProperties();
        props.setProperty("hibernate.hbm2ddl.auto", "update");
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.setProperties(props);
        cfg.addAnnotatedClass(RegistroItem.class);
        cfg.addAnnotatedClass(RegistroItemLog.class);
        cfg.addAnnotatedClass(RegistroItemErro.class);
        cfg.addAnnotatedClass(TipoErro.class);
        cfg.addAnnotatedClass(ConjuntoItem.class);
        SchemaUpdate su = new SchemaUpdate(cfg);
        su.execute(false, false);
    }
}

