/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.helper;

import br.gov.lexml.LexMLSystem;
import br.gov.lexml.borda.business.AbstractBO;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ToolKitHelper {
    public static final String LOG_SUFFIX = "_log.txt";
    public static final String DEBUG_SUFFIX = "_debug.txt";
    public static final String ERR_SUFFIX = "_erros.txt";
    private static String conversionPattern = "%d{ISO8601} [%-50c:%-4L] %-5p : %m%n";
    private static String minimoPattern = "%d{HH:mm:ss,SSS} %-5p [%-13C{1}:%4L] %m%n";
    private static boolean init = false;

    public static final void initLog(String p_filePrefix) throws IOException {
        if (init) {
            return;
        }
        Logger rootLogger = Logger.getRootLogger();
        Logger subLogger = Logger.getLogger(LexMLSystem.class.getPackage().getName());
        Logger businessLogger = Logger.getLogger(AbstractBO.class.getPackage().getName());
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern(conversionPattern);
        PatternLayout layoutMinimo = new PatternLayout();
        layoutMinimo.setConversionPattern(minimoPattern);
        FileAppender debug = new FileAppender(layout, p_filePrefix.concat(DEBUG_SUFFIX), false);
        debug.setThreshold(Level.DEBUG);
        FileAppender log = new FileAppender(layout, p_filePrefix.concat(LOG_SUFFIX), false);
        log.setThreshold(Level.INFO);
        FileAppender err = new FileAppender(layout, p_filePrefix.concat(ERR_SUFFIX), false);
        err.setThreshold(Level.ERROR);
        ConsoleAppender ca = new ConsoleAppender(layoutMinimo);
        ca.setThreshold(Level.INFO);
        rootLogger.addAppender(debug);
        businessLogger.addAppender(ca);
        subLogger.addAppender(log);
        subLogger.addAppender(err);
        init = true;
    }

    public static final void initLog4J(String p_filePrefix) throws IOException {
        BasicConfigurator.configure();
        init = true;
    }
}

