/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.ValueInclusion;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.tuple.entity.EntityEntityModeToTuplizerMapping;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.ReflectHelper;

public class EntityMetamodel
implements Serializable {
    private static final Log log = LogFactory.getLog(EntityMetamodel.class);
    private static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final String name;
    private final String rootName;
    private final EntityType entityType;
    private final IdentifierProperty identifierProperty;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final StandardProperty[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] nonlazyPropertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final ValueInclusion[] insertInclusions;
    private final ValueInclusion[] updateInclusions;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final CascadeStyle[] cascadeStyles;
    private final boolean hasInsertGeneratedValues;
    private final boolean hasUpdateGeneratedValues;
    private final Map propertyIndexes = new HashMap();
    private final boolean hasCollections;
    private final boolean hasMutableProperties;
    private final boolean hasLazyProperties;
    private final boolean hasNonIdentifierPropertyNamedId;
    private final int[] naturalIdPropertyNumbers;
    private final boolean hasImmutableNaturalId;
    private boolean lazy;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final int optimisticLockMode;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set subclassEntityNames = new HashSet();
    private final EntityEntityModeToTuplizerMapping tuplizerMapping;

    public EntityTuplizer getTuplizer(EntityMode entityMode) {
        return (EntityTuplizer)this.tuplizerMapping.getTuplizer(entityMode);
    }

    public EntityTuplizer getTuplizerOrNull(EntityMode entityMode) {
        return (EntityTuplizer)this.tuplizerMapping.getTuplizerOrNull(entityMode);
    }

    public EntityMode guessEntityMode(Object object) {
        return this.tuplizerMapping.guessEntityMode(object);
    }

    public EntityMetamodel(PersistentClass persistentClass, SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.name = persistentClass.getEntityName();
        this.rootName = persistentClass.getRootClass().getEntityName();
        this.entityType = TypeFactory.manyToOne(this.name);
        this.identifierProperty = PropertyFactory.buildIdentifierProperty(persistentClass, sessionFactory.getIdentifierGenerator(this.rootName));
        this.versioned = persistentClass.isVersioned();
        boolean lazyAvailable = persistentClass.hasPojoRepresentation() && FieldInterceptionHelper.isInstrumented(persistentClass.getMappedClass());
        boolean hasLazy = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new StandardProperty[this.propertySpan];
        ArrayList<Integer> naturalIdNumbers = new ArrayList<Integer>();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.insertInclusions = new ValueInclusion[this.propertySpan];
        this.updateInclusions = new ValueInclusion[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        Iterator iter = persistentClass.getPropertyClosureIterator();
        int i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCollection = false;
        boolean foundMutable = false;
        boolean foundNonIdentifierPropertyNamedId = false;
        boolean foundInsertGeneratedValue = false;
        boolean foundUpdateGeneratedValue = false;
        boolean foundUpdateableNaturalIdProperty = false;
        while (iter.hasNext()) {
            boolean lazy;
            Property prop = (Property)iter.next();
            if (prop == persistentClass.getVersion()) {
                tempVersionProperty = i;
                this.properties[i] = PropertyFactory.buildVersionProperty(prop, lazyAvailable);
            } else {
                this.properties[i] = PropertyFactory.buildStandardProperty(prop, lazyAvailable);
            }
            if (prop.isNaturalIdentifier()) {
                naturalIdNumbers.add(new Integer(i));
                if (prop.isUpdateable()) {
                    foundUpdateableNaturalIdProperty = true;
                }
            }
            if ("id".equals(prop.getName())) {
                foundNonIdentifierPropertyNamedId = true;
            }
            boolean bl = lazy = prop.isLazy() && lazyAvailable;
            if (lazy) {
                hasLazy = true;
            }
            this.propertyLaziness[i] = lazy;
            this.propertyNames[i] = this.properties[i].getName();
            this.propertyTypes[i] = this.properties[i].getType();
            this.propertyNullability[i] = this.properties[i].isNullable();
            this.propertyUpdateability[i] = this.properties[i].isUpdateable();
            this.propertyInsertability[i] = this.properties[i].isInsertable();
            this.insertInclusions[i] = this.determineInsertValueGenerationType(prop, this.properties[i]);
            this.updateInclusions[i] = this.determineUpdateValueGenerationType(prop, this.properties[i]);
            this.propertyVersionability[i] = this.properties[i].isVersionable();
            this.nonlazyPropertyUpdateability[i] = this.properties[i].isUpdateable() && !lazy;
            this.propertyCheckability[i] = this.propertyUpdateability[i] || this.propertyTypes[i].isAssociationType() && ((AssociationType)this.propertyTypes[i]).isAlwaysDirtyChecked();
            this.cascadeStyles[i] = this.properties[i].getCascadeStyle();
            if (this.properties[i].isLazy()) {
                hasLazy = true;
            }
            if (this.properties[i].getCascadeStyle() != CascadeStyle.NONE) {
                foundCascade = true;
            }
            if (this.indicatesCollection(this.properties[i].getType())) {
                foundCollection = true;
            }
            if (this.propertyTypes[i].isMutable() && this.propertyCheckability[i]) {
                foundMutable = true;
            }
            if (this.insertInclusions[i] != ValueInclusion.NONE) {
                foundInsertGeneratedValue = true;
            }
            if (this.updateInclusions[i] != ValueInclusion.NONE) {
                foundUpdateGeneratedValue = true;
            }
            this.mapPropertyToIndex(prop, i);
            ++i;
        }
        if (naturalIdNumbers.size() == 0) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(naturalIdNumbers);
            this.hasImmutableNaturalId = !foundUpdateableNaturalIdProperty;
        }
        this.hasInsertGeneratedValues = foundInsertGeneratedValue;
        this.hasUpdateGeneratedValues = foundUpdateGeneratedValue;
        this.hasCascades = foundCascade;
        this.hasNonIdentifierPropertyNamedId = foundNonIdentifierPropertyNamedId;
        this.versionPropertyIndex = tempVersionProperty;
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            log.info("lazy property fetching available for: " + this.name);
        }
        this.lazy = persistentClass.isLazy() && (!persistentClass.hasPojoRepresentation() || !ReflectHelper.isFinalClass(persistentClass.getProxyInterface()));
        this.mutable = persistentClass.isMutable();
        if (persistentClass.isAbstract() == null) {
            this.isAbstract = persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass());
        } else {
            this.isAbstract = persistentClass.isAbstract();
            if (!this.isAbstract && persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass())) {
                log.warn("entity [" + this.name + "] is abstract-class/interface explicitly mapped as non-abstract; be sure to supply entity-names");
            }
        }
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate();
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.explicitPolymorphism = persistentClass.isExplicitPolymorphism();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockMode = persistentClass.getOptimisticLockMode();
        if (this.optimisticLockMode > 0 && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && this.optimisticLockMode > 0) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = foundCollection;
        this.hasMutableProperties = foundMutable;
        iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            this.subclassEntityNames.add(((PersistentClass)iter.next()).getEntityName());
        }
        this.subclassEntityNames.add(this.name);
        this.tuplizerMapping = new EntityEntityModeToTuplizerMapping(persistentClass, this);
    }

    private ValueInclusion determineInsertValueGenerationType(Property mappingProperty, StandardProperty runtimeProperty) {
        if (runtimeProperty.isInsertGenerated()) {
            return ValueInclusion.FULL;
        }
        if (mappingProperty.getValue() instanceof Component && this.hasPartialInsertComponentGeneration((Component)mappingProperty.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialInsertComponentGeneration(Component component) {
        Iterator subProperties = component.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property prop = (Property)subProperties.next();
            if (prop.getGeneration() == PropertyGeneration.ALWAYS || prop.getGeneration() == PropertyGeneration.INSERT) {
                return true;
            }
            if (!(prop.getValue() instanceof Component) || !this.hasPartialInsertComponentGeneration((Component)prop.getValue())) continue;
            return true;
        }
        return false;
    }

    private ValueInclusion determineUpdateValueGenerationType(Property mappingProperty, StandardProperty runtimeProperty) {
        if (runtimeProperty.isUpdateGenerated()) {
            return ValueInclusion.FULL;
        }
        if (mappingProperty.getValue() instanceof Component && this.hasPartialUpdateComponentGeneration((Component)mappingProperty.getValue())) {
            return ValueInclusion.PARTIAL;
        }
        return ValueInclusion.NONE;
    }

    private boolean hasPartialUpdateComponentGeneration(Component component) {
        Iterator subProperties = component.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property prop = (Property)subProperties.next();
            if (prop.getGeneration() == PropertyGeneration.ALWAYS) {
                return true;
            }
            if (!(prop.getValue() instanceof Component) || !this.hasPartialUpdateComponentGeneration((Component)prop.getValue())) continue;
            return true;
        }
        return false;
    }

    private void mapPropertyToIndex(Property prop, int i) {
        this.propertyIndexes.put(prop.getName(), new Integer(i));
        if (prop.getValue() instanceof Component) {
            Iterator iter = ((Component)prop.getValue()).getPropertyIterator();
            while (iter.hasNext()) {
                Property subprop = (Property)iter.next();
                this.propertyIndexes.put(prop.getName() + '.' + subprop.getName(), new Integer(i));
            }
        }
    }

    public int[] getNaturalIdentifierProperties() {
        return this.naturalIdPropertyNumbers;
    }

    public boolean hasNaturalIdentifier() {
        return this.naturalIdPropertyNumbers != null;
    }

    public boolean hasImmutableNaturalId() {
        return this.hasImmutableNaturalId;
    }

    public Set getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private boolean indicatesCollection(Type type) {
        if (type.isCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes = ((AbstractComponentType)type).getSubtypes();
            for (int i = 0; i < subtypes.length; ++i) {
                if (!this.indicatesCollection(subtypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierProperty;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String propertyName) {
        Integer index = this.getPropertyIndexOrNull(propertyName);
        if (index == null) {
            throw new HibernateException("Unable to resolve property: " + propertyName);
        }
        return index;
    }

    public Integer getPropertyIndexOrNull(String propertyName) {
        return (Integer)this.propertyIndexes.get(propertyName);
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasMutableProperties() {
        return this.hasMutableProperties;
    }

    public boolean hasNonIdentifierPropertyNamedId() {
        return this.hasNonIdentifierPropertyNamedId;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ':' + ArrayHelper.toString(this.properties) + ')';
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getNonlazyPropertyUpdateability() {
        return this.nonlazyPropertyUpdateability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public ValueInclusion[] getPropertyInsertGenerationInclusions() {
        return this.insertInclusions;
    }

    public ValueInclusion[] getPropertyUpdateGenerationInclusions() {
        return this.updateInclusions;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }

    public boolean hasInsertGeneratedValues() {
        return this.hasInsertGeneratedValues;
    }

    public boolean hasUpdateGeneratedValues() {
        return this.hasUpdateGeneratedValues;
    }
}

