/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.borda.business.AbstractBO;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ToolKitBO
extends AbstractBO {
    private static Logger logger = Logger.getLogger(ToolKitBO.class.getName());
    private static final int TAMANHO_LISTA = 300;
    private RegistroItemDAO registroItemDao;
    private List<String> arquivos = new ArrayList<String>();
    private boolean delete_imported_files = false;
    private int arquivos_processados = 0;
    private int sucessos = 0;
    private int falhas = 0;
    private final String exportarSQLNomeArquivo = "lexml_registro_item_dump.sql";
    List<RegistroItem> toSave = new ArrayList<RegistroItem>();
    private int gcCount;

    public ToolKitBO() throws ConfigFailedException {
        this.init();
    }

    public void init() throws ConfigFailedException {
        if (this.registroItemDao == null) {
            this.registroItemDao = new RegistroItemDAO();
        }
    }

    private void processarArquivo(String p_path, String p_arquivo, boolean full) throws IOException {
        File arquivo = new File(String.valueOf(p_path) + File.separator + p_arquivo);
        boolean sucesso = false;
        if (arquivo.isFile() && arquivo.canRead()) {
            try {
                String id = URLDecoder.decode(p_arquivo, "UTF-8");
                id = id.substring(0, id.length() - 4);
                boolean insert = true;
                Date tsBanco = this.registroItemDao.getTsRegistroGmt(id);
                if (tsBanco != null) {
                    if (!full && arquivo.lastModified() < tsBanco.getTime()) {
                        return;
                    }
                    insert = false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Extraido o Identifier OAI:" + id + " do arquivo: " + p_arquivo + " no diretorio " + p_path);
                }
                RegistroItem ri = new RegistroItem();
                ri.setIdRegistroItem(id);
                FileInputStream fis = new FileInputStream(arquivo);
                String xml = IOUtils.toString(fis);
                IOUtils.closeQuietly(fis);
                ri.setTxMetadadoXml(xml);
                ri.setCdStatus("N");
                ri.setCdValidacao("I");
                if (insert) {
                    this.registroItemDao.save(ri);
                } else {
                    this.registroItemDao.update(ri);
                }
                this.toSave.add(ri);
                ++this.arquivos_processados;
                logger.info("Arquivo " + p_arquivo + " processado com sucesso.");
                this.checkListsSizes(300);
                ++this.sucessos;
                sucesso = true;
            }
            catch (Throwable t) {
                logger.error("Arquivo " + p_arquivo + " falhou durante processamento.", t);
                ++this.falhas;
                this.recuperaDeFalha();
            }
            if (sucesso) {
                this.deletar(arquivo.getCanonicalPath(), 300);
            }
        }
    }

    private void recuperaDeFalha() {
        this.registroItemDao.rollback();
        this.registroItemDao.beginTransaction();
        if (this.toSave.isEmpty()) {
            return;
        }
        for (RegistroItem ri : this.toSave) {
            this.registroItemDao.saveOrUpdate(ri);
        }
        this.commitAndBeginTransaction();
    }

    private void checkListsSizes(int tamanhoLista) {
        if (this.arquivos_processados >= tamanhoLista) {
            logger.debug("Commit de " + this.arquivos_processados + " registros importados");
            this.commitAndBeginTransaction();
        }
    }

    private void commitAndBeginTransaction() {
        this.registroItemDao.commit();
        this.registroItemDao.clear();
        this.toSave.clear();
        this.limpaMemoria();
        this.registroItemDao.beginTransaction();
        this.arquivos_processados = 0;
    }

    private void limpaMemoria() {
        if (this.gcCount > 50) {
            System.gc();
            this.gcCount = 0;
        } else {
            ++this.gcCount;
        }
    }

    public void geraTests(int p_i, int p_j) {
        String id = "oai:novoteste.br:";
        int k = 0;
        this.registroItemDao.beginTransaction();
        int i = p_i;
        while (i < p_j) {
            ++k;
            RegistroItem ri = new RegistroItem();
            ri.setConjuntoItem(null);
            ri.setIdRegistroItem(String.valueOf(id) + i);
            ri.setTxMetadadoXml("<lexml:LexML xsi:schemaLocation=\"http://projeto.lexml.gov.br/esquemas/oai_lexml.xsd\" xmlns:lexml=\"http://www.lexml.gov.br/oai_lexml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <Item formato=\"text/html\" idPublicador=\"1\" tipo=\"conteudo\"> http://www6.senado.gov.br/legislacao/ListaPublicacoes.action?id=132554 </Item>  <Item formato=\"text/html\" idPublicador=\"1\" tipo=\"metadado\"> http://www6.senado.gov.br/legislacao/DetalhaDocumento.action?id=132554 </Item>  <DocumentoIndividual>urn:lex:br:federal:lei:1988-12-02;" + i + "@inicio.vigencia;publicacao;1988-12-05~texto;pt-br</DocumentoIndividual>" + "  <Epigrafe>Lei n\u00ba 7.682, de 02 de dezembro de 1988</Epigrafe>" + "  <Ementa>ALTERA O DECRETO-LEI 2.406, DE 5 DE JANEIRO DE 1988, E DA OUTRAS PROVIDENCIAS.</Ementa>" + "</lexml:LexML>");
            ri.setCdStatus("N");
            ri.setCdValidacao("I");
            this.registroItemDao.saveOrUpdate(ri);
            if (k > 1999) {
                this.registroItemDao.commit();
                this.registroItemDao.beginTransaction();
                k = 0;
            }
            ++i;
        }
        this.registroItemDao.commit();
    }

    private void deletar(String p_arquivo, int p_tam) {
        if (!this.delete_imported_files) {
            return;
        }
        if (p_arquivo != null) {
            this.arquivos.add(p_arquivo);
        }
        if (this.arquivos.size() >= p_tam || p_arquivo == null) {
            System.out.println("Apagando " + this.arquivos.size() + " arquivo(s)");
            int i = 0;
            while (i < this.arquivos.size()) {
                String nome_arquivo = this.arquivos.get(i);
                logger.info("Apagando o arquivo " + i + " " + nome_arquivo);
                File arquivo = new File(nome_arquivo);
                if (!arquivo.delete()) {
                    logger.error("Falha na dele\u00e7\u00e3o.");
                }
                ++i;
            }
            this.arquivos = new ArrayList<String>();
        }
    }

    private void processarDiretorio(String p_dir, boolean full) throws IOException {
        File dir2 = new File(p_dir);
        if (dir2.isDirectory()) {
            String[] children = dir2.list();
            if (children == null) {
                logger.info("Diret\u00f3rio n\u00e3o pode ser acessado ou est\u00e1 vazio");
            } else {
                ArrayList<String> fileNames = new ArrayList<String>(Arrays.asList(children));
                Collections.sort(fileNames);
                for (String fileName : fileNames) {
                    if (fileName.endsWith(".xml")) {
                        this.processarArquivo(p_dir, fileName, full);
                        continue;
                    }
                    this.processarDiretorio(String.valueOf(p_dir) + File.separator + fileName, full);
                }
            }
        }
    }

    public void consumirPasta(String p_dir, boolean p_delete_imported_files, boolean full) throws IOException {
        this.registroItemDao.beginTransaction();
        this.toSave.clear();
        this.sucessos = 0;
        this.falhas = 0;
        this.delete_imported_files = p_delete_imported_files;
        logger.debug("Iniciando o processamento do diret\u00f3rio " + p_dir);
        if (this.delete_imported_files) {
            logger.info("Os arquivos importados com sucesso ser\u00e3o apagados ao final do processamento");
        }
        this.processarDiretorio(p_dir, full);
        this.checkListsSizes(0);
        this.registroItemDao.commit();
        this.toSave.clear();
        this.deletar(null, 0);
        logger.info("---------------------------------------");
        logger.info("Foram importados " + this.sucessos + " registros com sucesso.");
        logger.info("Foram importados " + this.falhas + " registros com falha.");
    }

    public void exportarParaPasta(String p_dir) throws Exception {
        File dir2 = new File(p_dir);
        String INICIO_XML = "<?xml";
        if (!dir2.isDirectory()) {
            System.out.println("Pasta n\u00e3o encontrada.");
            logger.error("Diret\u00f3rio informado n\u00e3o foi encontrado");
        } else {
            Date dtInicio = null;
            Date dtFim = new Date();
            int contagem = this.registroItemDao.countListByTimeWindowAndSet(dtInicio, dtFim, null);
            logger.info("Preparando para exportar " + contagem + " registros na pasta:" + p_dir);
            int c = 0;
            String lastId = null;
            List<RegistroItem> listagem = this.registroItemDao.listByTimeWindowAndSet(dtInicio, dtFim, null, lastId, 300);
            while (!listagem.isEmpty()) {
                for (RegistroItem registro : listagem) {
                    String xml = registro.getTxMetadadoXml();
                    String pi = xml.substring(0, 5);
                    String newFile = URLEncoder.encode(registro.getIdRegistroItem(), "UTF-8").concat(".xml");
                    String arquivo = String.valueOf(p_dir) + File.separator + newFile;
                    logger.info("gravando registro #" + ++c + " para o arquivo: " + arquivo);
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo), "UTF-8");
                    if (!"<?xml".equals(pi)) {
                        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    }
                    try {
                        out.write(xml);
                    }
                    catch (Exception e) {
                        logger.error("Falha ao gravar arquivo.", e);
                    }
                    out.close();
                }
                lastId = listagem.get(listagem.size() - 1).getIdRegistroItem();
                listagem = this.registroItemDao.listByTimeWindowAndSet(dtInicio, dtFim, null, lastId, 300);
            }
            logger.info("Finalizada a exporta\u00e7\u00e3o");
        }
    }

    public void exportarSQLParaPasta(String p_dir) throws Exception {
        File dir2 = new File(p_dir);
        String SQL_PADRAO = "insert into registro_item(id_registro_item, ts_registro_gmt, cd_status, cd_validacao, tx_metadado_xml, id_conjunto_item) values (''{0}'', current_timestamp, ''{1}'', ''O'', ''{2}'', {3});\n";
        if (!dir2.isDirectory()) {
            System.out.println("Pasta n\u00e3o encontrada.");
            logger.error("Diret\u00f3rio informado n\u00e3o foi encontrado");
        } else {
            Date dtInicio = null;
            Date dtFim = new Date();
            int contagem = this.registroItemDao.countListByTimeWindowAndSet(dtInicio, dtFim, null);
            if (contagem <= 0) {
                logger.info("Nenhum registro a exportar.");
            } else {
                logger.info("Preparando para exportar " + contagem + " registros na pasta:" + p_dir);
                int c = 0;
                String lastId = null;
                List<RegistroItem> listagem = this.registroItemDao.listByTimeWindowAndSet(dtInicio, dtFim, null, lastId, 300);
                String arquivo = String.valueOf(p_dir) + File.separator + "lexml_registro_item_dump.sql";
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo, false), "UTF-8");
                while (!listagem.isEmpty()) {
                    for (RegistroItem registro : listagem) {
                        String xml = registro.getTxMetadadoXml();
                        xml = xml == null ? "" : xml.replace("'", "''");
                        String idConjuntoItem = registro.getConjuntoItem() == null || registro.getConjuntoItem().getIdConjuntoItem() == null ? "NULL" : registro.getConjuntoItem().getIdConjuntoItem();
                        String novaLinha = MessageFormat.format("insert into registro_item(id_registro_item, ts_registro_gmt, cd_status, cd_validacao, tx_metadado_xml, id_conjunto_item) values (''{0}'', current_timestamp, ''{1}'', ''O'', ''{2}'', {3});\n", registro.getIdRegistroItem(), registro.getCdStatus(), xml, idConjuntoItem);
                        logger.info("gravando registro #" + ++c + " em nova linha");
                        try {
                            out.write(novaLinha);
                        }
                        catch (Exception e) {
                            logger.error("Falha ao gravar arquivo.", e);
                        }
                    }
                    lastId = listagem.get(listagem.size() - 1).getIdRegistroItem();
                    listagem = this.registroItemDao.listByTimeWindowAndSet(dtInicio, dtFim, null, lastId, 300);
                }
                out.close();
            }
            logger.info("Finalizada a exporta\u00e7\u00e3o");
        }
    }

    public int getSucessos() {
        return this.sucessos;
    }

    public void setSucessos(int sucessos) {
        this.sucessos = sucessos;
    }

    public int getFalhas() {
        return this.falhas;
    }

    public void setFalhas(int falhas) {
        this.falhas = falhas;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream fis = new FileInputStream("/tmp/p17/oai%3Aacordao.stf.jus.br%3Aaco%2F140851.xml");
        String conteudo = IOUtils.toString(fis);
        fis.close();
        int i = 0;
        while (i < conteudo.length()) {
            char c = conteudo.charAt(i);
            if (!Character.isDefined(c)) {
                System.out.println("\nCaractere inv\u00e1lido: " + conteudo.charAt(i));
            } else {
                System.out.println(String.valueOf(c) + "\t" + c + "\t0x" + Integer.toHexString(c) + "\t" + Character.getType(c));
            }
            ++i;
        }
        System.out.println("Fim.");
    }
}

