/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.dao.AbstractDAO;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.util.hibernate.SimpleHqlBuilder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistroItemDAO
extends AbstractDAO {
    private static final Logger logger = Logger.getLogger(RegistroItemDAO.class.getName());

    public List<RegistroItem> listByTimeWindowAndSet(Date from, Date until, String idConjunto, String lastId, int max) {
        SimpleHqlBuilder builder = new SimpleHqlBuilder("select ri from RegistroItem ri");
        this.whereListByTimeWindowAndSet(builder, from, until, idConjunto, lastId);
        builder.orderBy("ri.idRegistroItem");
        Query query = this.createQuery(builder);
        if (max > 0) {
            query.setMaxResults(max);
        }
        return query.getResultList();
    }

    public int countListByTimeWindowAndSet(Date from, Date until, String idConjunto) {
        SimpleHqlBuilder builder = new SimpleHqlBuilder("select count(ri) from RegistroItem ri");
        this.whereListByTimeWindowAndSet(builder, from, until, idConjunto, null);
        Query query = this.createQuery(builder);
        Number row = (Number)query.getSingleResult();
        if (row != null) {
            return row.intValue();
        }
        return 0;
    }

    private void whereListByTimeWindowAndSet(SimpleHqlBuilder builder, Date from, Date until, String idConjunto, String lastId) {
        builder.and("ri.cdValidacao = ?", "O");
        if (from != null) {
            builder.and("ri.tsRegistroGmt >= ?", new Timestamp(from.getTime()));
        }
        if (until != null) {
            builder.and("ri.tsRegistroGmt <= ?", new Timestamp(AbstractDAO.fimDoDia(until).getTime()));
        }
        if (idConjunto != null) {
            builder.and("ri.conjuntoItem.idConjuntoItem = ?", idConjunto);
        }
        if (lastId != null) {
            builder.and("ri.idRegistroItem > ?", lastId);
        }
    }

    public List<RegistroItem> listNotValid(String ultimoIdProcessado, int tamMaxBloco) {
        EntityManager em = this.getEntityManager();
        SimpleHqlBuilder builder = new SimpleHqlBuilder("select ri from RegistroItem ri");
        builder.and("ri.cdValidacao in (?,?)", "I", "E");
        if (ultimoIdProcessado != null) {
            builder.and("ri.id > ?", ultimoIdProcessado);
        }
        builder.orderBy("ri.id");
        Query q = this.createQuery(builder);
        q.setMaxResults(tamMaxBloco);
        return q.getResultList();
    }

    public long countNotValid() {
        EntityManager em = this.getEntityManager();
        Query q = em.createQuery("SELECT count(ri) FROM RegistroItem ri WHERE ri.cdValidacao in (?,?)");
        q.setParameter(1, (Object)"I");
        q.setParameter(2, (Object)"E");
        return (Long)q.getSingleResult();
    }

    public List<ConjuntoItem> listAllSets() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ci FROM ConjuntoItem ci");
        return query.getResultList();
    }

    public RegistroItem load(String identifier) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.idRegistroItem =:rid ");
        query.setParameter("rid", (Object)identifier);
        try {
            return (RegistroItem)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void saveList(List<?> p_list) {
        Iterator<?> iter = p_list.iterator();
        while (iter.hasNext()) {
            this.save(iter.next());
        }
    }

    public void save(Object p_obj) {
        this.timeStamp(p_obj);
        this.saveObject(p_obj);
    }

    public void saveOrUpdate(RegistroItem p_ri) {
        if (this.existeRegistroItem(p_ri.getIdRegistroItem())) {
            this.update(p_ri);
        } else {
            this.save(p_ri);
        }
    }

    public void timeStamp(Object p_obj) {
        Timestamp now = new Timestamp(LexMLUtil.nowInMillisGMT());
        if (RegistroItem.class.isInstance(p_obj)) {
            ((RegistroItem)p_obj).setTsRegistroGmt(now);
        } else if (RegistroItemErro.class.isInstance(p_obj)) {
            ((RegistroItemErro)p_obj).setTsProcessamento(now);
        }
    }

    public void updateList(List<?> p_list) {
        Iterator<?> iter = p_list.iterator();
        while (iter.hasNext()) {
            this.update(iter.next());
        }
    }

    public void update(Object p_obj) {
        this.timeStamp(p_obj);
        this.updateObject(p_obj);
    }

    public List<RegistroItem> listAll(int offset, int limit) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri ");
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    public int countAll() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri ");
        return query.getResultList().size();
    }

    public void deleteRegistroItemErro(RegistroItem registroItem) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("delete from RegistroItemErro where registroItem.id = ?");
        query.setParameter(1, (Object)registroItem.getIdRegistroItem());
        query.executeUpdate();
    }

    public List<RegistroItem> listErrorsByTimeWindowAndSet(Date from, Date until, String idConjunto, String lastId, int max) {
        SimpleHqlBuilder builder = new SimpleHqlBuilder("select ri from RegistroItem ri");
        this.whereListErrorsByTimeWindowAndSet(builder, from, until, idConjunto, lastId);
        builder.orderBy("ri.idRegistroItem");
        Query query = this.createQuery(builder);
        if (max > 0) {
            query.setMaxResults(max);
        }
        return query.getResultList();
    }

    public int countListErrorsByTimeWindowAndSet(Date from, Date until, String idConjunto) {
        SimpleHqlBuilder builder = new SimpleHqlBuilder("select count(ri) from RegistroItem ri");
        this.whereListErrorsByTimeWindowAndSet(builder, from, until, idConjunto, null);
        Query query = this.createQuery(builder);
        Number row = (Number)query.getSingleResult();
        if (row != null) {
            return row.intValue();
        }
        return 0;
    }

    private void whereListErrorsByTimeWindowAndSet(SimpleHqlBuilder builder, Date from, Date until, String idConjunto, String lastId) {
        builder.and("ri.cdValidacao <> ?", "O");
        if (from != null) {
            builder.and("ri.tsRegistroGmt >= ?", new Timestamp(from.getTime()));
        }
        if (until != null) {
            builder.and("ri.tsRegistroGmt <= ?", new Timestamp(AbstractDAO.fimDoDia(until).getTime()));
        }
        if (idConjunto != null) {
            builder.and("ri.conjuntoItem.idConjuntoItem = ?", idConjunto);
        }
        if (lastId != null) {
            builder.and("ri.idRegistroItem > ?", lastId);
        }
    }

    public Date getTsRegistroGmt(String id) {
        EntityManager em = this.getEntityManager();
        Query q = em.createQuery("SELECT ri.tsRegistroGmt FROM RegistroItem ri WHERE ri.idRegistroItem = :id");
        q.setParameter("id", (Object)id);
        List list = q.getResultList();
        if (list.isEmpty()) {
            return null;
        }
        return (Date)list.get(0);
    }

    public boolean existeRegistroItem(String id) {
        EntityManager em = this.getEntityManager();
        Query q = em.createQuery("SELECT count(ri) FROM RegistroItem ri WHERE ri.idRegistroItem = :id");
        q.setParameter("id", (Object)id);
        return (Long)q.getSingleResult() > 0L;
    }

    public void updateCdValidacao(List<RegistroItem> list) {
        EntityManager em = this.getEntityManager();
        for (RegistroItem ri : list) {
            Query q = em.createNativeQuery("update registro_item set cd_validacao = ? where id_registro_item = ?");
            q.setParameter(1, (Object)ri.getCdValidacao());
            q.setParameter(2, (Object)ri.getIdRegistroItem());
        }
    }
}

