/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.coleta.validador;

import br.gov.lexml.coleta.validador.TipoErroValidacao;
import br.gov.lexml.coleta.validador.ValidadorService;
import br.gov.lexml.coleta.validador.ValidadorXMLHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidadorRegistroItem {
    private static final Logger log = LoggerFactory.getLogger(ValidadorRegistroItem.class);
    private static final String SEP = ":";
    private static final String TIPO_PERFIL_DOCUMENTO_INDIVIDUAL = "D";
    private static final String TIPO_PERFIL_RELACIONAMENTO = "R";
    private ValidadorService svc;
    private final ValidadorXMLHelper xmlHelper = new ValidadorXMLHelper();

    public void setValidadorService(ValidadorService validadorService) {
        this.svc = validadorService;
    }

    public boolean validar(String idRegistroItem, String xml, Object ctxUsr) {
        if (this.svc == null) {
            throw new RuntimeException("ValidatorService n\u00e3o informado.");
        }
        if (StringUtils.isEmpty(idRegistroItem)) {
            log.error("RV#4 Objeto RegistroItem ri passado \u00e9 nulo");
            return false;
        }
        if (idRegistroItem.indexOf(32) != -1) {
            this.svc.logError(idRegistroItem, TipoErroValidacao.ERRO_GENERICO, "RV#1 ID_REGISTRO_ITEM n\u00e3o pode conter espa\u00e7os em branco", ctxUsr);
            return false;
        }
        if (StringUtils.isEmpty(xml)) {
            this.svc.logError(idRegistroItem, TipoErroValidacao.XML_MAL_FORMADO, "RV#2 XML nulo foi passado para valida\u00e7\u00e3o", ctxUsr);
            return false;
        }
        Document doc = this.parseDocument(idRegistroItem, xml, ctxUsr);
        if (doc == null) {
            return false;
        }
        return this.validaDocumento(idRegistroItem, doc, ctxUsr);
    }

    private Document parseDocument(String idRegistroItem, String xml, Object ctxUsr) {
        Document doc = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            doc = this.xmlHelper.parse(is);
            ((InputStream)is).close();
            String parseErrors = this.xmlHelper.getParseErrorsAsString();
            if (parseErrors != null) {
                this.svc.logError(idRegistroItem, TipoErroValidacao.XML_INVALIDO, "RV#3 Xml n\u00e3o \u00e9 v\u00e1lido segundo o schema: " + parseErrors, ctxUsr);
                doc = null;
            }
        }
        catch (Exception e) {
            this.svc.logError(idRegistroItem, TipoErroValidacao.XML_MAL_FORMADO, "XML mal formado: " + e.getMessage(), ctxUsr);
        }
        return doc;
    }

    private boolean validaDocumento(String idRegistroItem, Document doc, Object ctxUsr) {
        Integer idPublicador;
        Node relacionamento;
        ContextoValidacao ctx = new ContextoValidacao();
        Element root = doc.getDocumentElement();
        String tstURNDocumentoIndividual = this.xmlHelper.getString(root, "lexml:DocumentoIndividual/text()");
        if (!this.isEstruturalmenteValid(ctx, tstURNDocumentoIndividual)) {
            this.svc.logError(idRegistroItem, TipoErroValidacao.URN_INVALIDO, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" \u00e9 estruturalmente inv\u00e1lida", ctxUsr);
            return false;
        }
        ArrayList<Integer> idPublicadoresTestados = new ArrayList<Integer>();
        NodeList itens = this.xmlHelper.getNodeList(root, "lexml:Item");
        int i = 0;
        while (i < itens.getLength()) {
            Node item = itens.item(i);
            Integer idPublicador2 = this.xmlHelper.getAttributeAsInteger(item, "idPublicador");
            if (!idPublicadoresTestados.contains(idPublicador2)) {
                if (!this.isDocumentoIndividualValid(ctx, idPublicador2)) {
                    this.svc.logError(idRegistroItem, TipoErroValidacao.URN_INCOMPATIVEL, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual " + "em rela\u00e7\u00e3o ao perfil para o " + "publicador \"" + idPublicador2 + "\"", ctxUsr);
                    return false;
                }
                idPublicadoresTestados.add(idPublicador2);
            }
            ++i;
        }
        NodeList relacionamentos = this.xmlHelper.getNodeList(root, "lexml:Relacionamento");
        Integer idPublicadorDefault = null;
        if (!idPublicadoresTestados.isEmpty()) {
            idPublicadorDefault = (Integer)idPublicadoresTestados.get(0);
        }
        int i2 = 0;
        while (i2 < relacionamentos.getLength()) {
            relacionamento = relacionamentos.item(i2);
            idPublicador = this.getIdPublicadorRelacionamento(relacionamento, idPublicadorDefault);
            if (!idPublicadoresTestados.contains(idPublicador)) {
                if (!this.isDocumentoIndividualValid(ctx, idPublicador)) {
                    this.svc.logError(idRegistroItem, TipoErroValidacao.URN_INCOMPATIVEL, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual " + "em rela\u00e7\u00e3o ao perfil para o relacionamento do publicador \"" + idPublicador + "\"", ctxUsr);
                    return false;
                }
                idPublicadoresTestados.add(idPublicador);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < relacionamentos.getLength()) {
            relacionamento = relacionamentos.item(i2);
            idPublicador = this.getIdPublicadorRelacionamento(relacionamento, idPublicadorDefault);
            String tstURNRelacionamento = relacionamento.getTextContent().trim();
            if (idPublicador == null) {
                this.svc.logError(idRegistroItem, TipoErroValidacao.URN_INCOMPATIVEL, "RV#8 A URN de Relacionamento \"" + tstURNRelacionamento + "\" n\u00e3o pode ser validada por aus\u00eancia de idPublicador", ctxUsr);
                return false;
            }
            if (!this.isRelacionamentoValid(ctx, tstURNRelacionamento, idPublicador)) {
                this.svc.logError(idRegistroItem, TipoErroValidacao.URN_INCOMPATIVEL, "RV#7 A URN de Relacionamento \"" + tstURNRelacionamento + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual de perfil", ctxUsr);
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isEstruturalmenteValid(ContextoValidacao ctx, String urn) {
        if (!urn.startsWith("urn:lex:")) {
            return false;
        }
        String[] part = urn.substring(8).split(SEP);
        if (part.length < 3) {
            return false;
        }
        ctx.tstNucleoURN = String.valueOf(part[0]) + SEP + part[1] + SEP + part[2];
        if (part[1].contains(";") && part[2].contains(";")) {
            String autoridade = part[1].substring(0, part[1].indexOf(";"));
            String tipo = part[2].substring(0, part[2].indexOf(";"));
            ctx.tstNucleoURNAutoridadeReduzida = String.valueOf(part[0]) + SEP + autoridade + SEP + part[2];
            ctx.tstNucleoURNTipoReduzida = String.valueOf(part[0]) + SEP + part[1] + SEP + tipo;
        }
        return true;
    }

    private boolean isDocumentoIndividualValid(ContextoValidacao ctx, Integer p_idPublicador) {
        if (p_idPublicador == null) {
            return false;
        }
        if (this.isCoreValid(p_idPublicador, ctx.tstNucleoURN, TIPO_PERFIL_DOCUMENTO_INDIVIDUAL)) {
            return true;
        }
        return this.isCoreValid(p_idPublicador, ctx.tstNucleoURNAutoridadeReduzida, TIPO_PERFIL_DOCUMENTO_INDIVIDUAL) && this.isCoreValid(p_idPublicador, ctx.tstNucleoURNTipoReduzida, TIPO_PERFIL_DOCUMENTO_INDIVIDUAL);
    }

    private boolean isRelacionamentoValid(ContextoValidacao ctx, String p_urn, Integer p_idPublicador) {
        if (!this.isEstruturalmenteValid(ctx, p_urn)) {
            return false;
        }
        if (this.isCoreValid(p_idPublicador, ctx.tstNucleoURN, TIPO_PERFIL_RELACIONAMENTO)) {
            return true;
        }
        return this.isCoreValid(p_idPublicador, ctx.tstNucleoURNAutoridadeReduzida, TIPO_PERFIL_RELACIONAMENTO) && this.isCoreValid(p_idPublicador, ctx.tstNucleoURNTipoReduzida, TIPO_PERFIL_RELACIONAMENTO);
    }

    private boolean isCoreValid(Integer p_idPublicador, String nucleoURN, String p_tipoCore) {
        if (nucleoURN == null) {
            return false;
        }
        return this.svc.isNucleoValido(p_idPublicador + SEP + p_tipoCore + SEP + nucleoURN);
    }

    private Integer getIdPublicadorRelacionamento(Node relacionamento, Integer idDefault) {
        Integer idPublicador = this.xmlHelper.getAttributeAsInteger(relacionamento, "idPublicador");
        return idPublicador == null ? idDefault : idPublicador;
    }

    private static class ContextoValidacao {
        String tstNucleoURN;
        String tstNucleoURNAutoridadeReduzida;
        String tstNucleoURNTipoReduzida;

        private ContextoValidacao() {
        }
    }
}

