/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsCore;
import net.sourceforge.jtds.jdbc.TextPtr;

public class JtdsInputStream
extends InputStream {
    private TdsCore tds;
    private int length;
    private int offset = 0;
    private String colName;
    private String tabName;
    private TextPtr textPtr;
    private static final int BUFSIZE = 4096;
    private byte[] buffer = null;
    private int pos = 0;
    private String charset;

    JtdsInputStream(ConnectionJDBC2 con, ColInfo ci, TextPtr textPtr, String charset) throws SQLException {
        this.tds = new TdsCore(con, new SQLDiagnostic(con.getServerType()));
        this.colName = ci.realName;
        this.tabName = ci.tableName;
        this.textPtr = textPtr;
        this.charset = charset;
        this.length = this.tds.dataLength(this.tabName, this.colName);
        if (ci.sqlType.equalsIgnoreCase("ntext")) {
            this.length /= 2;
        }
        this.fillBuffer();
    }

    public int available() throws IOException {
        return this.length - this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void reset() throws IOException {
        this.offset = 0;
        this.pos = 0;
        this.buffer = null;
        try {
            this.fillBuffer();
        }
        catch (SQLException e) {
            throw new IOException("SQL Error: " + e.getMessage());
        }
    }

    void fillBuffer() throws SQLException {
        int bc = 4096;
        this.pos = 0;
        if (this.offset + bc > this.length && (bc = this.length - this.offset) == 0) {
            this.buffer = new byte[0];
            return;
        }
        Object result = this.tds.readText(this.tabName, this.colName, this.textPtr, this.offset, bc);
        if (result instanceof byte[]) {
            this.buffer = (byte[])result;
            this.offset += this.buffer.length;
        } else if (result instanceof char[]) {
            char[] tmp = (char[])result;
            if (this.charset.equals("UTF-16BE")) {
                this.buffer = new byte[tmp.length * 2];
                int ptr = 0;
                int i = 0;
                while (i < tmp.length) {
                    this.buffer[ptr++] = (byte)(tmp[i] >> 8);
                    this.buffer[ptr++] = (byte)tmp[i];
                    ++i;
                }
            } else {
                this.buffer = Support.encodeString(this.charset, new String(tmp));
            }
            this.offset += ((char[])result).length;
        }
    }

    public int read() throws IOException {
        if (this.pos == this.buffer.length) {
            if (this.tds == null) {
                throw new IOException("InputStream is closed");
            }
            try {
                this.fillBuffer();
            }
            catch (SQLException e) {
                throw new IOException("SQL Error: " + e.getMessage());
            }
            if (this.buffer.length == 0) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            try {
                this.tds.close();
            }
            catch (SQLException e) {
                Object var3_2 = null;
                this.tds = null;
                this.buffer = new byte[0];
                return;
            }
            Object var3_1 = null;
            this.tds = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.tds = null;
            this.buffer = new byte[0];
            throw throwable;
        }
        this.buffer = new byte[0];
    }
}

