/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.JtdsCallableStatement;
import net.sourceforge.jtds.jdbc.JtdsDatabaseMetaData;
import net.sourceforge.jtds.jdbc.JtdsPreparedStatement;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.MSSqlServerInfo;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.SQLParser;
import net.sourceforge.jtds.jdbc.SharedNamedPipe;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsCore;
import net.sourceforge.jtds.jdbc.TdsData;
import net.sourceforge.jtds.util.Logger;

public class ConnectionJDBC2
implements Connection {
    private String url;
    private String serverName;
    private int portNumber;
    private int serverType;
    private String instanceName;
    private String databaseName;
    private String currentDatabase;
    private String domainName;
    private String user;
    private String password;
    private String serverCharset;
    private String appName;
    private String progName;
    private String language;
    private String macAddress;
    private int tdsVersion;
    private SharedSocket socket;
    private TdsCore baseTds;
    private int netPacketSize = 512;
    private int packetSize;
    private byte[] collation;
    private boolean charsetSpecified = false;
    private String databaseProductName;
    private String databaseProductVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private boolean closed = false;
    private boolean readOnly = false;
    private ArrayList statements;
    private int transactionIsolation = 2;
    private boolean autoCommit = true;
    private SQLDiagnostic messages;
    private int rowCount = 0;
    private int maxPrecision = 38;
    private int spSequenceNo = 1;
    private HashMap procedures = new HashMap();
    private ArrayList procInTran = new ArrayList();
    private static Properties charsets = new Properties();
    private boolean wideChars = false;
    private String javaCharset;
    private int prepareSql;
    private long lobBuffer;
    private boolean useUnicode = true;
    private boolean namedPipe = false;
    private boolean lastUpdateCount = false;
    private int loginTimeout = 0;
    private int sybaseInfo = 0;

    private ConnectionJDBC2() {
    }

    ConnectionJDBC2(String url, Properties info) throws SQLException {
        this.statements = new ArrayList();
        this.url = url;
        this.unpackProperties(info);
        this.messages = new SQLDiagnostic(this.serverType);
        if (this.instanceName.length() > 0 && !this.namedPipe) {
            MSSqlServerInfo msInfo = new MSSqlServerInfo(this.serverName);
            this.portNumber = msInfo.getPortForInstance(this.instanceName);
            if (this.portNumber == -1) {
                throw new SQLException(Messages.get("error.msinfo.badinst", this.serverName, this.instanceName), "08003");
            }
        }
        SharedSocket.setMemoryBudget(100000);
        SharedSocket.setMinMemPkts(8);
        try {
            this.socket = this.namedPipe ? SharedNamedPipe.instance(this.serverName, this.tdsVersion, this.serverType, this.packetSize, this.instanceName, this.domainName, this.user, this.password) : new SharedSocket(this.serverName, this.portNumber, this.tdsVersion, this.serverType);
            this.loadCharset(this.serverCharset);
            this.baseTds = new TdsCore(this, this.messages);
            LoginTimer timer = null;
            if (this.loginTimeout > 0) {
                timer = new LoginTimer(this.socket, this.loginTimeout);
                timer.start();
            }
            this.baseTds.login(this.serverName, this.databaseName, this.user, this.password, this.domainName, this.serverCharset, this.appName, this.progName, this.language, this.macAddress, this.packetSize);
            if (timer != null) {
                timer.stopTimer();
            }
            this.tdsVersion = this.baseTds.getTdsVersion();
            if (this.tdsVersion < 3 && this.databaseName.length() > 0) {
                this.setCatalog(this.databaseName);
            }
        }
        catch (UnknownHostException e) {
            throw Support.linkException(new SQLException(Messages.get("error.connection.badhost", e.getMessage()), "08S03"), e);
        }
        catch (IOException e) {
            throw Support.linkException(new SQLException(Messages.get("error.connection.ioerror", e.getMessage()), "08S01"), e);
        }
        catch (SQLException e) {
            if (this.loginTimeout > 0 && e.getMessage().indexOf("socket closed") >= 0) {
                throw new SQLException(Messages.get("error.connection.timeout"), "08S01");
            }
            throw e;
        }
        if (this.serverType == 1) {
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT @@MAX_PRECISION");
            if (rs.next()) {
                this.maxPrecision = rs.getByte(1);
            }
            rs.close();
            stmt.close();
        }
        String sql = this.serverType == 2 ? "SET QUOTED_IDENTIFIER ON SET TEXTSIZE 2147483647 " : "SET QUOTED_IDENTIFIER ON SET TEXTSIZE 2147483647 ";
        this.baseTds.submitSQL(sql);
        this.setAutoCommit(true);
        this.setTransactionIsolation(this.transactionIsolation);
    }

    protected void loadCharset(String charset) {
        Properties properties = charsets;
        synchronized (properties) {
            if (((Hashtable)charsets).size() == 0) {
                try {
                    InputStream stream;
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    if ((stream = classLoader.getResourceAsStream("net/sourceforge/jtds/jdbc/Charsets.properties")) != null) {
                        charsets.load(stream);
                    } else {
                        Logger.println("Can't load charset.properties");
                    }
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
        }
        String tmp = charsets.getProperty(charset.toUpperCase(), "1|ISO-8859-1");
        this.wideChars = !tmp.substring(0, 1).equals("1");
        this.javaCharset = tmp.substring(2);
        try {
            "This is a test".getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            this.javaCharset = "ISO-8859-1";
            this.wideChars = false;
        }
        this.socket.setCharset(this.javaCharset);
        this.socket.setWideChars(this.wideChars);
    }

    SharedSocket getSocket() {
        return this.socket;
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    String getProcName() {
        String seq = "000000" + Integer.toHexString(this.spSequenceNo++).toUpperCase();
        return "#jtds" + seq.substring(seq.length() - 6, seq.length());
    }

    ProcEntry getCachedProcedure(String key) {
        return (ProcEntry)this.procedures.get(key);
    }

    synchronized String prepareSQL(JtdsPreparedStatement pstmt, String sql, ParamInfo[] params, boolean returnKeys) throws SQLException {
        if (this.prepareSql == 0 || this.prepareSql == 2) {
            return null;
        }
        if (this.serverType == 2) {
            if (this.tdsVersion != 2) {
                return null;
            }
            if (returnKeys) {
                return null;
            }
        }
        int i = 0;
        while (i < params.length) {
            if (!params[i].isSet) {
                throw new SQLException(Messages.get("error.prepare.paramnotset", Integer.toString(i + 1)), "07000");
            }
            TdsData.getNativeType(this, params[i]);
            if (this.serverType == 2 && (params[i].sqlType.equals("text") || params[i].sqlType.equals("image"))) {
                return null;
            }
            ++i;
        }
        StringBuffer key = new StringBuffer(sql.length() + 64);
        key.append(this.getCatalog());
        key.append(sql);
        int i2 = 0;
        while (i2 < params.length && this.serverType != 2) {
            key.append(params[i2].sqlType);
            ++i2;
        }
        ProcEntry proc = this.getCachedProcedure(key.toString());
        if (proc != null) {
            if (this.serverType == 2) {
                pstmt.setColMetaData(proc.colMetaData);
                pstmt.setParamMetaData(proc.paramMetaData);
            }
            return proc.name;
        }
        proc = new ProcEntry();
        if (this.serverType == 1) {
            proc.name = this.baseTds.microsoftPrepare(sql, params, pstmt.getResultSetType(), pstmt.getResultSetConcurrency());
            if (proc.name == null) {
                return null;
            }
        } else {
            proc.name = this.baseTds.sybasePrepare(sql, params);
            if (proc.name == null) {
                return null;
            }
            ProcEntry.access$002(proc, this.baseTds.getColumns());
            ProcEntry.access$102(proc, this.baseTds.getParameters());
            pstmt.setColMetaData(proc.colMetaData);
            pstmt.setParamMetaData(proc.paramMetaData);
        }
        this.addCachedProcedure(key.toString(), proc);
        return proc.name;
    }

    void addCachedProcedure(String key, ProcEntry proc) {
        this.procedures.put(key, proc);
        if (!this.autoCommit) {
            this.procInTran.add(key);
        }
    }

    void removeCachedProcedure(String key) {
        this.procedures.remove(key);
        if (!this.autoCommit) {
            ((AbstractCollection)this.procInTran).remove(key);
        }
    }

    int getServerType() {
        return this.serverType;
    }

    void setNetPacketSize(int size) {
        this.netPacketSize = size;
    }

    int getNetPacketSize() {
        return this.netPacketSize;
    }

    int getRowCount() {
        return this.rowCount;
    }

    void setRowCount(int count) {
        this.rowCount = count;
    }

    boolean isLastUpdateCount() {
        return this.lastUpdateCount;
    }

    int getMaxPrecision() {
        return this.maxPrecision;
    }

    long getLobBuffer() {
        return this.lobBuffer;
    }

    int getPrepareSql() {
        return this.prepareSql;
    }

    protected void unpackProperties(Properties info) throws SQLException {
        Integer parsedTdsVersion;
        this.serverName = info.getProperty(Messages.get("prop.servername"));
        this.portNumber = this.parseIntegerProperty(info, "prop.portnumber");
        this.serverType = this.parseIntegerProperty(info, "prop.servertype");
        this.databaseName = info.getProperty(Messages.get("prop.databasename"));
        this.instanceName = info.getProperty(Messages.get("prop.instance"), "");
        this.domainName = info.getProperty(Messages.get("prop.domain"), "");
        this.user = info.getProperty(Messages.get("prop.user"));
        this.password = info.getProperty(Messages.get("prop.password"));
        this.macAddress = info.getProperty(Messages.get("prop.macaddress"));
        this.appName = info.getProperty(Messages.get("prop.appname"));
        this.progName = info.getProperty(Messages.get("prop.progname"));
        this.serverCharset = info.getProperty(Messages.get("prop.charset"));
        this.language = info.getProperty(Messages.get("prop.language"), "us_english");
        this.prepareSql = this.parseIntegerProperty(info, "prop.preparesql");
        this.lastUpdateCount = info.getProperty(Messages.get("prop.lastupdatecount")).equalsIgnoreCase("true");
        this.useUnicode = info.getProperty(Messages.get("prop.useunicode")).equalsIgnoreCase("true");
        this.namedPipe = info.getProperty(Messages.get("prop.namedpipe")).equalsIgnoreCase("true");
        boolean bl = this.charsetSpecified = this.serverCharset != null && this.serverCharset.length() > 0;
        if (!this.charsetSpecified) {
            this.serverCharset = "iso_1";
        }
        if ((parsedTdsVersion = DefaultProperties.getTdsVersion(info.getProperty(Messages.get("prop.tds")))) == null) {
            throw new SQLException(Messages.get("error.connection.badprop", Messages.get("prop.tds")), "08001");
        }
        this.tdsVersion = parsedTdsVersion;
        this.packetSize = this.parseIntegerProperty(info, "prop.packetsize");
        if (this.packetSize < 512) {
            this.packetSize = this.tdsVersion >= 3 ? (this.packetSize == 0 ? 0 : 4096) : 512;
        }
        if (this.packetSize > 32768) {
            this.packetSize = 32768;
        }
        this.packetSize = this.packetSize / 512 * 512;
        this.loginTimeout = this.parseIntegerProperty(info, "prop.logintimeout");
        this.lobBuffer = this.parseLongProperty(info, "prop.lobbuffer");
        if (this.tdsVersion < 4 && this.prepareSql == 4) {
            this.prepareSql = 3;
        }
        if (this.tdsVersion < 3 && this.prepareSql == 3) {
            this.prepareSql = 2;
        }
    }

    private int parseIntegerProperty(Properties info, String key) throws SQLException {
        String propertyName = Messages.get(key);
        try {
            return Integer.parseInt(info.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            throw new SQLException(Messages.get("error.connection.badprop", propertyName), "08001");
        }
    }

    private long parseLongProperty(Properties info, String key) throws SQLException {
        String propertyName = Messages.get(key);
        try {
            return Long.parseLong(info.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            throw new SQLException(Messages.get("error.connection.badprop", propertyName), "08001");
        }
    }

    protected String getCharSet() {
        return this.javaCharset;
    }

    protected boolean isWideChar() {
        return this.wideChars;
    }

    protected boolean isUseUnicode() {
        return this.useUnicode;
    }

    protected boolean getSybaseInfo(int flag) {
        return (this.sybaseInfo & flag) != 0;
    }

    protected void setSybaseInfo(int mask) {
        this.sybaseInfo = mask;
    }

    protected void setCharset(String charset) {
        if (this.charsetSpecified) {
            Logger.println("Server charset " + charset + ". Ignoring as driver requested " + this.serverCharset);
            return;
        }
        charset = charset != null && charset.length() == 0 ? null : charset;
        boolean bl = this.charsetSpecified = charset != null;
        if (charset == null || charset.length() > 30) {
            charset = "iso_1";
        }
        if (!charset.equals(this.serverCharset)) {
            this.loadCharset(charset);
        }
        if (Logger.isActive()) {
            Logger.println("Set charset to " + this.serverCharset + '/' + this.javaCharset);
        }
    }

    protected void setDatabase(String newDb, String oldDb) throws SQLException {
        if (this.currentDatabase != null && !oldDb.equalsIgnoreCase(this.currentDatabase)) {
            throw new SQLException(Messages.get("error.connection.dbmismatch", oldDb, this.databaseName), "HY096");
        }
        this.currentDatabase = newDb;
        if (Logger.isActive()) {
            Logger.println("Changed database from " + oldDb + " to " + newDb);
        }
    }

    protected void setDBServerInfo(String databaseProductName, int databaseMajorVersion, int databaseMinorVersion, int buildNumber) {
        this.databaseProductName = databaseProductName;
        this.databaseMajorVersion = databaseMajorVersion;
        this.databaseMinorVersion = databaseMinorVersion;
        if (this.tdsVersion >= 3) {
            StringBuffer buf = new StringBuffer(10);
            if (databaseMajorVersion < 10) {
                buf.append('0');
            }
            buf.append(databaseMajorVersion).append('.');
            if (databaseMinorVersion < 10) {
                buf.append('0');
            }
            buf.append(databaseMinorVersion).append('.');
            buf.append(buildNumber);
            while (buf.length() < 10) {
                buf.insert(6, '0');
            }
            this.databaseProductVersion = buf.toString();
        } else {
            this.databaseProductVersion = databaseMajorVersion + "." + databaseMinorVersion;
        }
    }

    void setCollation(byte[] collation) {
        this.collation = collation;
    }

    byte[] getCollation() {
        return this.collation;
    }

    void removeStatement(JtdsStatement statement) {
        ArrayList arrayList = this.statements;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.statements.size()) {
                Statement stmt;
                WeakReference wr = (WeakReference)this.statements.get(i);
                if (wr != null && (stmt = (Statement)wr.get()) != null && stmt == statement) {
                    this.statements.set(i, null);
                }
                ++i;
            }
        }
    }

    void addStatement(JtdsStatement statement) {
        ArrayList arrayList = this.statements;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.statements.size()) {
                WeakReference wr = (WeakReference)this.statements.get(i);
                if (wr != null) {
                    Statement stmt = (Statement)wr.get();
                    if (stmt == null) {
                        this.statements.set(i, new WeakReference<JtdsStatement>(statement));
                        return;
                    }
                } else {
                    this.statements.set(i, new WeakReference<JtdsStatement>(statement));
                    return;
                }
                ++i;
            }
            this.statements.add(new WeakReference<JtdsStatement>(statement));
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(Messages.get("error.generic.closed", "Connection"), "HY010");
        }
    }

    void notImplemented(String method) throws SQLException {
        throw new SQLException(Messages.get("error.generic.notimp", method), "HYC00");
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    String getDatabaseProductName() {
        return this.databaseProductName;
    }

    String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    String getUrl() {
        return this.url;
    }

    void setClosed() {
        this.closed = true;
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.transactionIsolation;
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.messages.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            try {
                try {
                    ArrayList tmpList;
                    ArrayList arrayList = this.statements;
                    synchronized (arrayList) {
                        tmpList = new ArrayList(this.statements);
                    }
                    int i = 0;
                    while (i < tmpList.size()) {
                        Statement stmt;
                        WeakReference wr = (WeakReference)tmpList.get(i);
                        if (wr != null && (stmt = (Statement)wr.get()) != null) {
                            stmt.close();
                        }
                        ++i;
                    }
                    this.baseTds.closeConnection();
                    this.baseTds.close();
                    this.socket.close();
                }
                catch (IOException e) {
                    Object var7_9 = null;
                    this.closed = true;
                }
                Object var7_8 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closed = true;
                throw throwable;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkOpen();
        this.baseTds.submitSQL("IF @@TRANCOUNT > 0 COMMIT TRAN");
        this.procInTran.clear();
        this.clearSavepoints();
    }

    public synchronized void rollback() throws SQLException {
        this.checkOpen();
        this.baseTds.submitSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN");
        HashMap hashMap = this.procedures;
        synchronized (hashMap) {
            int i = 0;
            while (i < this.procInTran.size()) {
                String key = (String)this.procInTran.get(i);
                if (key != null && this.tdsVersion != 2) {
                    this.procedures.remove(key);
                }
                ++i;
            }
            this.procInTran.clear();
        }
        this.clearSavepoints();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        switch (holdability) {
            case 1: {
                break;
            }
            case 2: {
                throw new SQLException(Messages.get("error.generic.optvalue", "CLOSE_CURSORS_AT_COMMIT", "setHoldability"), "HY092");
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(holdability), "setHoldability"), "HY092");
            }
        }
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        String sql = "SET TRANSACTION ISOLATION LEVEL ";
        switch (level) {
            case 2: {
                sql = sql + "READ COMMITTED";
                break;
            }
            case 1: {
                sql = sql + "READ UNCOMMITTED";
                break;
            }
            case 4: {
                sql = sql + "REPEATABLE READ";
                break;
            }
            case 8: {
                sql = sql + "SERIALIZABLE";
                break;
            }
            case 0: {
                throw new SQLException(Messages.get("error.generic.optvalue", "TRANSACTION_NONE", "setTransactionIsolation"), "HY024");
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(level), "setTransactionIsolation"), "HY092");
            }
        }
        this.transactionIsolation = level;
        this.baseTds.submitSQL(sql);
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (this.autoCommit != autoCommit) {
            this.commit();
        }
        String sql = this.serverType == 2 ? (autoCommit ? "SET CHAINED OFF" : "SET CHAINED ON") : (autoCommit ? "SET IMPLICIT_TRANSACTIONS OFF" : "SET IMPLICIT_TRANSACTIONS ON");
        this.baseTds.submitSQL(sql);
        this.autoCommit = autoCommit;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.readOnly = readOnly;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.currentDatabase;
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        if (this.currentDatabase != null && this.currentDatabase.equals(catalog)) {
            return;
        }
        if (catalog.length() > 32 || catalog.length() < 1) {
            throw new SQLException(Messages.get("error.generic.badparam", catalog, "setCatalog"), "3D000");
        }
        String sql = this.tdsVersion >= 3 ? "use [" + catalog + ']' : "use " + catalog;
        this.baseTds.submitSQL(sql);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new JtdsDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.messages.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setSavepoint()");
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.releaseSavepoint(Savepoint)");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.rollback(Savepoint)");
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int type, int concurrency) throws SQLException {
        this.checkOpen();
        JtdsStatement stmt = new JtdsStatement(this, type, concurrency);
        this.addStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.createStatement(type, concurrency);
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return new HashMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setTypeMap(Map)");
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        String[] result = new SQLParser(sql, new ArrayList(), this.serverType).parse(false);
        return result[0];
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareCall(sql, 1003, 1007);
    }

    public CallableStatement prepareCall(String sql, int type, int concurrency) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        JtdsCallableStatement stmt = new JtdsCallableStatement(this, sql, type, concurrency);
        this.addStatement(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.prepareCall(sql, type, concurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(autoGeneratedKeys), "executeUpate"), "HY092");
        }
        JtdsPreparedStatement stmt = new JtdsPreparedStatement(this, sql, 1003, 1007, autoGeneratedKeys == 1);
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        JtdsPreparedStatement stmt = new JtdsPreparedStatement(this, sql, type, concurrency, false);
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.prepareStatement(sql, type, concurrency);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "prepareStatement"), "HY092");
        }
        if (columnIndexes.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolindex", "prepareStatement"), "HY092");
        }
        return this.prepareStatement(sql, 1);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setSavepoint(String)");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "prepareStatement"), "HY092");
        }
        if (columnNames.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolname", "prepareStatement"), "HY092");
        }
        return this.prepareStatement(sql, 1);
    }

    void clearSavepoints() {
    }

    private static class LoginTimer
    extends Thread {
        private SharedSocket socket;
        private int timeout;
        private boolean exitNow = false;

        LoginTimer(SharedSocket socket, int timeout) {
            this.socket = socket;
            this.timeout = timeout;
        }

        public void run() {
            while (!this.exitNow) {
                try {
                    Thread.sleep(this.timeout * 1000);
                    this.socket.forceClose();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        void stopTimer() {
            this.exitNow = true;
            this.interrupt();
        }
    }

    protected static class ProcEntry {
        private String name;
        private ColInfo[] colMetaData;
        private ParamInfo[] paramMetaData;

        protected ProcEntry() {
        }

        static /* synthetic */ ColInfo[] access$002(ProcEntry x0, ColInfo[] x1) {
            x0.colMetaData = x1;
            return x1;
        }

        static /* synthetic */ ParamInfo[] access$102(ProcEntry x0, ParamInfo[] x1) {
            x0.paramMetaData = x1;
            return x1;
        }
    }
}

