/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.am.bm;
import com.ibm.db2.jcc.am.cf;
import com.ibm.db2.jcc.am.dd;
import com.ibm.db2.jcc.am.fn;
import com.ibm.db2.jcc.am.jb;
import com.ibm.db2.jcc.am.qc;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.t2zos.T2zosConfiguration;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class DB2Driver
implements Driver {
    private static transient Hashtable dataSourceTable__ = null;
    private static final int DB2_PROTOCOL = 1;
    private static final int DB2_LEGACY_PROTOCOL = 2;
    private static final int CLOUDSCAPE_REMOTE_PROTOCOL = 3;
    private static final int IDS_PROTOCOL = 4;
    private static final int DEFAULT_CONNECTION_PROTOCOL = 5;
    private static DB2Driver registeredDriver__ = null;
    private static ClassLoader myClassLoader = DB2Driver.class.getClassLoader();
    public static final int jccTestBuild = 1;
    public static final int jccBetaBuild = 2;
    public static final int jccReleaseBuild = 3;

    public static ClassLoader getMyClassLoader() {
        return myClassLoader;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        StringTokenizer stringTokenizer;
        int n2;
        Connection connection = null;
        DB2SimpleDataSource dB2SimpleDataSource = null;
        if (jb.e != null) {
            throw jb.e;
        }
        if (properties == null) {
            properties = new Properties();
        }
        if ((n2 = DB2Driver.tokenizeProtocol(string, stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true))) == 0) {
            return null;
        }
        String string4 = null;
        if (n2 == 1 || n2 == 3 || n2 == 4) {
            try {
                string4 = stringTokenizer.nextToken(":/");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw dd.a((Object)this, null, qc.INVALID_URL_SYNTAX, (Object)string, "10033", (Throwable)noSuchElementException);
            }
        } else if (n2 == 2) {
            string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken(":/") : null;
        } else if (n2 == 5) {
            string4 = null;
        }
        if (n2 != 5 && string4 != null && string4.equals("/")) {
            Properties properties2;
            if (n2 == 2) {
                throw dd.a((Object)this, null, qc.DEPRECATED_PROTOCOL, (Object)string, "10034");
            }
            if (jb.gd || jb.jd || jb.kd) {
                throw dd.d(this, null, qc.T4_CONNECTION_NOT_SUPPORTED, "10035");
            }
            String string5 = DB2Driver.tokenizeServerName(stringTokenizer, string);
            int n3 = DB2Driver.tokenizeOptionalPortNumber(stringTokenizer, string);
            if (n3 == 0) {
                switch (n2) {
                    case 1: 
                    case 4: {
                        n3 = 446;
                        break;
                    }
                    case 3: {
                        n3 = 1527;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
            }
            String string6 = DB2Driver.tokenizeDatabase(stringTokenizer, string);
            if (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    throw dd.a((Object)this, null, qc.INVALID_URL_SYNTAX, (Object)string, "10036");
                }
                properties2 = DB2Driver.tokenizeURLProperties(stringTokenizer, string, properties);
            } else {
                properties2 = (Properties)properties.clone();
            }
            string3 = properties2.getProperty("user");
            string2 = properties2.getProperty("password");
            dB2SimpleDataSource = this.getDataSource(4, string5, n3, string6, string, properties2);
        } else {
            Properties properties3;
            String string7 = string4;
            if (T2Configuration.w != null) {
                throw T2Configuration.w;
            }
            if (T2Configuration.l == 1) {
                T2zosConfiguration.a(this, null, n2 == 5);
            }
            if (stringTokenizer.hasMoreTokens()) {
                if (string7 != null && string7.equals(":")) {
                    string7 = null;
                } else if (!stringTokenizer.nextToken(":").equals(":")) {
                    throw dd.a((Object)this, null, qc.INVALID_URL_SYNTAX, (Object)string, "10038");
                }
                properties3 = DB2Driver.tokenizeURLProperties(stringTokenizer, string, properties);
            } else {
                properties3 = (Properties)properties.clone();
            }
            string3 = properties3.getProperty("user");
            string2 = properties3.getProperty("password");
            dB2SimpleDataSource = this.getDataSource(2, "", -1, string7, string, properties3);
        }
        connection = dB2SimpleDataSource.getConnection(string3, string2);
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true);
        int n2 = DB2Driver.tokenizeProtocol(string, stringTokenizer);
        return n2 != 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfoArray[0].description = bm.d("006");
        driverPropertyInfoArray[1].description = bm.d("007");
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1].required = false;
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public int getJCCBuildNumber() {
        return this.getJccBuildNumber();
    }

    public int getJccBuildNumber() {
        return 85;
    }

    public int getJCCBuildCertification() {
        return this.getJccBuildCertification();
    }

    public int getJccBuildCertification() {
        return 3;
    }

    public String[] getJCCCompatibleJREVersions() {
        return this.getJccCompatibleJREVersions();
    }

    public String[] getJccCompatibleJREVersions() {
        return jb.ec;
    }

    private static int tokenizeProtocol(String string, StringTokenizer stringTokenizer) throws SQLException {
        if (string == null) {
            return 0;
        }
        if (stringTokenizer == null) {
            return 0;
        }
        try {
            String string2 = stringTokenizer.nextToken(":");
            if (!string2.equals("jdbc")) {
                return 0;
            }
            if (!stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            String string3 = stringTokenizer.nextToken(":");
            int n2 = 0;
            if (string3.equals("db2")) {
                n2 = 1;
            } else if (string3.equals("db2os390") || string3.equals("db2os390sqlj")) {
                n2 = 2;
            } else if (string3.equals("db2j") || string3.equals("derby")) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    return 0;
                }
                if (!stringTokenizer.nextToken(":").equals("net")) {
                    return 0;
                }
                n2 = 3;
            } else if (string3.equals("ids") || string3.equals("informix-sqli")) {
                n2 = 4;
            } else if (string3.equals("default")) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    return 0;
                }
                if (!stringTokenizer.nextToken(":").equals("connection")) {
                    return 0;
                }
                n2 = 5;
            } else {
                return 0;
            }
            if (n2 != 5 && !stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            return n2;
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            if (!stringTokenizer.nextToken("/").equals("/")) {
                throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10041");
            }
            String string2 = stringTokenizer.nextToken(":/");
            if (string2.charAt(0) == '[') {
                String string3 = stringTokenizer.nextToken("]");
                String string4 = string2.substring(1) + string3;
                stringTokenizer.nextToken(":/");
                return string4;
            }
            return string2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10042", (Throwable)noSuchElementException);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            String string2 = stringTokenizer.nextToken(":/");
            if (string2.equals(":")) {
                String string3 = stringTokenizer.nextToken("/");
                if (!stringTokenizer.nextToken("/").equals("/")) {
                    throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10043");
                }
                return Integer.parseInt(string3);
            }
            if (string2.equals("/")) {
                return 0;
            }
            throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10044");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10045", (Throwable)noSuchElementException);
        }
    }

    private static String tokenizeDatabase(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            String string2 = stringTokenizer.nextToken("/;:\"");
            if (string2.equals("\"")) {
                string2 = stringTokenizer.nextToken("\"");
                String string3 = stringTokenizer.nextToken("\"");
                if (!string3.equals("\"")) {
                    throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10046");
                }
            }
            return string2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10047", (Throwable)noSuchElementException);
        }
    }

    private static Properties tokenizeURLProperties(StringTokenizer stringTokenizer, String string, Properties properties) throws SQLException {
        Properties properties2 = (Properties)properties.clone();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                do {
                    string2 = stringTokenizer.nextToken(";=");
                    if (stringTokenizer.hasMoreTokens()) continue;
                    if (!string2.equals(";")) {
                        throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, new Object[]{string}, "12601");
                    }
                    return properties2;
                } while (string2.equals(";"));
                if (!stringTokenizer.nextToken("=").equals("=")) {
                    throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10048");
                }
                String string3 = stringTokenizer.nextToken(";");
                if (!stringTokenizer.nextToken(";").equals(";")) {
                    throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX_NEED_SEMICOLON, new Object[]{string, string3}, "10049");
                }
                if (properties.getProperty(string2) != null) {
                    throw dd.a(DB2Driver.class, null, qc.PROPERTIES_CANNOT_BE_OVERRIDDEN, (Object)string, "10050");
                }
                properties2.setProperty(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw dd.a(DB2Driver.class, null, qc.INVALID_URL_SYNTAX, (Object)string, "10051", (Throwable)noSuchElementException);
        }
        return properties2;
    }

    protected void deregisterDriver() {
        try {
            if (registeredDriver__ != null) {
                DriverManager.deregisterDriver(registeredDriver__);
                registeredDriver__ = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DB2SimpleDataSource getDataSource(int n2, String string, int n3, String string2, String string3, Properties properties) throws SQLException {
        int n4;
        PrintWriter printWriter = DriverManager.getLogWriter();
        try {
            n4 = DB2BaseDataSource.getTraceLevel(properties);
        }
        catch (NumberFormatException numberFormatException) {
            throw dd.a((Object)this, null, qc.UNABLE_TO_READ_TRACE_LEVEL, "10039", (Throwable)numberFormatException);
        }
        if (dataSourceTable__ == null) {
            dataSourceTable__ = new Hashtable();
        }
        properties.remove("password");
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = set.iterator();
        while (object.hasNext()) {
            linkedList.add(object.next().toString());
        }
        Collections.sort(linkedList);
        object = linkedList.toString() + string + n3 + string2 + n2;
        DB2SimpleDataSource dB2SimpleDataSource = (DB2SimpleDataSource)dataSourceTable__.get(object);
        if (dB2SimpleDataSource == null) {
            dB2SimpleDataSource = new DB2SimpleDataSource();
            dB2SimpleDataSource.initProperties(properties);
            dB2SimpleDataSource.setDriverType(n2);
            if (properties.containsKey("maxTransportObjects")) {
                dB2SimpleDataSource.setMaxTransportObjects(Integer.parseInt(properties.getProperty("maxTransportObjects")));
            }
            if (!properties.containsKey("serverName")) {
                dB2SimpleDataSource.setServerName(string);
            }
            if (!properties.containsKey("portNumber")) {
                dB2SimpleDataSource.setPortNumber(n3);
            }
            if (!properties.containsKey("databaseName")) {
                dB2SimpleDataSource.setDatabaseName(string2);
            }
            dataSourceTable__.put(object, dB2SimpleDataSource);
            if (!jb.Jb && printWriter != null && (0x40000 & n4) != 0) {
                PrintWriter printWriter2 = printWriter;
                synchronized (printWriter2) {
                    String string4 = "[jcc][time:" + cf.h() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + 10 + "]" + " DataSource created.  Table size: " + dataSourceTable__.size();
                    printWriter.println(string4);
                }
            }
        } else if (!jb.Jb && printWriter != null && (0x40000 & n4) != 0) {
            PrintWriter printWriter3 = printWriter;
            synchronized (printWriter3) {
                String string5 = "[jcc][time:" + cf.h() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + 10 + "]" + " DataSource retrieved.  Table size: " + dataSourceTable__.size();
                printWriter.println(string5);
            }
        }
        if (!properties.containsKey("loginTimeout")) {
            dB2SimpleDataSource.setLoginTimeout(DriverManager.getLoginTimeout());
        }
        if (printWriter != null) {
            dB2SimpleDataSource.setLogWriter(printWriter);
        }
        return dB2SimpleDataSource;
    }

    static {
        jb.class.getClass();
        try {
            registeredDriver__ = new DB2Driver();
            DriverManager.registerDriver(registeredDriver__);
        }
        catch (SQLException sQLException) {
            jb.e = fn.a(dd.a(DB2Driver.class, null, qc.ERROR_REGISTER_WITH_DRIVER_MGR, "10032"), jb.e);
        }
    }
}

