/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.coleta.validador;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidadorXMLHelper {
    private static final Logger log = LoggerFactory.getLogger(ValidadorXMLHelper.class);
    private DocumentBuilder documentBuilder;
    private XPath xpath;
    private List<String> parseErrors = new ArrayList<String>();

    public ValidadorXMLHelper() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setFeature("http://xml.org/sax/features/validation", true);
            dbf.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.documentBuilder = dbf.newDocumentBuilder();
            this.documentBuilder.setErrorHandler(new MyErrorHandler());
            this.documentBuilder.setEntityResolver(new MyEntityResolver());
        }
        catch (ParserConfigurationException e) {
            log.error("Falha ao obter DocumentBuilder.", e);
            throw new RuntimeException(e);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xpath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                return "http://www.lexml.gov.br/oai_lexml";
            }

            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        this.parseErrors.clear();
        return this.documentBuilder.parse(is);
    }

    public String getAttribute(Node node, String attrName) {
        Node attr = node.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            return attr.getTextContent();
        }
        return null;
    }

    public Integer getAttributeAsInteger(Node node, String attrName) {
        String val = this.getAttribute(node, attrName);
        if (!StringUtils.isEmpty(val)) {
            return Integer.parseInt(val);
        }
        return null;
    }

    public String getString(Node node, String expression) {
        try {
            return this.xpath.evaluate(expression, node);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public NodeList getNodeList(Node node, String expression) {
        try {
            return (NodeList)this.xpath.evaluate(expression, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getParseErrorsAsString() {
        if (this.parseErrors.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String error : this.parseErrors) {
            sb.append(error);
            sb.append("\n");
        }
        return sb.toString();
    }

    public class MyEntityResolver
    implements EntityResolver {
        private Pattern PATTERN = Pattern.compile("([^/]+\\.xsd)$", 2);
        private EntityResolver defaultHandler = new DefaultHandler();

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Matcher m = this.PATTERN.matcher(systemId);
            if (m.find()) {
                String resourceName = "/xsd/" + m.group(1);
                return new InputSource(this.getClass().getResourceAsStream(resourceName));
            }
            return this.defaultHandler.resolveEntity(publicId, systemId);
        }
    }

    public class MyErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException exception) throws SAXException {
            ValidadorXMLHelper.this.parseErrors.add(exception.getMessage());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.error(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.error(exception);
        }
    }
}

