/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.ReflectHelper;
import org.xml.sax.EntityResolver;

public class ConfigurationTask
extends Task {
    private List fileSets = new ArrayList();
    private Configuration cfg;
    private File configurationFile;
    private File propertyFile;
    protected String entityResolver;
    private String namingStrategy;

    public ConfigurationTask() {
        this.setDescription("Standard Configuration");
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public final Configuration getConfiguration() {
        if (this.cfg == null) {
            this.cfg = this.createConfiguration();
            this.doConfiguration(this.cfg);
            this.cfg.buildMappings();
        }
        return this.cfg;
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected void doConfiguration(Configuration configuration) {
        Object object;
        Class resolver;
        this.validateParameters();
        if (this.entityResolver != null) {
            try {
                resolver = ReflectHelper.classForName(this.entityResolver, ((Object)((Object)this)).getClass());
                object = resolver.newInstance();
                configuration.setEntityResolver((EntityResolver)object);
                this.getProject().log("Using " + this.entityResolver + " as entity resolver");
            }
            catch (Exception e) {
                throw new BuildException("Could not create or find " + this.entityResolver + " class to use for entity resolvement");
            }
        }
        if (this.namingStrategy != null) {
            try {
                resolver = ReflectHelper.classForName(this.namingStrategy, ((Object)((Object)this)).getClass());
                object = resolver.newInstance();
                configuration.setNamingStrategy((NamingStrategy)object);
                this.getProject().log("Using " + this.namingStrategy + " as naming strategy");
            }
            catch (Exception e) {
                throw new BuildException("Could not create or find " + this.namingStrategy + " class to use for naming strategy");
            }
        }
        if (this.configurationFile != null) {
            configuration.configure(this.configurationFile);
        }
        this.addMappings(this.getFiles());
        Properties p = this.getProperties();
        if (p != null) {
            Properties overrides = new Properties();
            overrides.putAll((Map<?, ?>)configuration.getProperties());
            overrides.putAll((Map<?, ?>)p);
            configuration.setProperties(overrides);
        }
    }

    protected Properties getProperties() {
        if (this.propertyFile != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.propertyFile));
                return properties;
            }
            catch (FileNotFoundException e) {
                throw new BuildException(this.propertyFile + " not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("Problem while loading " + this.propertyFile, (Throwable)e);
            }
        }
        return null;
    }

    protected void validateParameters() throws BuildException {
    }

    private void addMappings(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File filename = files[i];
            boolean added = this.addFile(filename);
            if (added) continue;
            this.log(filename + " not added to Configuration", 3);
        }
    }

    protected boolean addFile(File filename) {
        try {
            if (filename.getName().endsWith(".jar")) {
                this.cfg.addJar(filename);
                return true;
            }
            this.cfg.addFile(filename);
            return true;
        }
        catch (HibernateException he) {
            throw new BuildException("Failed in building configuration when adding " + filename, (Throwable)he);
        }
    }

    private File[] getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        Iterator i = this.fileSets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            for (int j = 0; j < dsFiles.length; ++j) {
                File f = new File(dsFiles[j]);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(f);
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setEntityResolver(String entityResolverName) {
        this.entityResolver = entityResolverName;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

