/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml;

import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.profileLexml.ConfiguracaoProvedorDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class LexMLUtil {
    private static Logger logger = Logger.getLogger(LexMLUtil.class.getName());
    private static Properties jpa_properties = null;
    private static boolean desenvolvimento = !new File("../etc").isDirectory();

    public static long nowInMillisGMT() {
        Calendar c = Calendar.getInstance(Locale.getDefault());
        return c.getTimeInMillis();
    }

    public static Properties getJPAProperties() throws ConfigFailedException {
        if (null != jpa_properties) {
            return jpa_properties;
        }
        jpa_properties = new Properties();
        logger.debug("Carregando properties do arquivo: lexml-db.properties");
        InputStream isProperties = null;
        try {
            isProperties = LexMLUtil.class.getResourceAsStream("/lexml-db.properties");
            jpa_properties.load(isProperties);
            isProperties.close();
        }
        catch (FileNotFoundException e1) {
            logger.error("Arquivo n\u00e3o encontrado: lexml-db.properties");
            throw new ConfigFailedException("Arquivo n\u00e3o encontrado: lexml-db.properties", e1);
        }
        catch (IOException e2) {
            logger.error("Erro de I/O ao carregar arquivo lexml-db.properties");
            throw new ConfigFailedException("Erro de I/O ao carregar arquivo lexml-db.properties", e2);
        }
        if (null == isProperties) {
            logger.error("N\u00e3o foi poss\u00edvel ler arquivo de properties a partir do getInputStreamFromLexMLHome");
            throw new ConfigFailedException("N\u00e3o foi poss\u00edvel ler arquivo de properties a partir do getInputStreamFromLexMLHome");
        }
        logger.debug("Arquivo de properties carregado com sucesso.");
        InputStream is = LexMLUtil.class.getResourceAsStream("/hibernate.properties");
        if (is != null) {
            try {
                jpa_properties.load(is);
                is.close();
            }
            catch (IOException e) {
                logger.error("Falha ao ler hibernate.properties", e);
            }
        }
        return jpa_properties;
    }

    public static ConfiguracaoProvedorDocument readConfiguracaoProvedor(File file) throws NamingException, FileNotFoundException, ConfigFailedException {
        return LexMLUtil.readConfiguracaoProvedor(new FileInputStream(file), file.getName());
    }

    public static ConfiguracaoProvedorDocument readConfiguracaoProvedor(String p_file) throws NamingException, FileNotFoundException, ConfigFailedException {
        InputStream isPerfil = LexMLUtil.class.getResourceAsStream("/" + p_file);
        return LexMLUtil.readConfiguracaoProvedor(isPerfil, p_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfiguracaoProvedorDocument readConfiguracaoProvedor(InputStream isPerfil, String p_file) throws NamingException, FileNotFoundException, ConfigFailedException {
        ConfiguracaoProvedorDocument confProvedor = null;
        if (null == isPerfil) return confProvedor;
        XmlOptions xmlOpt = new XmlOptions();
        xmlOpt.setLoadStripComments();
        xmlOpt.setSaveNoXmlDecl();
        xmlOpt.setSavePrettyPrintIndent(3);
        xmlOpt.setLoadStripProcinsts();
        xmlOpt.setLoadStripProcinsts();
        xmlOpt.setSaveAggressiveNamespaces();
        ArrayList validationErrors = new ArrayList();
        xmlOpt.setErrorListener(validationErrors);
        try {
            confProvedor = ConfiguracaoProvedorDocument.Factory.parse(isPerfil, xmlOpt);
            if (confProvedor.validate(xmlOpt)) return confProvedor;
            logger.error("Validate do XMLBeans falhou para: " + p_file);
            return confProvedor;
        }
        catch (XmlException e) {
            throw new ConfigFailedException("Erro de XML ao abrir o arquivo " + p_file, e);
        }
        catch (IOException e) {
            throw new ConfigFailedException("N\u00e3o foi poss\u00edvel abrir o arquivo " + p_file, e);
        }
        finally {
            block16: {
                try {
                    isPerfil.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (validationErrors.size() <= 0) break block16;
                    Iterator iter = validationErrors.iterator();
                    while (iter.hasNext()) {
                        logger.error(iter.next().toString());
                    }
                    throw new ConfigFailedException("O arquivo " + p_file + " n\u00e3o \u00e9 um arquivo de peril v\u00e1lido");
                }
            }
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        byte[] buffer = new byte[102400];
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        int i = 0;
        while ((i = in.read(buffer)) > 0) {
            out.write(buffer, 0, i);
        }
        in.close();
        out.close();
    }

    public static boolean isDesenvolvimento() {
        return desenvolvimento;
    }

    public static File getPathJpaProperties() {
        File dir2 = LexMLUtil.isDesenvolvimento() ? new File("target/classes") : new File("../etc");
        return new File(dir2, "lexml-db.properties");
    }

    public static File getPathPerfilNodoBorda() {
        File dir2 = LexMLUtil.isDesenvolvimento() ? new File("target/classes") : new File("../etc");
        return new File(dir2, "lexml_nbconfig.xml");
    }

    public static void validaArquivoPerfil(File file) throws Exception {
        try {
            LexMLUtil.readConfiguracaoProvedor(file);
        }
        catch (Exception e) {
            throw new Exception("Arquivo de configuracao lexml_nbconfig.xml inv\u00e1lido.", e);
        }
    }
}

