/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class BodyInstruction
extends TemplateElement {
    private List bodyParameters;

    BodyInstruction(List bodyParameters) {
        this.bodyParameters = bodyParameters;
    }

    List getBodyParameters() {
        return this.bodyParameters;
    }

    void accept(Environment env) throws IOException, TemplateException {
        Context bodyContext = new Context(env);
        env.visit(bodyContext);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#nested");
        if (this.bodyParameters != null) {
            for (int i = 0; i < this.bodyParameters.size(); ++i) {
                buf.append(' ');
                buf.append(this.bodyParameters.get(i));
            }
        }
        buf.append('>');
        return buf.toString();
    }

    public String getDescription() {
        return "nested macro content";
    }

    class Context
    implements LocalContext {
        Macro.Context invokingMacroContext;
        Environment.Namespace bodyVars;

        Context(Environment env) throws TemplateException {
            this.invokingMacroContext = env.getCurrentMacroContext();
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            if (BodyInstruction.this.bodyParameters != null) {
                for (int i = 0; i < BodyInstruction.this.bodyParameters.size(); ++i) {
                    Expression exp = (Expression)BodyInstruction.this.bodyParameters.get(i);
                    TemplateModel tm = exp.getAsTemplateModel(env);
                    if (bodyParameterNames == null || i >= bodyParameterNames.size()) continue;
                    String bodyParameterName = (String)bodyParameterNames.get(i);
                    if (this.bodyVars == null) {
                        this.bodyVars = env.new Environment.Namespace();
                    }
                    this.bodyVars.put(bodyParameterName, tm);
                }
            }
        }

        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.bodyVars == null ? null : this.bodyVars.get(name);
        }

        public Set getLocalVariableNames() {
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            if (bodyParameterNames == null) {
                return Collections.EMPTY_SET;
            }
            return new HashSet(bodyParameterNames);
        }
    }
}

