/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.Cookie;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.SerializableCookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageInfo
implements Serializable {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$constructs$web$PageInfo == null ? (class$net$sf$ehcache$constructs$web$PageInfo = PageInfo.class$("net.sf.ehcache.constructs.web.PageInfo")) : class$net$sf$ehcache$constructs$web$PageInfo).getName());
    private static final int FOUR_KB = 4196;
    private static final int GZIP_MAGIC_NUMBER_BYTE_1 = 31;
    private static final int GZIP_MAGIC_NUMBER_BYTE_2 = -117;
    private final ArrayList headers = new ArrayList();
    private final ArrayList serializableCookies = new ArrayList();
    private String contentType;
    private byte[] gzippedBody;
    private byte[] ungzippedBody;
    private int statusCode;
    private boolean storeGzipped;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$web$PageInfo;

    public PageInfo(int statusCode, String contentType, Collection headers, Collection cookies, byte[] body, boolean storeGzipped) throws AlreadyGzippedException {
        this.headers.addAll(headers);
        this.headers.remove("Content-Encoding");
        this.contentType = contentType;
        this.storeGzipped = storeGzipped;
        this.statusCode = statusCode;
        this.extractCookies(cookies);
        try {
            if (storeGzipped) {
                this.ungzippedBody = null;
                this.gzippedBody = this.isBodyParameterGzipped() ? body : this.gzip(body);
            } else {
                if (this.isBodyParameterGzipped()) {
                    throw new IllegalArgumentException("Non gzip content has been gzipped.");
                }
                this.ungzippedBody = body;
            }
        }
        catch (IOException e) {
            LOG.error("Error ungzipping gzipped body", e);
        }
    }

    private void extractCookies(Collection cookies) {
        Iterator iterator = cookies.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            this.serializableCookies.add(new SerializableCookie(cookie));
        }
    }

    private byte[] gzip(byte[] ungzipped) throws IOException, AlreadyGzippedException {
        if (PageInfo.isGzipped(ungzipped)) {
            throw new AlreadyGzippedException("The byte[] is already gzipped. It should not be gzipped again.");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
        gzipOutputStream.write(ungzipped);
        gzipOutputStream.close();
        return bytes.toByteArray();
    }

    private boolean isBodyParameterGzipped() {
        for (int i = 0; i < this.headers.size(); ++i) {
            String[] keyValuePair = (String[])this.headers.get(i);
            if (!keyValuePair[1].equals("gzip")) continue;
            return true;
        }
        return false;
    }

    public static boolean isGzipped(byte[] candidate) {
        if (candidate == null || candidate.length < 2) {
            return false;
        }
        return candidate[0] == 31 && candidate[1] == -117;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getGzippedBody() {
        if (this.storeGzipped) {
            return this.gzippedBody;
        }
        return null;
    }

    public List getHeaders() {
        return this.headers;
    }

    public List getSerializableCookies() {
        return this.serializableCookies;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getUngzippedBody() throws IOException {
        if (this.storeGzipped) {
            return this.ungzip(this.gzippedBody);
        }
        return this.ungzippedBody;
    }

    private byte[] ungzip(byte[] gzipped) throws IOException {
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(gzipped));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(gzipped.length);
        byte[] buffer = new byte[4196];
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inputStream.read(buffer, 0, 4196);
            if (bytesRead == -1) continue;
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        byte[] ungzipped = byteArrayOutputStream.toByteArray();
        inputStream.close();
        byteArrayOutputStream.close();
        return ungzipped;
    }

    public boolean hasGzippedBody() {
        return this.gzippedBody != null;
    }

    public boolean hasUngzippedBody() {
        return this.ungzippedBody != null;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

