/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLQueryParser;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCustomQuery
implements CustomQuery {
    public static final Logger log = LoggerFactory.getLogger(SQLCustomQuery.class);
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameterBindPoints = new HashMap();
    private final List customQueryReturns = new ArrayList();

    public String getSQL() {
        return this.sql;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameterBindPoints;
    }

    public List getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public SQLCustomQuery(String sqlQuery, NativeSQLQueryReturn[] queryReturns, Collection additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        log.trace("starting processing of sql query [" + sqlQuery + "]");
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, factory);
        SQLQueryReturnProcessor.ResultAliasContext aliasContext = processor.process();
        SQLQueryParser parser = new SQLQueryParser(sqlQuery, new ParserContext(aliasContext));
        this.sql = parser.process();
        this.namedParameterBindPoints.putAll(parser.getNamedParameters());
        this.customQueryReturns.addAll(processor.generateCustomReturns(parser.queryHasAliases()));
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
    }

    private static class ParserContext
    implements SQLQueryParser.ParserContext {
        private final SQLQueryReturnProcessor.ResultAliasContext aliasContext;

        public ParserContext(SQLQueryReturnProcessor.ResultAliasContext aliasContext) {
            this.aliasContext = aliasContext;
        }

        public boolean isEntityAlias(String alias) {
            return this.getEntityPersisterByAlias(alias) != null;
        }

        public SQLLoadable getEntityPersisterByAlias(String alias) {
            return this.aliasContext.getEntityPersister(alias);
        }

        public String getEntitySuffixByAlias(String alias) {
            return this.aliasContext.getEntitySuffix(alias);
        }

        public boolean isCollectionAlias(String alias) {
            return this.getCollectionPersisterByAlias(alias) != null;
        }

        public SQLLoadableCollection getCollectionPersisterByAlias(String alias) {
            return this.aliasContext.getCollectionPersister(alias);
        }

        public String getCollectionSuffixByAlias(String alias) {
            return this.aliasContext.getCollectionSuffix(alias);
        }

        public Map getPropertyResultsMapByAlias(String alias) {
            return this.aliasContext.getPropertyResultsMap(alias);
        }
    }
}

