/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.QueryExporter;
import org.hibernate.util.StringHelper;

public class QueryExporterTask
extends ExporterTask {
    private String query = "";
    private String filename;
    List queries = new ArrayList();

    public QueryExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    protected Exporter configureExporter(Exporter exp) {
        QueryExporter exporter = (QueryExporter)exp;
        ArrayList<String> queryStrings = new ArrayList<String>();
        if (StringHelper.isNotEmpty(this.query)) {
            queryStrings.add(this.query);
        }
        Iterator iter = this.queries.iterator();
        while (iter.hasNext()) {
            HQL hql = (HQL)iter.next();
            if (!StringHelper.isNotEmpty(hql.query)) continue;
            queryStrings.add(hql.query);
        }
        exporter.setQueries(queryStrings);
        exporter.setFilename(this.filename);
        super.configureExporter(exp);
        return exporter;
    }

    public void validateParameters() {
        super.validateParameters();
        if (StringHelper.isEmpty(this.query) && this.queries.isEmpty()) {
            throw new BuildException("Need to specify at least one query.");
        }
        Iterator iter = this.queries.iterator();
        while (iter.hasNext()) {
            HQL hql = (HQL)iter.next();
            if (!StringHelper.isEmpty(hql.query)) continue;
            throw new BuildException("Query must not be empty");
        }
    }

    protected Exporter createExporter() {
        QueryExporter exporter = new QueryExporter();
        return exporter;
    }

    public void addText(String text) {
        if (StringHelper.isNotEmpty(text)) {
            this.query = this.query + QueryExporterTask.trim(text);
        }
    }

    private static String trim(String text) {
        return text.trim();
    }

    public HQL createHql() {
        HQL hql = new HQL();
        this.queries.add(hql);
        return hql;
    }

    public void setDestFile(String filename) {
        this.filename = filename;
    }

    public void execute() {
        this.parent.log("Executing: [" + this.query + "]");
        super.execute();
    }

    public String getName() {
        return "query (Executes queries)";
    }

    public static class HQL {
        String query = "";

        public void addText(String text) {
            if (StringHelper.isNotEmpty(text)) {
                this.query = this.query + QueryExporterTask.trim(text);
            }
        }
    }
}

